/*
 * Decompiled with CFR 0.152.
 */
package phex.dialogues;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import phex.common.ServiceManager;
import phex.gui.common.GUIUtils;
import phex.gui.common.MainFrame;
import phex.interfaces.IFind;

public class DlgResultFind
extends JDialog
implements KeyListener {
    private JTextField mTextValue;
    private JCheckBox mMatchCase;
    private JRadioButton mFindUp;
    private JRadioButton mFindDown;
    private IFind mSearchCallback;

    public DlgResultFind(MainFrame frame, IFind searchCallback) {
        super((Frame)frame, true);
        this.mSearchCallback = searchCallback;
        this.setTitle("Find");
        String oldText = "";
        this.setDefaultCloseOperation(1);
        JPanel outerPanel = new JPanel();
        outerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(10, 16, 10, 16)));
        outerPanel.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel(new GridLayout(3, 1, 0, 0));
        JLabel labelFind = new JLabel("Find Text:");
        centerPanel.add(labelFind);
        this.mTextValue = new JTextField(oldText, 20);
        this.mTextValue.setText(ServiceManager.sCfg.mFindText);
        labelFind.setDisplayedMnemonic('T');
        labelFind.setLabelFor(this.mTextValue);
        centerPanel.add(this.mTextValue);
        JPanel optionPanel = new JPanel(new GridLayout(1, 3, 0, 8));
        this.mMatchCase = new JCheckBox("Match case      ", ServiceManager.sCfg.mFindMatchCase);
        this.mMatchCase.setMnemonic('C');
        this.mFindUp = new JRadioButton("Find Up", !ServiceManager.sCfg.mFindDown);
        this.mFindUp.setMnemonic('U');
        this.mFindDown = new JRadioButton("Find Down", ServiceManager.sCfg.mFindDown);
        this.mFindDown.setMnemonic('N');
        ButtonGroup group = new ButtonGroup();
        group.add(this.mFindUp);
        group.add(this.mFindDown);
        optionPanel.add(this.mMatchCase);
        optionPanel.add(this.mFindUp);
        optionPanel.add(this.mFindDown);
        centerPanel.add(optionPanel);
        JPanel rightPanel = new JPanel(new BorderLayout());
        JPanel buttonOuterPanel = new JPanel(new FlowLayout(4));
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1, 0, 6));
        JButton find = new JButton("Find Next");
        JButton done = new JButton("Done");
        find.setMnemonic('F');
        done.setMnemonic('D');
        buttonPanel.add(find);
        buttonPanel.add(done);
        buttonOuterPanel.add(buttonPanel);
        rightPanel.add("Center", new JLabel("    "));
        rightPanel.add("East", buttonOuterPanel);
        outerPanel.add("Center", centerPanel);
        outerPanel.add("East", rightPanel);
        this.getContentPane().add("Center", outerPanel);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("Done")) {
                    DlgResultFind.this.doDone();
                } else if (event.getActionCommand().equals("Find Next")) {
                    DlgResultFind.this.doFind();
                }
            }
        };
        find.addActionListener(actionListener);
        done.addActionListener(actionListener);
        this.addKeyListener(this);
        this.pack();
        GUIUtils.centerWindowOnScreen(this);
    }

    private void doDone() {
        this.setVisible(false);
        this.dispose();
    }

    private void doFind() {
        ServiceManager.sCfg.mFindMatchCase = this.mMatchCase.isSelected();
        ServiceManager.sCfg.mFindDown = this.mFindDown.isSelected();
        ServiceManager.sCfg.mFindText = this.mTextValue.getText();
        this.mSearchCallback.findInResult(this.mMatchCase.isSelected(), this.mFindDown.isSelected(), this.mTextValue.getText());
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.doDone();
        } else if (e.getKeyCode() == 10) {
            this.doFind();
        }
    }

    public void keyTyped(KeyEvent e) {
    }
}

