/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.URN;
import phex.utils.URLCodecUtils;

public class MagnetData {
    private String exactTopic;
    private String exactSubstitute;
    private List acceptableSubstituteList = new ArrayList();
    private String displayName;
    private String keywordTopic;

    private MagnetData() {
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getKeywordTopic() {
        return this.keywordTopic;
    }

    public void setKeywordTopic(String keywordTopic) {
        this.keywordTopic = keywordTopic;
    }

    public String getExactSubstitute() {
        return this.exactSubstitute;
    }

    public void setExactSubstitute(String exactSubstitute) {
        this.exactSubstitute = exactSubstitute;
    }

    public List getAcceptableSubstituteList() {
        return this.acceptableSubstituteList;
    }

    private void addAcceptableSubstitute(String acceptableSubstitutes) {
        this.acceptableSubstituteList.add(acceptableSubstitutes);
    }

    public String getExactTopic() {
        return this.exactTopic;
    }

    public void setExactTopic(String exactTopicStr) {
        this.exactTopic = exactTopicStr;
    }

    public static String lookupFileName(MagnetData magnetData) {
        if (magnetData.displayName != null) {
            return magnetData.displayName;
        }
        if (magnetData.keywordTopic != null) {
            return magnetData.keywordTopic;
        }
        URN urn = MagnetData.lookupSHA1URN(magnetData);
        if (urn != null) {
            return "Magnet download " + urn.getAsString();
        }
        return "Unknown Magnet download";
    }

    public static String lookupSearchName(MagnetData magnetData) {
        if (magnetData.keywordTopic != null) {
            return magnetData.keywordTopic;
        }
        if (magnetData.displayName != null) {
            return magnetData.displayName;
        }
        return "";
    }

    public static URN lookupSHA1URN(MagnetData magnetData) {
        if (magnetData.exactTopic != null && URN.isValidURN(magnetData.exactTopic)) {
            return new URN(magnetData.exactTopic);
        }
        if (magnetData.exactSubstitute != null && URN.isValidURN(magnetData.exactSubstitute)) {
            return new URN(magnetData.exactSubstitute);
        }
        Iterator asIterator = magnetData.acceptableSubstituteList.iterator();
        while (asIterator.hasNext()) {
            String as = (String)asIterator.next();
            if (!URN.isValidURN(as)) continue;
            return new URN(as);
        }
        return null;
    }

    public static List lookupHttpURIs(MagnetData magnetData) {
        ArrayList<URI> urlList = new ArrayList<URI>();
        if (magnetData.exactTopic != null && magnetData.exactTopic.startsWith("http://")) {
            try {
                urlList.add(new URI(magnetData.exactTopic, false));
            }
            catch (URIException e) {
                // empty catch block
            }
        }
        if (magnetData.exactSubstitute != null && magnetData.exactSubstitute.startsWith("http://")) {
            try {
                urlList.add(new URI(magnetData.exactSubstitute, false));
            }
            catch (URIException e) {
                // empty catch block
            }
        }
        Iterator asIterator = magnetData.acceptableSubstituteList.iterator();
        while (asIterator.hasNext()) {
            String as = (String)asIterator.next();
            if (!as.startsWith("http://")) continue;
            try {
                urlList.add(new URI(as, false));
            }
            catch (URIException e) {}
        }
        return urlList;
    }

    public static MagnetData parseFromURI(URI uri) {
        String protocol = uri.getScheme();
        if (!"magnet".equals(protocol)) {
            return null;
        }
        MagnetData magnetData = new MagnetData();
        String urlQuery = uri.getEscapedQuery();
        StringTokenizer tokenizer = new StringTokenizer(urlQuery, "&");
        while (tokenizer.hasMoreTokens()) {
            String param = tokenizer.nextToken().trim();
            int seperatorIdx = param.indexOf("=");
            if (seperatorIdx == -1) continue;
            String key = param.substring(0, seperatorIdx);
            String value = param.substring(seperatorIdx + 1);
            value = URLCodecUtils.decodeURL(value);
            if (key.equals("xt")) {
                magnetData.setExactTopic(value);
                continue;
            }
            if (key.equals("xs")) {
                magnetData.setExactSubstitute(value);
                continue;
            }
            if (key.equals("as")) {
                magnetData.addAcceptableSubstitute(value);
                continue;
            }
            if (key.equals("dn")) {
                magnetData.setDisplayName(value);
                continue;
            }
            if (!key.equals("kt")) continue;
            magnetData.setKeywordTopic(value);
        }
        return magnetData;
    }
}

