/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.IOException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.download.PushHandler;
import phex.host.Host;
import phex.http.HttpClientFactory;
import phex.msg.GUID;
import phex.msg.MsgManager;
import phex.msg.PushRequestMsg;
import phex.net.presentation.SocketFacade;
import phex.statistic.UploadDownloadCountStatistic;
import phex.utils.NLogger;

public class PushRequestSleeper {
    private GUID clientGUID;
    private long fileIndex;
    private DestAddress[] pushProxyAddresses;
    private SocketFacade givenSocket;

    public PushRequestSleeper(GUID aClientGUID, long aFileIndex, DestAddress[] pushProxyAddresses) {
        this.clientGUID = aClientGUID;
        this.fileIndex = aFileIndex;
        this.pushProxyAddresses = pushProxyAddresses;
    }

    public GUID getGUID() {
        return this.clientGUID;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public synchronized boolean acceptGIVConnection(SocketFacade aGivenSocket, GUID givenGUID) {
        if (!this.clientGUID.equals(givenGUID)) {
            return false;
        }
        this.givenSocket = aGivenSocket;
        this.notify();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SocketFacade requestSocketViaPush() {
        boolean succ = false;
        try {
            if (this.pushProxyAddresses != null && this.pushProxyAddresses.length > 0) {
                succ = this.requestViaPushProxies();
            }
            if (!succ) {
                succ = this.requestViaPushRoute();
            }
            if (!succ) {
                SocketFacade socketFacade = null;
                return socketFacade;
            }
            try {
                this.wait(ServiceManager.sCfg.mPushTransferTimeout);
            }
            catch (InterruptedException exp) {
                Thread.currentThread().interrupt();
            }
            if (this.givenSocket == null) {
                SocketFacade socketFacade = null;
                return socketFacade;
            }
            SocketFacade socketFacade = this.givenSocket;
            return socketFacade;
        }
        finally {
            PushHandler.unregisterPushRequestSleeper(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestViaPushProxies() {
        DestAddress myAddress = NetworkManager.getInstance().getLocalAddress();
        String requestPart = "/gnet/push-proxy?guid=" + this.clientGUID.toHexString();
        if (this.pushProxyAddresses.length > 0) {
            UploadDownloadCountStatistic.pushDldPushProxyAttempts.increment(1);
        }
        for (int i = 0; i < this.pushProxyAddresses.length; ++i) {
            String urlStr = "http://" + this.pushProxyAddresses[i].getFullHostName() + requestPart;
            if (NLogger.isDebugEnabled("PUSH")) {
                NLogger.debug("PUSH", (Object)("PUSH via push proxy: " + urlStr));
            }
            HttpClient httpClient = HttpClientFactory.createHttpClient();
            httpClient.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(1, false));
            HeadMethod method = null;
            try {
                method = new HeadMethod(urlStr);
                method.addRequestHeader("X-Node", myAddress.getFullHostName());
                method.addRequestHeader("Cache-Control", "no-cache");
                method.addRequestHeader("Connection", "close");
                int responseCode = httpClient.executeMethod((HttpMethod)method);
                if (NLogger.isDebugEnabled("PUSH")) {
                    NLogger.debug("PUSH", (Object)("PUSH via push proxy response code: " + responseCode + " (" + urlStr + ")"));
                }
                if (responseCode != 202) continue;
                UploadDownloadCountStatistic.pushDldPushProxySuccess.increment(1);
                boolean bl = true;
                return bl;
            }
            catch (IOException exp) {
                if (!NLogger.isWarnEnabled("PUSH")) continue;
                NLogger.warn("PUSH", (Object)exp);
                continue;
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        return false;
    }

    private boolean requestViaPushRoute() {
        DestAddress localAddress = NetworkManager.getInstance().getLocalAddress();
        if (localAddress.getIpAddress() == null) {
            NLogger.warn("PUSH", (Object)"Local address has no IP to use for PUSH.");
            return false;
        }
        PushRequestMsg push = new PushRequestMsg(this.clientGUID, this.fileIndex, localAddress);
        Host returnHost = MsgManager.getInstance().getPushRouting(this.clientGUID);
        if (returnHost == null) {
            if (NLogger.isDebugEnabled("PUSH")) {
                NLogger.debug("PUSH", (Object)("No PUSH route for " + this.clientGUID + "."));
            }
            return false;
        }
        if (NLogger.isDebugEnabled("PUSH")) {
            NLogger.debug("PUSH", (Object)("Push route for " + this.clientGUID + " is " + returnHost));
        }
        returnHost.queueMessageToSend(push);
        return true;
    }
}

