/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import phex.common.format.TimeFormatUtils;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadConstants;
import phex.utils.Localizer;

public final class SWDownloadInfo
implements SWDownloadConstants {
    private SWDownloadInfo() {
    }

    public static String getDownloadFileStatusString(int status) {
        switch (status) {
            case 1: {
                return Localizer.getString("WaitingForDownload");
            }
            case 2: {
                return Localizer.getString("Downloading");
            }
            case 3: 
            case 6: {
                return Localizer.getString("Completed");
            }
            case 4: {
                return Localizer.getString("Stopped");
            }
            case 5: {
                return Localizer.getString("FileQueued");
            }
        }
        Object[] arguments = new Object[]{new Integer(status)};
        return Localizer.getFormatedString("UnrecognizedStatus", arguments);
    }

    public static String getDownloadCandidateStatusString(SWDownloadCandidate candidate) {
        short status = candidate.getStatus();
        switch (status) {
            case 10: {
                return Localizer.getString("CandidateIgnored") + " (" + Localizer.getString(candidate.getStatusReason()) + ").";
            }
            case 11: {
                Object[] arguments = new Object[]{new Long(candidate.getStatusTimeLeft() / 1000L), TimeFormatUtils.convertSecondsToTime((int)(candidate.getStatusTimeLeft() / 1000L))};
                return Localizer.getFormatedString("CandidateOffline", arguments);
            }
            case 12: {
                return Localizer.getString("WaitingForDownload");
            }
            case 14: {
                Object[] arguments = new Object[]{new Long(candidate.getStatusTimeLeft() / 1000L), TimeFormatUtils.convertSecondsToTime((int)(candidate.getStatusTimeLeft() / 1000L))};
                return Localizer.getFormatedString("HostBusy", arguments);
            }
            case 16: {
                Object[] arguments = new Object[]{new Long(candidate.getStatusTimeLeft() / 1000L)};
                return Localizer.getFormatedString("Connecting", arguments);
            }
            case 15: {
                Object[] arguments = new Object[]{TimeFormatUtils.convertSecondsToTime((int)(candidate.getStatusTimeLeft() / 1000L))};
                return Localizer.getFormatedString("RangeUnavailable", arguments);
            }
            case 18: {
                Object[] arguments = new Object[3];
                arguments[0] = candidate.getXQueueParameters().getPosition();
                arguments[1] = TimeFormatUtils.convertSecondsToTime((int)(candidate.getStatusTimeLeft() / 1000L));
                return Localizer.getFormatedString("RemotlyQueued", arguments);
            }
            case 13: {
                Object[] arguments = new Object[]{new Integer(candidate.getFailedConnectionTries()), new Long(candidate.getStatusTimeLeft() / 1000L), TimeFormatUtils.convertSecondsToTime((int)(candidate.getStatusTimeLeft() / 1000L))};
                return Localizer.getFormatedString("ConnectionFailed", arguments);
            }
            case 17: {
                Object[] arguments = new Object[]{new Long(candidate.getStatusTimeLeft() / 1000L)};
                return Localizer.getFormatedString("PushRequest", arguments);
            }
            case 19: {
                return Localizer.getFormatedString("Requesting", null);
            }
            case 20: {
                return Localizer.getFormatedString("Downloading", null);
            }
        }
        Object[] arguments = new Object[]{new Integer(status)};
        return Localizer.getFormatedString("UnrecognizedStatus", arguments);
    }
}

