/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.List;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.IpAddress;
import phex.connection.ConnectionFailedException;
import phex.connection.NetworkManager;
import phex.download.DownloadEngine;
import phex.download.DownloadStoppedException;
import phex.download.FileNotAvailableException;
import phex.download.HostBusyException;
import phex.download.PushHandler;
import phex.download.RangeUnavailableException;
import phex.download.ReconnectException;
import phex.download.RemotelyQueuedException;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadSet;
import phex.download.swarming.SwarmingManager;
import phex.host.UnusableHostException;
import phex.http.HTTPMessageException;
import phex.net.presentation.SocketFacade;
import phex.utils.NLogger;

public class SWDownloadWorker
implements Runnable {
    private boolean isTemporaryWorker;
    private boolean isRunning;
    private ThreadPool.Job threadJob;
    private DownloadEngine downloadEngine;
    private boolean insideCriticalSection;
    private boolean isDownloadStopped;

    public void setTemporaryWorker(boolean state) {
        this.isTemporaryWorker = state;
    }

    public boolean isTemporaryWorker() {
        return this.isTemporaryWorker;
    }

    public boolean isInsideCriticalSection() {
        return this.insideCriticalSection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        SwarmingManager swarmingMgr = SwarmingManager.getInstance();
        try {
            boolean isStopped;
            while (this.isRunning && !(isStopped = swarmingMgr.checkToStopWorker(this))) {
                List list = swarmingMgr.getCompletedDownloadFiles();
                this.moveDownloadFilesToDestination(list);
                this.isDownloadStopped = false;
                NLogger.debug("Download.Worker", (Object)(" - Allocating DownloadSet - " + this));
                SWDownloadSet downloadSet = swarmingMgr.allocateDownloadSet(this);
                if (downloadSet == null) {
                    if (!this.isTemporaryWorker) break;
                    try {
                        swarmingMgr.waitForNotify();
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                NLogger.debug("Download.Worker", (Object)("Allocated DownloadSet: " + downloadSet.toString() + " - " + this));
                try {
                    this.handleDownload(downloadSet);
                }
                finally {
                    if (downloadSet == null) continue;
                    NLogger.debug("Download.Worker", (Object)("Releasing DownloadSet: " + downloadSet.toString() + " - " + this));
                    downloadSet.releaseDownloadSet();
                }
            }
            swarmingMgr.notifyWorkerShoutdown(this, !this.isRunning);
        }
        catch (Throwable throwable) {
            swarmingMgr.notifyWorkerShoutdown(this, !this.isRunning);
            NLogger.debug("Download.Worker", (Object)("Download worker finished: " + this));
            throw throwable;
        }
        NLogger.debug("Download.Worker", (Object)("Download worker finished: " + this));
    }

    public void startWorker() {
        this.isRunning = true;
        this.threadJob = ThreadPool.getInstance().addJob(this, "SWDownloadWorker-" + Integer.toHexString(this.hashCode()));
        NLogger.debug("Download.Worker", (Object)("Started SWDownloadWorker " + this));
    }

    public void stopWorker() {
        NLogger.debug("Download.Worker", (Object)("Download worker has been instructed to stop running: " + this));
        this.isRunning = false;
        this.isDownloadStopped = true;
        this.stopDownloadInternal();
        Thread thread = this.threadJob.getAssociatedThread();
        if (thread != null) {
            thread.interrupt();
        }
    }

    public void waitTillFinished() {
        while (this.threadJob.getAssociatedThread() != null) {
            this.threadJob.waitForAssociatedThreadRelease();
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void stopDownloadInternal() {
        if (this.downloadEngine != null) {
            NLogger.debug("Download.Worker", (Object)("Download worker has been instructed to stop downloading: " + this));
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDownload(SWDownloadSet downloadSet) {
        NLogger.debug("Download.Worker", (Object)("handleDownload() with: " + downloadSet + " - " + this));
        SWDownloadFile downloadFile = downloadSet.getDownloadFile();
        SWDownloadCandidate downloadCandidate = downloadSet.getDownloadCandidate();
        if (downloadCandidate.getResourceURN() == null && downloadCandidate.getFileIndex() < 0L) {
            NLogger.warn("Download.Worker", (Object)("Download candidate has no associated file and URN is null:" + downloadCandidate));
            downloadCandidate.addToCandidateLog("Download candidate has no associated file and URN is null.");
            return;
        }
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        if (downloadCandidate.isPushNeeded()) {
            this.connectDownloadEngineViaPush(downloadSet, false);
        } else {
            this.connectDownloadEngine(downloadSet);
        }
        if (this.downloadEngine == null) {
            return;
        }
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        try {
            this.insideCriticalSection = true;
            this.startDownload(downloadSet);
        }
        catch (IOException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            downloadCandidate.setStatus((short)12);
            NLogger.debug("Download.Worker", (Object)downloadCandidate);
            NLogger.debug("Download.Worker", (Object)exp.toString(), (Throwable)exp);
        }
        finally {
            downloadFile.removeQueuedCandidate(downloadCandidate);
            this.stopDownloadInternal();
            NLogger.debug("Download.Worker", (Object)("Releasing DownloadSegment: " + downloadSet.toString() + " - " + this));
            downloadSet.releaseDownloadSegment();
            downloadFile.verifyStatus();
            if (downloadFile.isFileCompleted()) {
                downloadFile.moveToDestinationFile();
            }
            this.insideCriticalSection = false;
        }
    }

    private void connectDownloadEngine(SWDownloadSet downloadSet) {
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        NLogger.debug("Download.Worker", (Object)("connectDownloadEngine with: " + downloadSet + " - " + this));
        SWDownloadCandidate downloadCandidate = downloadSet.getDownloadCandidate();
        SWDownloadFile downloadFile = downloadSet.getDownloadFile();
        this.downloadEngine = null;
        this.downloadEngine = new DownloadEngine(downloadFile, downloadCandidate);
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        try {
            this.downloadEngine.connect(ServiceManager.sCfg.socketConnectTimeout);
        }
        catch (ConnectionFailedException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug("Download.Worker", (Object)exp.toString());
            this.connectDownloadEngineViaPush(downloadSet, true);
            return;
        }
        catch (SocketTimeoutException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug("Download.Worker", (Object)exp.toString());
            this.connectDownloadEngineViaPush(downloadSet, true);
            return;
        }
        catch (DownloadStoppedException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            downloadCandidate.setStatus((short)13);
            NLogger.debug("Download.Worker", (Object)exp.toString());
            this.stopDownloadInternal();
            return;
        }
        catch (IOException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.error("Download.Worker", (Object)("HardError at Host: " + downloadCandidate.getHostAddress() + " Vendor: " + downloadCandidate.getVendor()), (Throwable)exp);
            this.stopDownloadInternal();
            this.connectDownloadEngineViaPush(downloadSet, true);
            return;
        }
    }

    private void connectDownloadEngineViaPush(SWDownloadSet downloadSet, boolean failedBefore) {
        boolean isLANReachable;
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        NLogger.debug("Download.Worker", (Object)("connectDownloadEngineViaPush with: " + downloadSet + " - " + this));
        SWDownloadCandidate downloadCandidate = downloadSet.getDownloadCandidate();
        SWDownloadFile downloadFile = downloadSet.getDownloadFile();
        this.downloadEngine = null;
        IpAddress ipAddress = downloadCandidate.getHostAddress().getIpAddress();
        boolean bl = isLANReachable = ServiceManager.sCfg.connectedToLAN && ipAddress != null && ipAddress.isSiteLocalIP();
        if (!NetworkManager.getInstance().hasConnectedIncoming() && !isLANReachable) {
            NLogger.debug("Download.Worker", (Object)(this.toString() + downloadCandidate.toString() + " Cant PUSH -> I'm firewalled and candidate not reachable by LAN"));
            downloadCandidate.addToCandidateLog("Cant PUSH -> I'm firewalled and candidate not reachable by LAN");
            downloadCandidate.setStatus((short)13);
            if (downloadCandidate.isPushNeeded()) {
                downloadFile.markCandidateBad(downloadCandidate);
            }
            return;
        }
        if (downloadCandidate.getGUID() == null) {
            NLogger.debug("Download.Worker", (Object)(this.toString() + downloadCandidate.toString() + " Cant PUSH -> No candidate GUID."));
            downloadCandidate.addToCandidateLog("Cant PUSH -> No candidate GUID.");
            downloadCandidate.setStatus((short)13);
            return;
        }
        if (!this.isRunning || this.isDownloadStopped) {
            if (failedBefore) {
                downloadCandidate.setStatus((short)13);
            }
            return;
        }
        downloadCandidate.setStatus((short)17);
        SocketFacade socket = PushHandler.requestSocketViaPush(downloadCandidate);
        if (socket == null) {
            downloadCandidate.setStatus((short)13);
            if (downloadCandidate.isPushNeeded()) {
                downloadFile.markCandidateIgnored(downloadCandidate, "CandidateStatusReason_PushRouteFailed");
            }
            NLogger.debug("Download.Worker", (Object)("Push request fails for candidate: " + downloadCandidate));
            downloadCandidate.addToCandidateLog("Push request fails for candidate: " + downloadCandidate);
            return;
        }
        this.downloadEngine = new DownloadEngine(downloadFile, downloadCandidate);
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        try {
            this.downloadEngine.setSocket(socket);
        }
        catch (IOException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            downloadCandidate.setStatus((short)13);
            NLogger.error("Download.Worker", (Object)("HardError at Host: " + downloadCandidate.getHostAddress() + " Vendor: " + downloadCandidate.getVendor()), (Throwable)exp);
            this.stopDownloadInternal();
            return;
        }
    }

    private void exchangeHTTPHandshake(SWDownloadSet downloadSet) {
        NLogger.debug("Download.Worker", (Object)("exchangeHTTPHandshake with: " + downloadSet + " - " + this));
        SWDownloadCandidate downloadCandidate = downloadSet.getDownloadCandidate();
        SWDownloadFile downloadFile = downloadSet.getDownloadFile();
        try {
            downloadCandidate.setStatus((short)19);
            SWDownloadSegment downloadSegment = downloadSet.allocateDownloadSegment(this);
            if (downloadSegment == null) {
                NLogger.debug("Download.Worker", (Object)"No segment to allocate found");
                downloadCandidate.addToCandidateLog("No segment to allocate found.");
                downloadCandidate.setStatus((short)12);
                this.downloadEngine = null;
                return;
            }
            if (this.downloadEngine == null) {
                downloadCandidate.addToCandidateLog("Connection interrupted.");
                downloadCandidate.setStatus((short)12);
                return;
            }
            this.downloadEngine.exchangeHTTPHandshake(downloadSegment);
        }
        catch (ReconnectException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug("Download.Worker", (Object)(downloadCandidate + " " + exp.getMessage()));
            this.stopDownloadInternal();
            downloadCandidate.setStatus((short)12);
        }
        catch (RemotelyQueuedException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug("Download.Worker", (Object)("Releasing DownloadSegment (Queued): " + downloadSet.toString() + " - " + this));
            downloadSet.releaseDownloadSegment();
            downloadCandidate.updateXQueueParameters(exp.getXQueueParameters());
            downloadCandidate.setStatus((short)18);
        }
        catch (RangeUnavailableException exp) {
            boolean isScopeListAvailable;
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug("Download.Worker", (Object)(exp.toString() + " :: " + downloadCandidate));
            boolean bl = isScopeListAvailable = downloadCandidate.getAvailableScopeList() != null && downloadCandidate.getAvailableScopeList().size() > 0;
            if (isScopeListAvailable && downloadFile.isScopeAllocateable(downloadCandidate.getAvailableScopeList())) {
                NLogger.debug("Download.Worker", (Object)("Releasing DownloadSegment (Range): " + downloadSet.toString() + " - " + this));
                downloadSet.releaseDownloadSegment();
                downloadCandidate.setStatus((short)15);
            } else {
                this.stopDownloadInternal();
                int waitTime = exp.getWaitTimeInSeconds() > 0 ? exp.getWaitTimeInSeconds() : -1;
                downloadCandidate.setStatus((short)15, waitTime);
            }
        }
        catch (HostBusyException exp) {
            NLogger.debug("Download.Worker", (Object)(downloadCandidate + " " + exp.getMessage()));
            this.stopDownloadInternal();
            downloadCandidate.setStatus((short)14, exp.getWaitTimeInSeconds());
            return;
        }
        catch (UnusableHostException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            this.stopDownloadInternal();
            NLogger.debug("Download.Worker", (Object)exp, (Throwable)exp);
            NLogger.debug("Download.Worker", (Object)("Removing download candidate: " + downloadCandidate));
            if (exp instanceof FileNotAvailableException) {
                downloadFile.markCandidateIgnored(downloadCandidate, "CandidateStatusReason_FileNotFound");
            } else {
                downloadFile.markCandidateIgnored(downloadCandidate, "CandidateStatusReason_Unusable");
            }
            downloadFile.addBadAltLoc(downloadCandidate);
            return;
        }
        catch (HTTPMessageException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            this.stopDownloadInternal();
            NLogger.warn("Download.Worker", (Object)exp, (Throwable)exp);
            downloadFile.markCandidateIgnored(downloadCandidate, "CandidateStatusReason_HTTPError");
            downloadFile.addBadAltLoc(downloadCandidate);
            return;
        }
        catch (SocketTimeoutException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug("Download.Worker", (Object)exp, (Throwable)exp);
            downloadCandidate.setStatus((short)13);
            this.stopDownloadInternal();
            return;
        }
        catch (SocketException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug("Download.Worker", (Object)exp, (Throwable)exp);
            downloadCandidate.setStatus((short)13);
            this.stopDownloadInternal();
            return;
        }
        catch (IOException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            downloadCandidate.setStatus((short)13);
            NLogger.warn("Download.Worker", (Object)("Error at Host: " + downloadCandidate.getHostAddress() + " Vendor: " + downloadCandidate.getVendor()), (Throwable)exp);
            this.stopDownloadInternal();
            return;
        }
    }

    private void startDownload(SWDownloadSet downloadSet) throws IOException {
        NLogger.debug("Download.Worker", (Object)("startDownload with: " + downloadSet + " - " + this));
        SWDownloadFile downloadFile = downloadSet.getDownloadFile();
        SWDownloadCandidate downloadCandidate = downloadSet.getDownloadCandidate();
        downloadCandidate.addToCandidateLog("Start download.");
        downloadFile.addGoodAltLoc(downloadCandidate);
        downloadFile.markCandidateGood(downloadCandidate);
        while (true) {
            this.exchangeHTTPHandshake(downloadSet);
            if (this.downloadEngine == null) {
                return;
            }
            if (downloadCandidate.isRemotlyQueued()) {
                boolean succ = downloadFile.addAndValidateQueuedCandidate(downloadCandidate);
                if (!succ) {
                    this.stopDownloadInternal();
                    return;
                }
                try {
                    Thread.sleep(downloadCandidate.getXQueueParameters().getRequestSleepTime());
                    if (this.downloadEngine == null) {
                        NLogger.debug("Download.Worker", (Object)"Download stopped while waiting for queue.");
                        return;
                    }
                }
                catch (InterruptedException exp) {
                    NLogger.debug("Download.Worker", (Object)"Interrupted Worker sleeping for queue.");
                    downloadCandidate.setStatus((short)13);
                    this.stopDownloadInternal();
                    return;
                }
            }
            if (downloadCandidate.isRemotlyQueued() || downloadCandidate.isRangeUnavailable()) continue;
            downloadFile.removeQueuedCandidate(downloadCandidate);
            downloadFile.setStatus((short)2);
            downloadSet.getDownloadCandidate().setStatus((short)20);
            SWDownloadSegment downloadSegment = downloadSet.getDownloadSegment();
            this.downloadEngine.startDownload();
            downloadCandidate.addToCandidateLog("Completed a segment which started at " + downloadSegment.getStart() + " and was downloaded at a rate of " + downloadSegment.getLongTermTransferRate());
            NLogger.debug("Download.Worker", (Object)("Completed a segment which started at " + downloadSegment.getStart() + " and was downloaded at a rate of " + downloadSegment.getLongTermTransferRate()));
            NLogger.debug("Download.Worker", (Object)("Releasing DownloadSegment (completed): " + downloadSet.toString() + " - " + this));
            downloadSet.releaseDownloadSegment();
            if (!this.isRunning || this.downloadEngine == null || !this.downloadEngine.isAcceptingNextSegment() || !downloadFile.isScopeAllocateable(downloadCandidate.getAvailableScopeList()) || this.isDownloadStopped) break;
        }
        downloadCandidate.setStatus((short)12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveDownloadFilesToDestination(List list) {
        this.insideCriticalSection = true;
        try {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                SWDownloadFile downloadFile = (SWDownloadFile)iter.next();
                if (!downloadFile.isFileCompleted()) continue;
                if (downloadFile.isDownloadFinished()) {
                    downloadFile.moveToDestinationFile();
                    continue;
                }
                downloadFile.stopDownload();
            }
        }
        finally {
            this.insideCriticalSection = false;
        }
    }

    public String toString() {
        return "[SWDownloadWorker@" + Integer.toHexString(this.hashCode()) + ":running:" + this.isRunning + ",tempWorker:" + this.isTemporaryWorker + ",engine:" + this.downloadEngine + "]";
    }
}

