/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.AbstractManager;
import phex.common.Environment;
import phex.common.IPCounter;
import phex.common.ServiceManager;
import phex.common.ThreadTracking;
import phex.common.URN;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.log.LogBuffer;
import phex.download.MagnetData;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSet;
import phex.download.swarming.SWDownloadWorker;
import phex.event.AsynchronousDispatcher;
import phex.event.DownloadFilesChangeListener;
import phex.share.SharedFilesService;
import phex.utils.FileUtils;
import phex.utils.MagmaParser;
import phex.utils.NLogger;
import phex.utils.StringUtils;
import phex.utils.SubscriptionDownloader;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBDownloadScope;
import phex.xml.XJBPhex;
import phex.xml.XJBSWDownloadFile;
import phex.xml.XJBSWDownloadList;
import phex.xml.XJBSWDownloadSegment;
import phex.xml.XMLBuilder;

public class SwarmingManager
extends AbstractManager {
    public static final short PRIORITY_MOVE_TO_TOP = 0;
    public static final short PRIORITY_MOVE_UP = 1;
    public static final short PRIORITY_MOVE_DOWN = 2;
    public static final short PRIORITY_MOVE_TO_BOTTOM = 3;
    private boolean isManagerShutingDown = false;
    private ArrayList workerList;
    private ArrayList downloadList;
    private HashMap urnToDownloadMap;
    private IPCounter ipDownloadCounter;
    private SWDownloadWorker temporaryWorker;
    private DownloadWorkerLauncher workerLauncher;
    private static Object saveDownloadListLock;
    private SaveDownloadListJob saveDownloadListJob;
    private boolean downloadListChangedSinceSave = false;
    private LogBuffer downloadCandidateLogBuffer;
    private SharedFilesService sharedFilesService;
    private ArrayList listenerList = new ArrayList(2);
    static final /* synthetic */ boolean $assertionsDisabled;

    private SwarmingManager() {
    }

    public static SwarmingManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        this.workerList = new ArrayList(5);
        this.downloadList = new ArrayList(5);
        this.urnToDownloadMap = new HashMap();
        this.ipDownloadCounter = new IPCounter(ServiceManager.sCfg.maxDownloadsPerIP);
        if (ServiceManager.sCfg.downloadCandidateLogBufferSize > 0L) {
            this.downloadCandidateLogBuffer = new LogBuffer(ServiceManager.sCfg.downloadCandidateLogBufferSize);
        }
        return true;
    }

    public boolean onPostInitialization() {
        LoadDownloadListJob job = new LoadDownloadListJob();
        job.start();
        return true;
    }

    public void startupCompletedNotify() {
        this.workerLauncher = new DownloadWorkerLauncher();
        this.workerLauncher.setDaemon(true);
        this.workerLauncher.start();
        Environment.getInstance().scheduleTimerTask(new SaveDownloadListTimer(), 20000L, 20000L);
        new SubscriptionDownloader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        SWDownloadWorker worker;
        int i;
        SwarmingManager swarmingManager = this;
        synchronized (swarmingManager) {
            this.isManagerShutingDown = true;
        }
        if (this.workerLauncher != null) {
            this.workerLauncher.triggerCycle();
        }
        SWDownloadWorker[] workers = new SWDownloadWorker[this.workerList.size()];
        this.workerList.toArray(workers);
        for (i = 0; i < workers.length; ++i) {
            worker = workers[i];
            worker.stopWorker();
        }
        for (i = 0; i < workers.length; ++i) {
            worker = workers[i];
            if (!worker.isInsideCriticalSection()) continue;
            worker.waitTillFinished();
        }
        this.shutdownForceSaveDownloadList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadFile addFileToDownload(RemoteFile remoteFile, String filename, String searchTerm) {
        int pos;
        SWDownloadFile downloadFile = new SWDownloadFile(filename, searchTerm, remoteFile.getFileSize(), remoteFile.getURN());
        downloadFile.addDownloadCandidate(remoteFile);
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            pos = this.downloadList.size();
            this.downloadList.add(downloadFile);
            URN urn = downloadFile.getFileURN();
            if (urn != null) {
                this.urnToDownloadMap.put(urn, downloadFile);
            }
        }
        this.fireDownloadFileAdded(pos);
        downloadFile.setStatus((short)1);
        this.workerLauncher.triggerCycle();
        this.triggerSaveDownloadList(true);
        return downloadFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadFile addFileToDownload(URI uri) throws URIException {
        int pos;
        if (NLogger.isDebugEnabled("Download.Manager")) {
            NLogger.debug("Download.Manager", (Object)("Adding new download by URI: " + uri.toString()));
        }
        SWDownloadFile downloadFile = new SWDownloadFile(uri);
        URN urn = downloadFile.getFileURN();
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            pos = this.downloadList.size();
            this.downloadList.add(downloadFile);
            if (urn != null) {
                if (!$assertionsDisabled && this.isURNDownloaded(urn)) {
                    throw new AssertionError();
                }
                this.urnToDownloadMap.put(urn, downloadFile);
            }
        }
        this.fireDownloadFileAdded(pos);
        downloadFile.setStatus((short)1);
        this.workerLauncher.triggerCycle();
        this.triggerSaveDownloadList(true);
        return downloadFile;
    }

    public synchronized void addMagmaToDownload(File magmaFile) throws URIException, IOException {
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(magmaFile));
        MagmaParser parser = new MagmaParser(inStream);
        parser.start();
        List magnetList = parser.getMagnets();
        Iterator iter = magnetList.iterator();
        while (iter.hasNext()) {
            String magnet = (String)iter.next();
            URI uri = new URI(magnet, true);
            MagnetData magnetData = MagnetData.parseFromURI(uri);
            URN urn = MagnetData.lookupSHA1URN(magnetData);
            if (this.isURNDownloaded(urn)) continue;
            SwarmingManager.getInstance().addFileToDownload(uri);
        }
    }

    public void removeDownloadFile(SWDownloadFile file) {
        this.removeDownloadFileInternal(file);
        this.triggerSaveDownloadList(true);
    }

    public void removeDownloadFiles(SWDownloadFile[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.removeDownloadFileInternal(files[i]);
        }
        this.triggerSaveDownloadList(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDownloadFileInternal(SWDownloadFile file) {
        if (!file.isFileCompletedOrMoved() && !file.isDownloadStopped()) {
            file.stopDownload();
        }
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            URN urn;
            int pos = this.downloadList.indexOf(file);
            if (pos >= 0) {
                this.downloadList.remove(pos);
                this.fireDownloadFileRemoved(pos);
            }
            if ((urn = file.getFileURN()) != null) {
                this.urnToDownloadMap.remove(urn);
            }
        }
        file.removeIncompleteDownloadFile();
    }

    public Integer getDownloadPriority(SWDownloadFile file) {
        int pos = this.downloadList.indexOf(file);
        if (pos >= 0) {
            return new Integer(pos);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDownloadFilePriorities(SWDownloadFile[] files) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            for (int i = 0; i < files.length; ++i) {
                int pos = this.downloadList.indexOf(files[i]);
                if (pos < 0) continue;
                int newPos = i;
                if (newPos < 0 || newPos >= this.downloadList.size()) {
                    newPos = pos;
                }
                this.downloadList.remove(pos);
                this.downloadList.add(newPos, files[i]);
                this.fireDownloadFileRemoved(pos);
                this.fireDownloadFileAdded(newPos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveDownloadFilePriority(SWDownloadFile file, short moveDirection) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            int pos = this.downloadList.indexOf(file);
            if (pos >= 0) {
                int newPos = pos;
                switch (moveDirection) {
                    case 1: {
                        --newPos;
                        break;
                    }
                    case 2: {
                        ++newPos;
                        break;
                    }
                    case 0: {
                        newPos = 0;
                        break;
                    }
                    case 3: {
                        newPos = this.downloadList.size() - 1;
                    }
                }
                if (newPos < 0 || newPos >= this.downloadList.size()) {
                    return pos;
                }
                this.downloadList.remove(pos);
                this.downloadList.add(newPos, file);
                this.fireDownloadFileRemoved(pos);
                this.fireDownloadFileAdded(newPos);
                return newPos;
            }
            return pos;
        }
    }

    public int getDownloadFileCount() {
        return this.downloadList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownloadFileCount(int status) {
        int count = 0;
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            Iterator iterator = this.downloadList.iterator();
            while (iterator.hasNext()) {
                SWDownloadFile file = (SWDownloadFile)iterator.next();
                if (file.getStatus() != status) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getActiveDownloadFileCount() {
        int count = 0;
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            Iterator iterator = this.downloadList.iterator();
            block6: while (iterator.hasNext()) {
                SWDownloadFile file = (SWDownloadFile)iterator.next();
                switch (file.getStatus()) {
                    case 4: 
                    case 6: {
                        continue block6;
                    }
                }
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile getDownloadFile(int index) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            if (index < 0 || index >= this.downloadList.size()) {
                return null;
            }
            return (SWDownloadFile)this.downloadList.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile[] getDownloadFilesAt(int[] indices) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            int length = indices.length;
            SWDownloadFile[] files = new SWDownloadFile[length];
            for (int i = 0; i < length; ++i) {
                files[i] = indices[i] < 0 || indices[i] >= this.downloadList.size() ? null : (SWDownloadFile)this.downloadList.get(indices[i]);
            }
            return files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile getDownloadFile(long fileSize, URN matchURN) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            SWDownloadFile file = this.getDownloadFileByURN(matchURN);
            if (file != null && file.getTotalDataSize() == fileSize) {
                return file;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile getDownloadFileByURN(URN matchURN) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            SWDownloadFile file = (SWDownloadFile)this.urnToDownloadMap.get(matchURN);
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isURNDownloaded(URN matchURN) {
        if (matchURN == null) {
            return false;
        }
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            return this.urnToDownloadMap.containsKey(matchURN);
        }
    }

    public void releaseCandidateIP(SWDownloadCandidate candidate) {
        this.ipDownloadCounter.relaseIP(candidate.getHostAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List getCompletedDownloadFiles() {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            SWDownloadFile downloadFile = null;
            Iterator iterator = this.downloadList.iterator();
            ArrayList<SWDownloadFile> list = new ArrayList<SWDownloadFile>(2);
            while (iterator.hasNext()) {
                downloadFile = (SWDownloadFile)iterator.next();
                if (!downloadFile.isFileCompleted()) continue;
                list.add(downloadFile);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadSet allocateDownloadSet(SWDownloadWorker worker) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            SWDownloadFile downloadFile = null;
            SWDownloadCandidate downloadCandidate = null;
            Iterator iterator = this.downloadList.iterator();
            while (iterator.hasNext()) {
                boolean segmentAvailable;
                downloadFile = (SWDownloadFile)iterator.next();
                if (!downloadFile.isAbleToBeAllocated() || !(segmentAvailable = downloadFile.isScopeAllocateable(null)) || (downloadCandidate = downloadFile.allocateDownloadCandidate(worker)) == null) continue;
                this.ipDownloadCounter.setMaxCount(ServiceManager.sCfg.maxDownloadsPerIP);
                boolean succ = this.ipDownloadCounter.validateAndCountIP(downloadCandidate.getHostAddress());
                if (!succ) {
                    downloadFile.releaseDownloadCandidate(downloadCandidate);
                    continue;
                }
                boolean segmentAllocateable = downloadFile.isScopeAllocateable(downloadCandidate.getAvailableScopeList());
                if (!segmentAllocateable) {
                    downloadFile.releaseDownloadCandidate(downloadCandidate);
                    continue;
                }
                downloadFile.incrementWorkerCount();
                SWDownloadSet set = new SWDownloadSet(downloadFile, downloadCandidate);
                if (worker == this.temporaryWorker) {
                    this.unsetTemporaryWorker();
                }
                return set;
            }
        }
        return null;
    }

    public boolean isNewLocalFilenameUsed(SWDownloadFile downloadFile, File newLocalFile) {
        int size = this.downloadList.size();
        for (int i = 0; i < size; ++i) {
            SWDownloadFile existingFile = (SWDownloadFile)this.downloadList.get(i);
            if (downloadFile != null && existingFile == downloadFile || existingFile.getDestinationFile().compareTo(newLocalFile) != 0) continue;
            return true;
        }
        return false;
    }

    public LogBuffer getCandidateLogBuffer() {
        return this.downloadCandidateLogBuffer;
    }

    public void notifyDownloadListChange() {
        this.downloadListChangedSinceSave = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerSaveDownloadList(boolean force) {
        if (!force && !this.downloadListChangedSinceSave) {
            return;
        }
        NLogger.debug("Download.Manager", (Object)"Trigger save download list...");
        Object object = saveDownloadListLock;
        synchronized (object) {
            if (this.saveDownloadListJob != null) {
                this.saveDownloadListJob.triggerFollowUpSave();
            } else {
                this.saveDownloadListJob = new SaveDownloadListJob();
                this.saveDownloadListJob.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownForceSaveDownloadList() {
        NLogger.debug("Download.Manager", (Object)"Force save download list...");
        Object object = saveDownloadListLock;
        synchronized (object) {
            if (this.saveDownloadListJob == null) {
                this.saveDownloadListJob = new SaveDownloadListJob();
                this.saveDownloadListJob.start();
            } else {
                this.saveDownloadListJob.triggerFollowUpSave();
            }
        }
        try {
            if (this.saveDownloadListJob != null) {
                try {
                    this.saveDownloadListJob.setPriority(10);
                    this.saveDownloadListJob.join();
                }
                catch (NullPointerException exp) {}
            }
        }
        catch (InterruptedException exp) {
            NLogger.error("Download.Manager", (Object)exp, (Throwable)exp);
        }
    }

    private synchronized void unsetTemporaryWorker() {
        this.temporaryWorker.setTemporaryWorker(false);
        this.temporaryWorker = null;
        this.workerLauncher.triggerCycle();
    }

    public synchronized void notifyWaitingWorkers() {
        this.notifyAll();
    }

    public synchronized void waitForNotify() throws InterruptedException {
        this.wait(2000L);
    }

    private int getRequiredDownloadWorkerCount() {
        return Math.min(this.getActiveDownloadFileCount() * ServiceManager.sCfg.maxWorkerPerDownload, ServiceManager.sCfg.maxTotalDownloadWorker);
    }

    public synchronized boolean checkToStopWorker(SWDownloadWorker worker) {
        int requiredCount = this.getRequiredDownloadWorkerCount();
        if (this.isManagerShutingDown || this.workerList.size() > requiredCount) {
            if (worker.isRunning()) {
                worker.stopWorker();
                this.workerList.remove(worker);
                if (worker.isTemporaryWorker()) {
                    this.temporaryWorker = null;
                }
            }
            return true;
        }
        return Thread.interrupted();
    }

    public void notifyWorkerShoutdown(SWDownloadWorker worker, boolean isExpected) {
        NLogger.debug("Download.Manager", (Object)("Worker shutdown: " + worker + ", expected: " + isExpected));
        worker.stopWorker();
        this.workerList.remove(worker);
        if (worker.isTemporaryWorker()) {
            this.temporaryWorker = null;
        }
        this.workerLauncher.triggerCycle();
    }

    public void addDownloadFilesChangeListener(DownloadFilesChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removeDownloadFilesChangeListener(DownloadFilesChangeListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireDownloadFileChanged(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = SwarmingManager.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    DownloadFilesChangeListener listener = (DownloadFilesChangeListener)listeners[i];
                    listener.downloadFileChanged(position);
                }
            }
        });
    }

    private void fireDownloadFileAdded(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = SwarmingManager.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    DownloadFilesChangeListener listener = (DownloadFilesChangeListener)listeners[i];
                    listener.downloadFileAdded(position);
                }
            }
        });
    }

    private void fireDownloadFileRemoved(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = SwarmingManager.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    DownloadFilesChangeListener listener = (DownloadFilesChangeListener)listeners[i];
                    listener.downloadFileRemoved(position);
                }
            }
        });
    }

    public void fireDownloadFileChanged(SWDownloadFile file) {
        int position = this.downloadList.indexOf(file);
        if (position >= 0) {
            this.fireDownloadFileChanged(position);
        }
    }

    static {
        $assertionsDisabled = !SwarmingManager.class.desiredAssertionStatus();
        saveDownloadListLock = new Object();
    }

    private static class SWDownloadSegmentComparatorByStartPosition
    implements Comparator {
        private SWDownloadSegmentComparatorByStartPosition() {
        }

        public int compare(Object obj1, Object obj2) {
            XJBSWDownloadSegment segment1 = (XJBSWDownloadSegment)obj1;
            XJBSWDownloadSegment segment2 = (XJBSWDownloadSegment)obj2;
            long diff = segment1.getStartPosition() - segment2.getStartPosition();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }

    private class SaveDownloadListJob
    extends Thread {
        private boolean isFollowUpSaveTriggered;

        public SaveDownloadListJob() {
            super(ThreadTracking.rootThreadGroup, "SaveDownloadListJob");
            this.setPriority(1);
        }

        public void triggerFollowUpSave() {
            this.isFollowUpSaveTriggered = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            do {
                NLogger.debug("Download.Manager", (Object)"Start saving download list...");
                SwarmingManager.this.downloadListChangedSinceSave = false;
                this.isFollowUpSaveTriggered = false;
                try {
                    ObjectFactory objFactory = new ObjectFactory();
                    PhexElement phex = objFactory.createPhexElement();
                    XJBSWDownloadList list = this.createXJBSWDownloadList();
                    phex.setSWDownloadList(list);
                    phex.setPhexVersion(VersionUtils.getFullProgramVersion());
                    File downloadFile = Environment.getInstance().getPhexConfigFile("phexdownload.xml");
                    File downloadFileBak = new File(downloadFile.getAbsolutePath() + ".bak");
                    ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile(downloadFileBak);
                    XMLBuilder.saveToFile(managedFile, phex);
                    FileUtils.copyFile(downloadFileBak, downloadFile);
                }
                catch (JAXBException exp) {
                    NLogger.error("Download.Manager", (Object)exp, (Throwable)exp);
                    Environment.getInstance().fireDisplayUserMessage("DownloadSettingsSaveFailed", new String[]{exp.toString()});
                }
                catch (ManagedFileException exp) {
                    NLogger.error("Download.Manager", (Object)exp, (Throwable)exp);
                    Environment.getInstance().fireDisplayUserMessage("DownloadSettingsSaveFailed", new String[]{exp.toString()});
                }
                catch (IOException exp) {
                    NLogger.error("Download.Manager", (Object)exp, (Throwable)exp);
                    Environment.getInstance().fireDisplayUserMessage("DownloadSettingsSaveFailed", new String[]{exp.toString()});
                }
            } while (this.isFollowUpSaveTriggered);
            NLogger.debug("Download.Manager", (Object)"Finished saving download list...");
            Object object = saveDownloadListLock;
            synchronized (object) {
                SwarmingManager.this.saveDownloadListJob = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private XJBSWDownloadList createXJBSWDownloadList() throws JAXBException {
            ObjectFactory objFactory = new ObjectFactory();
            XJBSWDownloadList swDownloadList = objFactory.createXJBSWDownloadList();
            ArrayList arrayList = SwarmingManager.this.downloadList;
            synchronized (arrayList) {
                Iterator iterator = SwarmingManager.this.downloadList.iterator();
                List list = swDownloadList.getSWDownloadFileList();
                while (iterator.hasNext()) {
                    SWDownloadFile file = (SWDownloadFile)iterator.next();
                    list.add(file.createXJBSWDownloadFile());
                }
            }
            return swDownloadList;
        }
    }

    private class SaveDownloadListTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 20000L;

        private SaveDownloadListTimer() {
        }

        public void run() {
            try {
                SwarmingManager.this.triggerSaveDownloadList(false);
            }
            catch (Throwable th) {
                NLogger.error("Download.Manager", (Object)th, th);
            }
        }
    }

    private class LoadDownloadListJob
    extends Thread {
        public LoadDownloadListJob() {
            super(ThreadTracking.rootThreadGroup, "LoadDownloadListJob");
        }

        public void run() {
            try {
                this.loadDownloadList();
            }
            catch (Throwable th) {
                NLogger.error("Download.Manager", (Object)th, th);
            }
        }

        private void loadDownloadList() {
            NLogger.debug("Download.Manager", (Object)"Loading download list...");
            File downloadFile = Environment.getInstance().getPhexConfigFile("phexdownload.xml");
            File downloadFileBak = new File(downloadFile.getAbsolutePath() + ".bak");
            if (!downloadFile.exists() && !downloadFileBak.exists()) {
                NLogger.debug("Download.Manager", (Object)"No download list file found.");
                return;
            }
            try {
                NLogger.debug("Download.Manager", (Object)"Try to load from default download list.");
                FileManager fileMgr = FileManager.getInstance();
                ManagedFile managedFile = fileMgr.getReadWriteManagedFile(downloadFile);
                XJBPhex phex = XMLBuilder.loadXJBPhexFromFile(managedFile);
                if (phex == null) {
                    NLogger.debug("Download.Manager", (Object)"Try to load from backup download list.");
                    ManagedFile managedFileBak = fileMgr.getReadWriteManagedFile(downloadFileBak);
                    phex = XMLBuilder.loadXJBPhexFromFile(managedFileBak);
                }
                if (phex == null) {
                    NLogger.debug("Download.Manager", (Object)"No download settings file found.");
                    return;
                }
                XJBSWDownloadList list = phex.getSWDownloadList();
                if (list != null) {
                    String phexVersion = phex.getPhexVersion();
                    if (VersionUtils.compare("2.6.4.89", phexVersion) >= 0) {
                        this.load2_6_4_89SWDownloadList(list);
                    } else {
                        this.loadXJBSWDownloadList(list);
                    }
                } else {
                    NLogger.debug("Download.Manager", (Object)"No SWDownloadList found.");
                }
                SwarmingManager.this.notifyWaitingWorkers();
            }
            catch (JAXBException exp) {
                Throwable linkedException = exp.getLinkedException();
                if (linkedException != null) {
                    NLogger.error("Download.Manager", (Object)linkedException, linkedException);
                }
                NLogger.error("Download.Manager", (Object)exp, (Throwable)exp);
                Environment.getInstance().fireDisplayUserMessage("DownloadSettingsLoadFailed", new String[]{exp.toString()});
                return;
            }
            catch (ManagedFileException exp) {
                NLogger.error("Download.Manager", (Object)exp, (Throwable)exp);
                Environment.getInstance().fireDisplayUserMessage("DownloadSettingsLoadFailed", new String[]{exp.toString()});
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadXJBSWDownloadList(XJBSWDownloadList list) {
            ArrayList arrayList = SwarmingManager.this.downloadList;
            synchronized (arrayList) {
                NLogger.debug("Download.Manager", (Object)"Loading SWDownload xml");
                SwarmingManager.this.downloadList.clear();
                SwarmingManager.this.urnToDownloadMap.clear();
                Iterator iterator = list.getSWDownloadFileList().iterator();
                while (iterator.hasNext()) {
                    try {
                        XJBSWDownloadFile xjbFile = (XJBSWDownloadFile)iterator.next();
                        SWDownloadFile file = new SWDownloadFile(xjbFile);
                        int pos = SwarmingManager.this.downloadList.size();
                        SwarmingManager.this.downloadList.add(file);
                        URN urn = file.getFileURN();
                        if (urn != null) {
                            SwarmingManager.this.urnToDownloadMap.put(urn, file);
                        }
                        NLogger.debug("Download.Manager", (Object)("Loaded SWDownloadFile: " + file));
                        SwarmingManager.this.fireDownloadFileAdded(pos);
                    }
                    catch (Exception exp) {
                        NLogger.error("Download.Manager", (Object)"Error loading a download file from XML.", (Throwable)exp);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load2_6_4_89SWDownloadList(XJBSWDownloadList list) {
            ArrayList arrayList = SwarmingManager.this.downloadList;
            synchronized (arrayList) {
                NLogger.debug("Download.Manager", (Object)"Loading old download xml.");
                ObjectFactory objFactory = new ObjectFactory();
                SwarmingManager.this.downloadList.clear();
                SwarmingManager.this.urnToDownloadMap.clear();
                Iterator iterator = list.getSWDownloadFileList().iterator();
                while (iterator.hasNext()) {
                    try {
                        XJBSWDownloadFile xjbFile = (XJBSWDownloadFile)iterator.next();
                        String destFileName = ServiceManager.sCfg.mDownloadDir + File.separator + xjbFile.getLocalFileName();
                        File destFile = new File(destFileName);
                        File incFile = SWDownloadFile.createIncompleteFile(destFile);
                        RandomAccessFile raFile = new RandomAccessFile(incFile, "rwd");
                        XJBSWDownloadFile xjbNewFile = objFactory.createXJBSWDownloadFile();
                        xjbNewFile.setIncompleteFileName(incFile.getAbsolutePath());
                        xjbNewFile.setCreatedTime(xjbFile.getCreatedTime());
                        xjbNewFile.setFileSize(xjbFile.getFileSize());
                        xjbNewFile.setFileURN(xjbFile.getFileURN());
                        xjbNewFile.setLocalFileName(xjbFile.getLocalFileName());
                        xjbNewFile.setModifiedTime(xjbFile.getModifiedTime());
                        xjbNewFile.setSearchTerm(xjbFile.getSearchTerm());
                        xjbNewFile.setStatus(xjbFile.getStatus());
                        xjbNewFile.getCandidateList().addAll(xjbFile.getCandidateList());
                        ArrayList tempSegmentList = new ArrayList();
                        Iterator segmentIterator = xjbFile.getSegmentList().iterator();
                        while (segmentIterator.hasNext()) {
                            tempSegmentList.add(segmentIterator.next());
                        }
                        Collections.sort(tempSegmentList, new SWDownloadSegmentComparatorByStartPosition());
                        segmentIterator = tempSegmentList.iterator();
                        while (segmentIterator.hasNext()) {
                            try {
                                int len;
                                File incompleteFile;
                                XJBSWDownloadSegment xjbSegment = (XJBSWDownloadSegment)segmentIterator.next();
                                long transferDataSize = xjbSegment.getLength();
                                long startPos = xjbSegment.getStartPosition();
                                long transferredDataSize = 0L;
                                String incompleteFileName = xjbSegment.getIncompleteFileName();
                                if (StringUtils.isEmpty(incompleteFileName) || !(incompleteFile = new File(xjbSegment.getIncompleteFileName())).exists() || (transferredDataSize = incompleteFile.length()) == 0L) continue;
                                if (transferDataSize != -1L && transferredDataSize > transferDataSize) {
                                    try {
                                        FileUtils.truncateFile(incompleteFile, transferDataSize);
                                        transferredDataSize = transferDataSize;
                                    }
                                    catch (IOException exp) {
                                        NLogger.error("Download", (Object)exp, (Throwable)exp);
                                    }
                                }
                                raFile.setLength(startPos + transferredDataSize);
                                raFile.seek(startPos);
                                FileInputStream fIn = new FileInputStream(incompleteFile);
                                byte[] buffer = new byte[16384];
                                while ((len = fIn.read(buffer, 0, buffer.length)) > 0) {
                                    raFile.write(buffer, 0, len);
                                }
                                fIn.close();
                                incompleteFile.delete();
                                XJBDownloadScope scope = objFactory.createXJBDownloadScope();
                                scope.setStart(startPos);
                                scope.setEnd(startPos + transferredDataSize - 1L);
                                xjbNewFile.getFinishedScopesList().add(scope);
                            }
                            catch (Throwable th) {
                                NLogger.error("Download.Manager", (Object)"Failed to convert segment.", th);
                            }
                        }
                        raFile.close();
                        SWDownloadFile file = new SWDownloadFile(xjbNewFile);
                        int pos = SwarmingManager.this.downloadList.size();
                        SwarmingManager.this.downloadList.add(file);
                        URN urn = file.getFileURN();
                        if (urn != null) {
                            SwarmingManager.this.urnToDownloadMap.put(urn, file);
                        }
                        NLogger.debug("Download.Manager", (Object)("Converted SWDownloadFile: " + file));
                        SwarmingManager.this.fireDownloadFileAdded(pos);
                    }
                    catch (Exception exp) {
                        NLogger.error("Download.Manager", (Object)"Failed to convert a download file from XML.", (Throwable)exp);
                    }
                }
            }
        }
    }

    private class DownloadWorkerLauncher
    extends Thread {
        public DownloadWorkerLauncher() {
            super(ThreadTracking.rootThreadGroup, "DownloadWorkerLauncher");
        }

        public void run() {
            while (!SwarmingManager.this.isManagerShutingDown) {
                try {
                    this.createRequiredWorker();
                    this.waitForNextCycle();
                }
                catch (Throwable th) {
                    NLogger.error("Download.Manager", (Object)th, th);
                }
            }
        }

        public synchronized void triggerCycle() {
            this.notify();
        }

        private synchronized void waitForNextCycle() throws InterruptedException {
            this.wait(2000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createRequiredWorker() {
            SwarmingManager swarmingManager = SwarmingManager.this;
            synchronized (swarmingManager) {
                int requiredCount = SwarmingManager.this.getRequiredDownloadWorkerCount();
                if (SwarmingManager.this.temporaryWorker == null && SwarmingManager.this.workerList.size() < requiredCount) {
                    SwarmingManager.this.temporaryWorker = new SWDownloadWorker();
                    SwarmingManager.this.temporaryWorker.setTemporaryWorker(true);
                    SwarmingManager.this.temporaryWorker.startWorker();
                    SwarmingManager.this.workerList.add(SwarmingManager.this.temporaryWorker);
                    NLogger.debug("Download.Manager", (Object)("Creating new worker: " + SwarmingManager.this.temporaryWorker + " for a total of: " + SwarmingManager.this.workerList.size()));
                }
            }
        }
    }

    private static class Holder {
        protected static final SwarmingManager manager = new SwarmingManager();

        private Holder() {
        }
    }
}

