/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JMenu;
import phex.common.ExpiryDate;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.gui.actions.FWAction;
import phex.gui.common.GUIRegistry;
import phex.gui.dialogs.SecurityRuleConfigDialog;
import phex.security.PhexSecurityManager;
import phex.utils.Localizer;
import phex.utils.NLogger;

public abstract class BanHostActionUtils
extends FWAction {
    public static BanHostActionMenu createActionMenu(BanHostActionProvider addressProvider) {
        FWAction[] actions = new FWAction[4];
        JMenu mainMenu = new JMenu(Localizer.getString("BanHostAction_BanHost"));
        mainMenu.setIcon(GUIRegistry.getInstance().getIconFactory().getIcon("Ban"));
        BanHostAction action = new BanHostAction(Localizer.getString("BanHostAction_1Day"), addressProvider, ExpiryDate.getExpiryDate(System.currentTimeMillis() + 86400000L));
        actions[0] = action;
        mainMenu.add(action);
        action = new BanHostAction(Localizer.getString("BanHostAction_7Days"), addressProvider, ExpiryDate.getExpiryDate(System.currentTimeMillis() + 604800000L));
        actions[1] = action;
        mainMenu.add(action);
        action = new BanHostAction(Localizer.getString("BanHostAction_Unlimited"), addressProvider, ExpiryDate.getExpiryDate(Long.MAX_VALUE));
        actions[2] = action;
        mainMenu.add(action);
        action = new BanHostAction(Localizer.getString("BanHostAction_Custom"), addressProvider, null);
        actions[3] = action;
        mainMenu.add(action);
        BanHostActionMenu actionMenu = new BanHostActionMenu();
        actionMenu.menu = mainMenu;
        actionMenu.actions = actions;
        return actionMenu;
    }

    public static FWAction createToolBarAction(BanHostActionProvider addressProvider) {
        BanHostAction action = new BanHostAction(Localizer.getString("BanHostAction_BanHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Ban"), Localizer.getString("BanHostAction_TTTBanHost7Days"), addressProvider, ExpiryDate.getExpiryDate(System.currentTimeMillis() + 604800000L));
        return action;
    }

    private static void banHosts(DestAddress[] addresses, ExpiryDate expiryDate) {
        PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
        for (int i = 0; i < addresses.length; ++i) {
            IpAddress ip = addresses[i].getIpAddress();
            if (ip == null) continue;
            securityMgr.createIPAccessRule(Localizer.getString("UserBanned"), true, (byte)1, ip.getHostIP(), null, false, expiryDate, true);
        }
    }

    private static class BanHostAction
    extends FWAction {
        private BanHostActionProvider addressProvider;
        private ExpiryDate expiryDate;

        private BanHostAction(String name, BanHostActionProvider addressProvider, ExpiryDate expiryDate) {
            this(name, null, null, addressProvider, expiryDate);
        }

        private BanHostAction(String name, Icon icon, String tooltiptext, BanHostActionProvider addressProvider, ExpiryDate expiryDate) {
            super(name, icon, tooltiptext);
            this.addressProvider = addressProvider;
            this.expiryDate = expiryDate;
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.expiryDate == null) {
                    DestAddress[] addresses = this.addressProvider.getBanHostAddresses();
                    IpAddress ip = addresses[0].getIpAddress();
                    if (ip == null) {
                        return;
                    }
                    SecurityRuleConfigDialog dialog = new SecurityRuleConfigDialog();
                    dialog.customPrefillBanSingleIp(Localizer.getString("UserBanned"), ip.getHostIP());
                    dialog.show();
                } else {
                    final DestAddress[] addresses = this.addressProvider.getBanHostAddresses();
                    Runnable runner = new Runnable(){

                        public void run() {
                            try {
                                BanHostActionUtils.banHosts(addresses, BanHostAction.this.expiryDate);
                            }
                            catch (Throwable th) {
                                NLogger.error("USER_INTERFACE", (Object)th, th);
                            }
                        }
                    };
                    ThreadPool.getInstance().addJob(runner, "BanHostsAction");
                }
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }

        public void refreshActionState() {
            this.setEnabled(this.addressProvider.isBanHostActionEnabled(this.expiryDate != null));
        }
    }

    public static interface BanHostActionProvider {
        public DestAddress[] getBanHostAddresses();

        public boolean isBanHostActionEnabled(boolean var1);
    }

    public static class BanHostActionMenu {
        public FWAction[] actions;
        public JMenu menu;
    }
}

