/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import phex.common.ManagerController;
import phex.common.ServiceManager;
import phex.gui.actions.FWAction;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MainFrame;
import phex.gui.dialogs.CloseOptionsDialog;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class ExitPhexAction
extends FWAction {
    public ExitPhexAction() {
        super(Localizer.getString("Exit"), GUIRegistry.getInstance().getIconFactory().getIcon("Close"), Localizer.getString("TTTExitPhex"), new Integer(Localizer.getChar("ExitMnemonic")), KeyStroke.getKeyStroke(Localizer.getString("ExitAccelerator")));
    }

    public void actionPerformed(ActionEvent e) {
        try {
            ExitPhexAction.performCloseGUIAction();
        }
        catch (Throwable th) {
            NLogger.error("USER_INTERFACE", (Object)th, th);
        }
    }

    public static void performCloseGUIAction() {
        if (ServiceManager.sCfg.showCloseOptionsDialog) {
            CloseOptionsDialog dialog = new CloseOptionsDialog();
            dialog.show();
            if (!dialog.isOkActivated()) {
                return;
            }
        }
        if (ServiceManager.sCfg.minimizeToBackground) {
            ExitPhexAction.minimizeToBackground();
        } else {
            ExitPhexAction.shutdown();
        }
    }

    private static void minimizeToBackground() {
        GUIRegistry registry = GUIRegistry.getInstance();
        DesktopIndicator indicator = registry.getDesktopIndicator();
        MainFrame frame = registry.getMainFrame();
        if (frame.getState() != 1) {
            frame.setState(1);
        }
        if (indicator != null) {
            indicator.showIndicator();
            frame.hide();
        }
    }

    public static void shutdown() {
        try {
            ManagerController.shutdownManagers();
            ServiceManager.sCfg.save();
        }
        catch (Exception exp) {
            NLogger.error("USER_INTERFACE", (Object)exp, (Throwable)exp);
        }
        GUIRegistry registry = GUIRegistry.getInstance();
        try {
            DesktopIndicator indicator = registry.getDesktopIndicator();
            if (indicator != null) {
                indicator.hideIndicator();
                indicator.removeIndicator();
            }
        }
        catch (Exception exp) {
            NLogger.error("USER_INTERFACE", (Object)exp, (Throwable)exp);
        }
        try {
            registry.saveGUISettings();
        }
        catch (Exception exp) {
            NLogger.error("USER_INTERFACE", (Object)exp, (Throwable)exp);
        }
        registry.getMainFrame().dispose();
        try {
            ManagerController.shutdownManagers();
        }
        catch (Exception exp) {
            NLogger.error("USER_INTERFACE", (Object)exp, (Throwable)exp);
        }
        System.exit(0);
    }

    public void refreshActionState() {
    }
}

