/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.chat;

import java.util.HashMap;
import phex.chat.ChatEngine;
import phex.chat.ChatManager;
import phex.event.ChatListener;
import phex.gui.chat.ChatFrame;
import phex.utils.Localizer;

public class ChatFrameManager
implements ChatListener {
    private static final int MAX_CHAT_WINDOWS = 30;
    private HashMap openChatsMap = new HashMap(4);

    public ChatFrameManager() {
        ChatManager.getInstance().addChatListener(this);
    }

    public void chatConnectionOpened(ChatEngine chatEngine) {
        if (this.openChatsMap.size() > 30) {
            chatEngine.stopChat();
            return;
        }
        ChatFrame frame = new ChatFrame(chatEngine);
        frame.setVisible(true);
        this.openChatsMap.put(chatEngine, frame);
    }

    public void chatMessageReceived(ChatEngine chatEngine, String chatMessage) {
        ChatFrame frame = (ChatFrame)this.openChatsMap.get(chatEngine);
        frame.addChatMessage(chatMessage);
    }

    public void chatConnectionFailed(ChatEngine chatEngine) {
        ChatFrame frame = (ChatFrame)this.openChatsMap.remove(chatEngine);
        if (frame != null) {
            Object[] args = new Object[]{chatEngine.getHostAddress().getHostName()};
            frame.addInfoMessage(Localizer.getFormatedString("ChatConnectionClosed", args));
        }
    }
}

