/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Hashtable;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import phex.utils.Logger;
import phex.utils.NLogger;

public class IconFactory {
    private static final ImageIcon MISSING_IMAGE = new ImageIcon(IconFactory.class.getResource("/phex/gui/resources/image-failed.gif"));
    public static final ImageIcon EMPTY_IMAGE_16;
    private Hashtable table = new Hashtable();
    private ResourceBundle resource;

    public IconFactory(String resourceFileName) {
        this.resource = PropertyResourceBundle.getBundle(resourceFileName);
    }

    public Icon getIcon(String key) {
        TKIcon icon = (TKIcon)this.table.get(key);
        if (icon == null) {
            icon = new TKIcon(key);
            this.table.put(key, icon);
        }
        return icon;
    }

    static {
        BufferedImage bufImg = new BufferedImage(16, 16, 2);
        EMPTY_IMAGE_16 = new ImageIcon(bufImg);
    }

    class TKIcon
    extends ImageIcon {
        private String key;
        private boolean loaded;

        TKIcon(String aKey) {
            this.key = aKey;
            this.loaded = false;
        }

        public Image getImage() {
            this.loadIcon();
            return super.getImage();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.loadIcon();
            super.paintIcon(c, g, x, y);
        }

        public int getIconWidth() {
            this.loadIcon();
            return super.getIconWidth();
        }

        public int getIconHeight() {
            this.loadIcon();
            return super.getIconHeight();
        }

        private void loadIcon() {
            if (this.loaded) {
                return;
            }
            try {
                if (this.key != null) {
                    String imgURLStr = this.key.startsWith("Flag_") ? "/phex/gui/resources/flags/" + this.key.substring(5).toLowerCase() + ".png" : IconFactory.this.resource.getString(this.key);
                    URL imgURL = null;
                    if (imgURLStr != null) {
                        imgURL = (class$phex$gui$common$IconFactory == null ? (class$phex$gui$common$IconFactory = IconFactory.class$("phex.gui.common.IconFactory")) : class$phex$gui$common$IconFactory).getResource(imgURLStr);
                    }
                    Image image = null;
                    if (imgURL != null) {
                        image = Toolkit.getDefaultToolkit().createImage(imgURL);
                    }
                    if (image == null) {
                        Logger.logMessage(Logger.WARNING, (short)32, "Can't find image for key: " + this.key + " URL: " + imgURLStr);
                        image = MISSING_IMAGE.getImage();
                    }
                    super.setImage(image);
                    this.loaded = true;
                }
            }
            catch (Exception exp) {
                NLogger.error("USER_INTERFACE", (Object)exp, (Throwable)exp);
            }
        }
    }
}

