/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.lang.SystemUtils;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.LookAndFeelFailedException;
import phex.utils.ClassUtils;
import phex.utils.NLogger;

public class LookAndFeelUtils {
    private static ThemeInfo[] plasticThemes;

    public static UIManager.LookAndFeelInfo[] getAvailableLAFs() {
        Class<?> gtkLAFClass;
        ArrayList<UIManager.LookAndFeelInfo> list = new ArrayList<UIManager.LookAndFeelInfo>();
        if (SystemUtils.IS_OS_MAC_OSX) {
            list.add(new UIManager.LookAndFeelInfo("Macintosh", UIManager.getSystemLookAndFeelClassName()));
        }
        list.add(new UIManager.LookAndFeelInfo("PlasticXP (default)", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel"));
        list.add(new UIManager.LookAndFeelInfo("Metal", "javax.swing.plaf.metal.MetalLookAndFeel"));
        if (SystemUtils.IS_OS_WINDOWS) {
            list.add(new UIManager.LookAndFeelInfo("Windows", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel"));
        }
        try {
            gtkLAFClass = Class.forName("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        }
        catch (ClassNotFoundException e) {
            gtkLAFClass = null;
        }
        if (gtkLAFClass != null) {
            list.add(new UIManager.LookAndFeelInfo("GTK", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel"));
        }
        UIManager.LookAndFeelInfo[] lafs = new UIManager.LookAndFeelInfo[list.size()];
        list.toArray(lafs);
        return lafs;
    }

    public static ThemeInfo[] getAvailableThemes(String lafClassName) {
        if (lafClassName.equals("com.jgoodies.looks.plastic.PlasticXPLookAndFeel")) {
            LookAndFeelUtils.initPlasticThemes();
            return plasticThemes;
        }
        return new ThemeInfo[0];
    }

    public static ThemeInfo getCurrentTheme(String lafClassName) {
        if ("com.jgoodies.looks.plastic.PlasticXPLookAndFeel".equals(lafClassName)) {
            PlasticTheme myCurrentTheme = PlasticLookAndFeel.getMyCurrentTheme();
            if (myCurrentTheme == null) {
                return null;
            }
            Class<?> clazz = myCurrentTheme.getClass();
            String name = clazz.getName();
            return new ThemeInfo(name, name);
        }
        return null;
    }

    public static void setCurrentTheme(String lafClassName, Object theme) {
        if (lafClassName.equals("com.jgoodies.looks.plastic.PlasticXPLookAndFeel")) {
            PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)theme);
            try {
                UIManager.setLookAndFeel(UIManager.getLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException exp) {
                NLogger.error("USER_INTERFACE", (Object)exp, (Throwable)exp);
            }
        }
        GUIUtils.updateComponentsUI();
    }

    public static LookAndFeel determineLAF(String defaultClass) {
        String lafClass = defaultClass;
        LookAndFeel laf = (LookAndFeel)ClassUtils.newInstanceQuitly(ClassUtils.classForNameQuitly(lafClass));
        if (laf != null && laf.isSupportedLookAndFeel()) {
            return laf;
        }
        lafClass = LookAndFeelUtils.getDefaultLAFClassName();
        laf = (LookAndFeel)ClassUtils.newInstanceQuitly(ClassUtils.classForNameQuitly(lafClass));
        if (laf != null && laf.isSupportedLookAndFeel()) {
            return laf;
        }
        lafClass = UIManager.getCrossPlatformLookAndFeelClassName();
        laf = (LookAndFeel)ClassUtils.newInstanceQuitly(ClassUtils.classForNameQuitly(lafClass));
        return laf;
    }

    private static String getDefaultLAFClassName() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        return "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
    }

    public static void setLookAndFeel(String className) throws LookAndFeelFailedException {
        try {
            Class<?> lnfClass = Class.forName(className);
            LookAndFeelUtils.setLookAndFeel((LookAndFeel)lnfClass.newInstance());
        }
        catch (ClassNotFoundException exp) {
            NLogger.error("USER_INTERFACE", (Object)("Class not found: " + className), (Throwable)exp);
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + exp, "Error", 0);
            throw new LookAndFeelFailedException("Class not found: " + className);
        }
        catch (IllegalAccessException exp) {
            NLogger.error("USER_INTERFACE", (Object)("Illegal access: " + className), (Throwable)exp);
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + exp, "Error", 0);
            throw new LookAndFeelFailedException("Illegal access: " + className);
        }
        catch (InstantiationException exp) {
            NLogger.error("USER_INTERFACE", (Object)("Instantiation failed: " + className), (Throwable)exp);
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + exp, "Error", 0);
            throw new LookAndFeelFailedException("Instantiation faield: " + className);
        }
        catch (Throwable th) {
            NLogger.error("USER_INTERFACE", (Object)("Error loading LAF: " + className), th);
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + th, "Error", 0);
        }
    }

    public static void setLookAndFeel(LookAndFeel laf) throws LookAndFeelFailedException {
        try {
            if (laf.getID().equals(UIManager.getLookAndFeel().getID())) {
                return;
            }
            UIManager.setLookAndFeel(laf);
            GUIUtils.updateComponentsUI();
        }
        catch (UnsupportedLookAndFeelException exp) {
            NLogger.error("USER_INTERFACE", (Object)("Instantiation faield: " + laf.getName()), (Throwable)exp);
            throw new LookAndFeelFailedException("Instantiation faield: " + laf.getName());
        }
    }

    private static void initPlasticThemes() {
        if (plasticThemes == null) {
            String classPrefix = "com.jgoodies.looks.plastic.theme.";
            plasticThemes = new ThemeInfo[18];
            LookAndFeelUtils.plasticThemes[0] = new ThemeInfo("BrownSugar", classPrefix + "BrownSugar");
            LookAndFeelUtils.plasticThemes[1] = new ThemeInfo("DarkStar", classPrefix + "DarkStar");
            LookAndFeelUtils.plasticThemes[2] = new ThemeInfo("DesertBlue", classPrefix + "DesertBlue");
            LookAndFeelUtils.plasticThemes[3] = !LookUtils.IS_LAF_WINDOWS_XP_ENABLED && LookUtils.IS_OS_WINDOWS_MODERN ? new ThemeInfo("DesertBluer (default)", classPrefix + "DesertBluer") : new ThemeInfo("DesertBluer", classPrefix + "DesertBluer");
            LookAndFeelUtils.plasticThemes[4] = new ThemeInfo("DesertGreen", classPrefix + "DesertGreen");
            LookAndFeelUtils.plasticThemes[5] = new ThemeInfo("DesertRed", classPrefix + "DesertRed");
            LookAndFeelUtils.plasticThemes[6] = new ThemeInfo("DesertYellow", classPrefix + "DesertYellow");
            LookAndFeelUtils.plasticThemes[7] = LookUtils.IS_LAF_WINDOWS_XP_ENABLED ? new ThemeInfo("ExperienceBlue (default)", classPrefix + "ExperienceBlue") : new ThemeInfo("ExperienceBlue", classPrefix + "ExperienceBlue");
            LookAndFeelUtils.plasticThemes[8] = new ThemeInfo("ExperienceGreen", classPrefix + "ExperienceGreen");
            LookAndFeelUtils.plasticThemes[9] = new ThemeInfo("Silver", classPrefix + "Silver");
            LookAndFeelUtils.plasticThemes[10] = !LookUtils.IS_OS_WINDOWS_XP && !LookUtils.IS_OS_WINDOWS_MODERN ? new ThemeInfo("SkyBlue (default)", classPrefix + "SkyBlue") : new ThemeInfo("SkyBlue", classPrefix + "SkyBlue");
            LookAndFeelUtils.plasticThemes[11] = new ThemeInfo("SkyBluer", classPrefix + "SkyBluer");
            LookAndFeelUtils.plasticThemes[13] = new ThemeInfo("SkyGreen", classPrefix + "SkyGreen");
            LookAndFeelUtils.plasticThemes[14] = new ThemeInfo("SkyKrupp", classPrefix + "SkyKrupp");
            LookAndFeelUtils.plasticThemes[15] = new ThemeInfo("SkyPink", classPrefix + "SkyPink");
            LookAndFeelUtils.plasticThemes[16] = new ThemeInfo("SkyRed", classPrefix + "SkyRed");
            LookAndFeelUtils.plasticThemes[17] = new ThemeInfo("SkyYellow", classPrefix + "SkyYellow");
        }
    }

    public static class ThemeInfo {
        private String name;
        private String className;

        public ThemeInfo(String name, String className) {
            this.name = name;
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ThemeInfo)) {
                return false;
            }
            return this.className.equals(((ThemeInfo)o).className);
        }
    }
}

