/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.UIManager;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.gui.common.PhexColors;

public class MultiScopeProgressBar
extends JPanel {
    private long fileSize;
    public DownloadScopeList primaryScopeList;
    public DownloadScopeList secondaryScopeList;
    private static Rectangle viewRect = new Rectangle();
    private boolean isPreferredSizeSet = false;
    private boolean isMaximumSizeSet = false;
    private boolean isMinimumSizeSet = false;

    public MultiScopeProgressBar() {
        this.setBackground(PhexColors.getScopeProgressBarBackground());
        this.setForeground(PhexColors.getScopeProgressBarForeground());
        this.setBorder(UIManager.getBorder("ProgressBar.border"));
    }

    public void setDownloadFile(SWDownloadFile file) {
        if (file == null) {
            this.fileSize = 0L;
            this.primaryScopeList = null;
            this.secondaryScopeList = null;
        } else {
            this.fileSize = file.getTotalDataSize();
            this.primaryScopeList = file.getFinishedScopeList();
            this.secondaryScopeList = file.getBlockedScopeList();
        }
        this.repaint();
    }

    public void setCandidate(SWDownloadCandidate candidate) {
        this.fileSize = candidate.getDownloadFile().getTotalDataSize();
        this.primaryScopeList = candidate.getAvailableScopeList();
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Insets i = this.getInsets();
        MultiScopeProgressBar.viewRect.x = i.left;
        MultiScopeProgressBar.viewRect.y = i.top;
        MultiScopeProgressBar.viewRect.width = this.getWidth() - (i.right + MultiScopeProgressBar.viewRect.x);
        MultiScopeProgressBar.viewRect.height = this.getHeight() - (i.bottom + MultiScopeProgressBar.viewRect.y);
        Graphics2D g2 = (Graphics2D)g;
        if (this.primaryScopeList != null) {
            this.paintScopeList(this.primaryScopeList, this.getForeground(), g2);
        }
        if (this.secondaryScopeList != null) {
            this.paintScopeList(this.secondaryScopeList, PhexColors.getScopeProgressBarSecondaryForeground(), g2);
        }
    }

    private void paintScopeList(DownloadScopeList scopeList, Color baseColor, Graphics2D g2) {
        float valPerPixel = (this.fileSize - 1L) / (long)MultiScopeProgressBar.viewRect.width;
        Iterator iterator = scopeList.getScopeIterator();
        while (iterator.hasNext()) {
            DownloadScope scope = (DownloadScope)iterator.next();
            float startPx = (float)scope.getStart() / valPerPixel;
            float endPx = (float)scope.getEnd() / valPerPixel;
            float width = endPx - startPx;
            int alpha = (int)Math.min(245.0f * width, 245.0f) + 10;
            Color useColor = alpha < 255 ? new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha) : baseColor;
            g2.setColor(useColor);
            int rectWidth = (int)Math.max(width, 1.0f);
            g2.fillRect(MultiScopeProgressBar.viewRect.x + (int)startPx, MultiScopeProgressBar.viewRect.y, rectWidth, MultiScopeProgressBar.viewRect.height);
        }
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return this.computePreferredSize();
    }

    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        return this.computeMaximumSize();
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return this.computeMinimumSize();
    }

    public boolean isPreferredSizeSet() {
        return this.isPreferredSizeSet;
    }

    public void setPreferredSize(Dimension sz) {
        this.isPreferredSizeSet = sz != null;
        super.setPreferredSize(sz);
    }

    public boolean isMaximumSizeSet() {
        return this.isMaximumSizeSet;
    }

    public void setMaximumSize(Dimension sz) {
        this.isMaximumSizeSet = sz != null;
        super.setMaximumSize(sz);
    }

    public boolean isMinimumSizeSet() {
        return this.isMinimumSizeSet;
    }

    public void setMinimumSize(Dimension sz) {
        this.isMinimumSizeSet = sz != null;
        super.setMinimumSize(sz);
    }

    protected Dimension computePreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height = 25;
        return dim;
    }

    protected Dimension computeMaximumSize() {
        return this.computePreferredSize();
    }

    protected Dimension computeMinimumSize() {
        return this.computePreferredSize();
    }
}

