/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Color;
import javax.swing.UIManager;
import org.apache.commons.lang.SystemUtils;
import phex.gui.common.GUIUtils;

public class PhexColors {
    private static Color boxPanelBorderColor;
    private static Color boxPanelBackground;
    private static Color boxHeaderBackground;
    private static Color boxHeaderGradientFrom;
    private static Color boxHeaderGradientTo;
    private static Color linkLabelRolloverForeground;
    private static Color scopeProgressBarBackground;
    private static Color scopeProgressBarForeground;
    private static Color scopeProgressBarSecondaryForeground;

    public static Color getBoxPanelBorderColor() {
        return boxPanelBorderColor;
    }

    public static Color getBoxPanelBackground() {
        return boxPanelBackground;
    }

    public static Color getBoxHeaderBackground() {
        return boxHeaderBackground;
    }

    public static Color getBoxHeaderGradientFrom() {
        return boxHeaderGradientFrom;
    }

    public static Color getBoxHeaderGradientTo() {
        return boxHeaderGradientTo;
    }

    public static Color getElegantHeaderGradientFrom() {
        return boxHeaderGradientFrom;
    }

    public static Color getElegantHeaderGradientTo() {
        return boxHeaderGradientTo;
    }

    public static Color getLinkLabelRolloverForeground() {
        return linkLabelRolloverForeground;
    }

    public static Color getScopeProgressBarBackground() {
        return scopeProgressBarBackground;
    }

    public static Color getScopeProgressBarForeground() {
        return scopeProgressBarForeground;
    }

    public static Color getScopeProgressBarSecondaryForeground() {
        return scopeProgressBarSecondaryForeground;
    }

    public static void updateColors() {
        Color activeCaptionBorderColor = UIManager.getColor("activeCaptionBorder");
        Color infoColor = UIManager.getColor("info");
        if ((SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_WINDOWS) && UIManager.getLookAndFeel().isNativeLookAndFeel()) {
            PhexColors.activatePhexColors();
        } else if (infoColor == null || activeCaptionBorderColor == null) {
            PhexColors.activatePhexColors();
        } else {
            boxPanelBorderColor = GUIUtils.darkerColor(activeCaptionBorderColor, 0.8);
            boxPanelBackground = new Color(infoColor.getRGB());
            boxHeaderBackground = GUIUtils.darkerColor(activeCaptionBorderColor, 0.9);
            boxHeaderGradientFrom = new Color(activeCaptionBorderColor.getRGB());
            boxHeaderGradientTo = GUIUtils.brighterColor(infoColor, 0.8);
            linkLabelRolloverForeground = GUIUtils.darkerColor(activeCaptionBorderColor, 0.8);
            scopeProgressBarBackground = UIManager.getColor("window");
            scopeProgressBarForeground = UIManager.getColor("ProgressBar.foreground");
            scopeProgressBarSecondaryForeground = boxHeaderGradientTo;
        }
    }

    private static void activatePhexColors() {
        boxPanelBorderColor = new Color(14510336);
        boxPanelBackground = new Color(16764827);
        boxHeaderBackground = new Color(16745472);
        boxHeaderGradientFrom = new Color(16756034);
        boxHeaderGradientTo = new Color(16767401);
        linkLabelRolloverForeground = new Color(15492096);
        scopeProgressBarBackground = Color.WHITE;
        scopeProgressBarForeground = new Color(16754245);
        scopeProgressBarSecondaryForeground = new Color(16732229);
    }
}

