/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import phex.gui.common.table.FWTable;
import phex.gui.models.ISortableModel;

public class SortedTableHeaderRenderer
extends DefaultTableCellRenderer {
    private FWTable table;

    public SortedTableHeaderRenderer(FWTable table) {
        this.setHorizontalAlignment(0);
        this.table = table;
        this.setHorizontalTextPosition(10);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
            ISortableModel model = (ISortableModel)((Object)table.getModel());
            int sortedColumn = table.convertColumnIndexToView(model.getSortByColumn());
            if (sortedColumn == column) {
                if (model.isSortedAscending()) {
                    this.setIcon(new DirectionIcon(false, this.getFont().getSize(), 0));
                } else {
                    this.setIcon(new DirectionIcon(true, this.getFont().getSize(), 0));
                }
            } else {
                this.setIcon(null);
            }
        }
        this.setText(value == null ? "" : value.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }

    private class DirectionIcon
    implements Icon {
        private boolean descending;
        private int size;
        private int priority;

        public DirectionIcon(boolean descending, int size, int priority) {
            this.descending = descending;
            this.size = size;
            this.priority = priority;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color color = c == null ? Color.gray : c.getBackground();
            int dx = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int dy = this.descending ? dx : -dx;
            y = y + 5 * this.size / 7 + (this.descending ? -dy : 0);
            int shift = this.descending ? 1 : -1;
            g.translate(x, y);
            g.setColor(color.darker());
            g.drawLine(dx / 2, dy, 0, 0);
            g.drawLine(dx / 2, dy + shift, 0, shift);
            g.setColor(color.brighter());
            g.drawLine(dx / 2, dy, dx, 0);
            g.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.descending) {
                g.setColor(color.darker().darker());
            } else {
                g.setColor(color.brighter().brighter());
            }
            g.drawLine(dx, 0, 0, 0);
            g.setColor(color);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }
}

