/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.treetable;

import java.util.Comparator;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import phex.gui.common.treetable.TreeTableModel;

public abstract class AbstractTreeTableModel
implements TreeTableModel {
    public static final Class hierarchicalColumnClass;
    protected String[] tableColumns;
    protected Class[] tableClasses;
    protected Object root;
    protected EventListenerList listenerList = new EventListenerList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractTreeTableModel(Object root, String[] theTableColumns, Class[] theTableClasses) {
        this.tableColumns = theTableColumns;
        this.tableClasses = theTableClasses;
        if (!$assertionsDisabled && this.tableClasses[0] != hierarchicalColumnClass) {
            throw new AssertionError();
        }
        this.root = root;
    }

    public String getColumnName(int column) {
        return this.tableColumns[column];
    }

    public int getColumnCount() {
        return this.tableColumns.length;
    }

    public Class getColumnClass(int column) {
        Class clazz = this.tableClasses[column];
        if (clazz == null) {
            clazz = String.class;
        }
        return clazz;
    }

    public Comparator getColumnComparator(int column) {
        return null;
    }

    public Object getComparableValueAt(Object node, int column) {
        return this.getValueAt(node, column);
    }

    public int mapColumnIDToModelIndex(int columnId) {
        throw new UnsupportedOperationException("Needs to be overloaded by the model.");
    }

    public boolean isColumnHideable(int columnId) {
        return true;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            return i;
        }
        return -1;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractTreeTableModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    public void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractTreeTableModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    public void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractTreeTableModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    public void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractTreeTableModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }

    static {
        $assertionsDisabled = !AbstractTreeTableModel.class.desiredAssertionStatus();
        hierarchicalColumnClass = TreeTableModel.class;
    }
}

