/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.treetable;

import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import phex.gui.common.table.FWTableModel;
import phex.gui.common.treetable.JTreeTable;
import phex.gui.common.treetable.TreeTableModel;
import phex.gui.models.ISortableModel;

public class TreeTableModelAdapter
extends FWTableModel
implements ISortableModel {
    private TreeTableModel model;
    private final JTree tree;
    private JTreeTable treeTable = null;
    private TreeModelListener treeModelListener;
    static final /* synthetic */ boolean $assertionsDisabled;

    TreeTableModelAdapter(TreeTableModel model, JTree tree) {
        if (!$assertionsDisabled && model == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && tree == null) {
            throw new AssertionError();
        }
        this.tree = tree;
        this.setTreeTableModel(model);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    public void setTreeTableModel(TreeTableModel model) {
        TreeTableModel old = this.getTreeTableModel();
        if (old != null) {
            old.removeTreeModelListener(this.getTreeModelListener());
        }
        this.model = model;
        model.addTreeModelListener(this.getTreeModelListener());
        this.fireTableStructureChanged();
    }

    private TreeModelListener getTreeModelListener() {
        if (this.treeModelListener == null) {
            this.treeModelListener = new TreeModelListener(){

                public void treeNodesChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged(e, 0);
                }

                public void treeNodesInserted(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged(e, 1);
                }

                public void treeNodesRemoved(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged(e, 2);
                }

                public void treeStructureChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }
            };
        }
        return this.treeModelListener;
    }

    public TreeTableModel getTreeTableModel() {
        return this.model;
    }

    protected JTreeTable getTreeTable() {
        return this.treeTable;
    }

    protected final void bind(JTreeTable treeTable) {
        if (treeTable == null) {
            throw new IllegalArgumentException("null treeTable");
        }
        if (this.treeTable != null) {
            throw new IllegalArgumentException("adapter already bound");
        }
        this.treeTable = treeTable;
    }

    public Class getColumnClass(int column) {
        return this.model.getColumnClass(column);
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.model.getColumnName(column);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public Object getValueAt(int row, int column) {
        return this.model.getValueAt(this.nodeForRow(row), column);
    }

    public boolean isCellEditable(int row, int column) {
        return this.model.isCellEditable(this.nodeForRow(row), column);
    }

    public void setValueAt(Object value, int row, int column) {
        this.model.setValueAt(value, this.nodeForRow(row), column);
    }

    protected Object nodeForRow(int row) {
        return this.tree.getPathForRow(row).getLastPathComponent();
    }

    private void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    private void delayedFireTableDataChanged(final TreeModelEvent tme, final int typeChange) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int[] indices = tme.getChildIndices();
                TreePath path = tme.getTreePath();
                if (indices != null) {
                    if (TreeTableModelAdapter.this.tree.isExpanded(path)) {
                        int startingRow = TreeTableModelAdapter.this.tree.getRowForPath(path) + 1;
                        int min = Integer.MAX_VALUE;
                        int max = Integer.MIN_VALUE;
                        for (int i = 0; i < indices.length; ++i) {
                            if (indices[i] < min) {
                                min = indices[i];
                            }
                            if (indices[i] <= max) continue;
                            max = indices[i];
                        }
                        switch (typeChange) {
                            case 0: {
                                TreeTableModelAdapter.this.fireTableRowsUpdated(startingRow + min, startingRow + max);
                                break;
                            }
                            case 1: {
                                TreeTableModelAdapter.this.fireTableRowsInserted(startingRow + min, startingRow + max);
                                break;
                            }
                            case 2: {
                                TreeTableModelAdapter.this.fireTableRowsDeleted(startingRow + min, startingRow + max);
                            }
                        }
                    } else {
                        int row = TreeTableModelAdapter.this.tree.getRowForPath(path);
                        if (row >= 0) {
                            TreeTableModelAdapter.this.fireTableRowsUpdated(row, row);
                        }
                    }
                } else {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            }
        });
    }

    public Comparator getColumnComparator(int column) {
        return this.model.getColumnComparator(column);
    }

    public Object getComparableValueAt(int row, int column) {
        return this.model.getComparableValueAt(this.nodeForRow(row), column);
    }

    public int mapColumnIDToModelIndex(int columnId) {
        return this.model.mapColumnIDToModelIndex(columnId);
    }

    public boolean isColumnHideable(int columnId) {
        return this.model.isColumnHideable(columnId);
    }

    public void fireTableDataChanged() {
        super.fireTableDataChanged();
    }

    public int getSortByColumn() {
        if (this.model instanceof ISortableModel) {
            return ((ISortableModel)((Object)this.model)).getSortByColumn();
        }
        throw new UnsupportedOperationException("TreeTableModel not an ISortableModel.");
    }

    public boolean isSortedAscending() {
        if (this.model instanceof ISortableModel) {
            return ((ISortableModel)((Object)this.model)).isSortedAscending();
        }
        throw new UnsupportedOperationException("TreeTableModel not an ISortableModel.");
    }

    public void sortByColumn(int column, boolean isSortedAscending) {
        if (!(this.model instanceof ISortableModel)) {
            throw new UnsupportedOperationException("TreeTableModel not an ISortableModel.");
        }
        ((ISortableModel)((Object)this.model)).sortByColumn(column, isSortedAscending);
    }

    static {
        $assertionsDisabled = !TreeTableModelAdapter.class.desiredAssertionStatus();
    }
}

