/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import phex.common.Cfg;
import phex.common.FileHandlingException;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.MainFrame;
import phex.utils.FileUtils;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.StringUtils;

public class DownloadConfigDialog
extends JDialog {
    private JTextField filenameTF;
    private JCheckBox renameOldFileCBx;
    private JTextField researchTermTF;
    private JCheckBox switchToDownldCBx;
    private boolean isDialogCanceled = false;
    private RemoteFile remoteFile;
    private SWDownloadFile downloadFile;

    private DownloadConfigDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("DownloadConfiguration"), true);
    }

    public DownloadConfigDialog(RemoteFile aRemoteFile) {
        this();
        this.remoteFile = aRemoteFile;
        this.prepareComponent();
    }

    public DownloadConfigDialog(SWDownloadFile aDownloadFile) {
        this();
        this.downloadFile = aDownloadFile;
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DownloadConfigDialog.this.closeDialog();
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(10, 10, 10, 10);
        contentPane.add((Component)pane, constraints);
        StringBuffer filenameBuffer = new StringBuffer();
        filenameBuffer.append(Localizer.getString("File"));
        filenameBuffer.append(":  ");
        if (this.remoteFile != null) {
            filenameBuffer.append(this.remoteFile.getFilename());
        } else if (this.downloadFile != null) {
            filenameBuffer.append(this.downloadFile.getDestinationFileName());
        }
        JLabel label = new JLabel(filenameBuffer.toString());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 18;
        pane.add((Component)label, constraints);
        StringBuffer filesizeBuffer = new StringBuffer();
        filesizeBuffer.append(Localizer.getString("FileSize"));
        filesizeBuffer.append(":  ");
        if (this.remoteFile != null) {
            filesizeBuffer.append(this.remoteFile.getFileSizeObject());
        } else if (this.downloadFile != null) {
            filesizeBuffer.append(this.downloadFile.getTotalDataSize());
        }
        filesizeBuffer.append(' ');
        filesizeBuffer.append(Localizer.getString("Bytes"));
        label = new JLabel(filesizeBuffer.toString());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(3, 0, 3, 0);
        constraints.anchor = 18;
        pane.add((Component)label, constraints);
        JSeparator sep = new JSeparator();
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(6, 0, 6, 0);
        constraints.anchor = 15;
        constraints.fill = 1;
        pane.add((Component)sep, constraints);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(3, 0, 3, 0);
        pane.add((Component)panel, constraints);
        label = new JLabel(Localizer.getString("LocalFileName") + ":  ");
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 18;
        panel.add((Component)label, constraints);
        String filenameStr = null;
        if (this.remoteFile != null) {
            filenameStr = this.remoteFile.getFilename();
        } else if (this.downloadFile != null) {
            filenameStr = this.downloadFile.getDestinationFileName();
        }
        this.filenameTF = new JTextField(filenameStr, 30);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 18;
        constraints.fill = 2;
        panel.add((Component)this.filenameTF, constraints);
        if (this.downloadFile != null) {
            this.renameOldFileCBx = new JCheckBox(Localizer.getString("RenameFile"));
            this.renameOldFileCBx.setSelected(true);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 2;
            constraints.anchor = 12;
            panel.add((Component)this.renameOldFileCBx, constraints);
        }
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(3, 0, 3, 0);
        pane.add((Component)panel, constraints);
        label = new JLabel(Localizer.getString("ResearchTerm") + ":  ");
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 18;
        panel.add((Component)label, constraints);
        String searchTerm = null;
        if (this.remoteFile != null) {
            searchTerm = StringUtils.createNaturalSearchTerm(this.remoteFile.getDisplayName());
        } else if (this.downloadFile != null) {
            searchTerm = this.downloadFile.getResearchSetting().getSearchTerm();
        }
        this.researchTermTF = new JTextField(searchTerm, 30);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 18;
        constraints.fill = 2;
        panel.add((Component)this.researchTermTF, constraints);
        if (this.remoteFile != null) {
            this.switchToDownldCBx = new JCheckBox(Localizer.getString("SwitchToDownloadTab"));
            this.switchToDownldCBx.setSelected(true);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 5;
            constraints.weightx = 1.0;
            constraints.anchor = 18;
            constraints.insets = new Insets(3, 0, 3, 0);
            pane.add((Component)this.switchToDownldCBx, constraints);
        }
        JPanel btnPane = new JPanel();
        btnPane.setLayout(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(2, 0, 2, 0);
        constraints.fill = 1;
        constraints.anchor = 14;
        pane.add((Component)btnPane, constraints);
        sep = new JSeparator();
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(6, 0, 6, 0);
        constraints.anchor = 15;
        constraints.fill = 2;
        btnPane.add((Component)sep, constraints);
        String buttonTxt = null;
        if (this.remoteFile != null) {
            buttonTxt = Localizer.getString("Download");
        } else if (this.downloadFile != null) {
            buttonTxt = Localizer.getString("Change");
        }
        JButton okBtn = new JButton(buttonTxt);
        okBtn.addActionListener(new OkBtnActionListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.anchor = 12;
        btnPane.add((Component)okBtn, constraints);
        okBtn.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(okBtn);
        JButton cancelBtn = new JButton(Localizer.getString("Cancel"));
        cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadConfigDialog.this.isDialogCanceled = true;
                DownloadConfigDialog.this.closeDialog();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.anchor = 12;
        btnPane.add((Component)cancelBtn, constraints);
        this.pack();
        pane.setMinimumSize(pane.getPreferredSize());
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(GUIRegistry.getInstance().getMainFrame());
    }

    private boolean isInputValidAndUpdated() {
        String localFilename = this.filenameTF.getText().trim();
        if (localFilename.length() == 0) {
            GUIUtils.showErrorMessage(this, Localizer.getString("NoFileName"));
            this.filenameTF.requestFocus();
            return false;
        }
        String researchTerm = this.researchTermTF.getText().trim();
        if (researchTerm.length() < Cfg.MIN_SEARCH_TERM_LENGTH) {
            Object[] objArr = new Object[]{new Integer(Cfg.MIN_SEARCH_TERM_LENGTH)};
            GUIUtils.showErrorMessage(this, Localizer.getFormatedString("MinSearchTerm", objArr));
            this.researchTermTF.requestFocus();
            return false;
        }
        if (this.remoteFile != null) {
            SwarmingManager.getInstance().addFileToDownload(this.remoteFile, ServiceManager.sCfg.mDownloadDir + File.separator + FileUtils.convertToLocalSystemFilename(localFilename), researchTerm);
            this.remoteFile.setInDownloadQueue(true);
        } else if (this.downloadFile != null) {
            if (!this.downloadFile.getDestinationFileName().equals(localFilename)) {
                boolean rename = this.renameOldFileCBx.isSelected();
                try {
                    File destFile = new File(ServiceManager.sCfg.mDownloadDir + File.separator + FileUtils.convertToLocalSystemFilename(localFilename));
                    this.downloadFile.setDestinationFile(destFile, rename);
                }
                catch (FileHandlingException exp) {
                    if (exp.getType() == 1) {
                        Object[] objArr = new Object[]{localFilename};
                        GUIUtils.showErrorMessage(this, Localizer.getFormatedString("FileAlreadyExists", objArr));
                    }
                    if (exp.getType() == 0) {
                        GUIUtils.showErrorMessage(this, Localizer.getString("FileRenameFailed"));
                    }
                    exp.printStackTrace();
                }
            }
            this.downloadFile.getResearchSetting().setSearchTerm(researchTerm);
        }
        return true;
    }

    private void closeDialogAfterDownload() {
        MainFrame frame = GUIRegistry.getInstance().getMainFrame();
        if (this.remoteFile != null && this.switchToDownldCBx.isSelected()) {
            frame.setSelectedTab(1003);
        }
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isDialogCanceled() {
        return this.isDialogCanceled;
    }

    private final class OkBtnActionListener
    implements ActionListener {
        private OkBtnActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Runnable runner = new Runnable(){

                public void run() {
                    try {
                        if (DownloadConfigDialog.this.isInputValidAndUpdated()) {
                            DownloadConfigDialog.this.closeDialogAfterDownload();
                        }
                    }
                    catch (Throwable th) {
                        NLogger.error("USER_INTERFACE", (Object)th, th);
                    }
                }
            };
            ThreadPool.getInstance().addJob(runner, "DownloadConfigAction");
        }
    }
}

