/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.SystemUtils;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.share.ShareManager;
import phex.utils.FileUtils;
import phex.utils.IOUtil;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class ExportDialog
extends JDialog {
    private JTextField customExportFormatTF;
    private JTextField outputFileTF;
    private JRadioButton defaultHTMLExport;
    private JRadioButton magmaYAMLHTMLExport;
    private JRadioButton rssXMLHTMLExport;
    private JRadioButton customExport;
    private JCheckBox magnetInclXs;

    public ExportDialog() throws HeadlessException {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("ExportDialog_DialogTitle"), false);
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ExportDialog.this.closeDialog();
            }
        });
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        FormLayout layout = new FormLayout("4dlu, d, 2dlu, d, 2dlu, d, 2dlu, fill:d:grow, 2dlu, d, 4dlu", "p, 10dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p,10dlu, p, 3dlu, p,10dlu, p, 3dlu, p,10dlu, p, 3dlu, p 6dlu");
        PanelBuilder builder = new PanelBuilder(layout, contentPanel);
        DialogBanner banner = new DialogBanner(Localizer.getString("ExportDialog_BannerHeader"), Localizer.getString("ExportDialog_BannerSubHeader"));
        builder.add((Component)banner, cc.xywh(1, 1, 9, 1));
        ExportTypeListener radioListener = new ExportTypeListener();
        builder.addSeparator(Localizer.getString("ExportDialog_ExportFormat"), cc.xywh(2, 3, 7, 1));
        this.defaultHTMLExport = new JRadioButton(Localizer.getString("ExportDialog_DefaultHTMLExport"));
        this.defaultHTMLExport.setSelected(true);
        this.defaultHTMLExport.addActionListener(radioListener);
        this.magmaYAMLHTMLExport = new JRadioButton(Localizer.getString("ExportDialog_MagmaYAMLExport"));
        this.magmaYAMLHTMLExport.addActionListener(radioListener);
        this.rssXMLHTMLExport = new JRadioButton(Localizer.getString("ExportDialog_RSSXMLExport"));
        this.rssXMLHTMLExport.addActionListener(radioListener);
        this.customExport = new JRadioButton(Localizer.getString("ExportDialog_CustomExportFormat"));
        ButtonGroup exportFormatGroup = new ButtonGroup();
        exportFormatGroup.add(this.defaultHTMLExport);
        exportFormatGroup.add(this.magmaYAMLHTMLExport);
        exportFormatGroup.add(this.rssXMLHTMLExport);
        exportFormatGroup.add(this.customExport);
        this.defaultHTMLExport.setSelected(true);
        builder.add((Component)this.defaultHTMLExport, cc.xywh(4, 5, 3, 1));
        builder.add((Component)this.magmaYAMLHTMLExport, cc.xywh(4, 7, 3, 1));
        builder.add((Component)this.rssXMLHTMLExport, cc.xywh(4, 9, 3, 1));
        builder.add((Component)this.customExport, cc.xy(4, 11));
        this.customExportFormatTF = new JTextField(40);
        builder.add((Component)this.customExportFormatTF, cc.xywh(6, 11, 1, 1));
        JButton browseCustomFormat = new JButton(Localizer.getString("ExportDialog_Browse"));
        browseCustomFormat.addActionListener(new BrowseCustomFileBtnListener());
        builder.add((Component)browseCustomFormat, cc.xy(8, 11));
        builder.addSeparator(Localizer.getString("ExportDialog_Output"), cc.xywh(2, 13, 7, 1));
        builder.addLabel(Localizer.getString("ExportDialog_FileName"), cc.xy(4, 15, "right, center"));
        this.outputFileTF = new JTextField(40);
        File defOutFile = new File(SystemUtils.USER_HOME, "shared_files.html");
        this.outputFileTF.setText(defOutFile.getAbsolutePath());
        builder.add((Component)this.outputFileTF, cc.xywh(6, 15, 1, 1));
        JButton browseOutFile = new JButton(Localizer.getString("ExportDialog_Browse"));
        browseOutFile.addActionListener(new BrowseOutFileBtnListener());
        builder.add((Component)browseOutFile, cc.xy(8, 15));
        builder.addSeparator(Localizer.getString("ExportDialog_Options"), cc.xywh(2, 17, 7, 1));
        this.magnetInclXs = new JCheckBox(Localizer.getString("ExportDialog_MagnetIncludeXS"));
        this.magnetInclXs.setToolTipText(Localizer.getString("ExportDialog_TTTMagnetIncludeXS"));
        builder.add((Component)this.magnetInclXs, cc.xywh(4, 19, 3, 1));
        builder.add((Component)new JSeparator(), cc.xywh(1, 21, 9, 1));
        JButton cancelBtn = new JButton(Localizer.getString("Cancel"));
        cancelBtn.addActionListener(new CancelBtnListener());
        JButton okBtn = new JButton(Localizer.getString("OK"));
        okBtn.addActionListener(new OkBtnListener());
        JPanel btnPanel = ButtonBarFactory.buildOKCancelBar(okBtn, cancelBtn);
        builder.add((Component)btnPanel, cc.xywh(2, 23, 7, 1));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startExport() {
        BufferedOutputStream outStream;
        InputStream inStream;
        block9: {
            block10: {
                String outFileName = this.outputFileTF.getText();
                File file = new File(outFileName);
                inStream = null;
                outStream = null;
                outStream = new BufferedOutputStream(new FileOutputStream(file));
                if (this.defaultHTMLExport.isSelected()) {
                    inStream = ClassLoader.getSystemResourceAsStream("phex/resources/defaultSharedFilesHTMLExport.xsl");
                    break block9;
                }
                if (this.magmaYAMLHTMLExport.isSelected()) {
                    inStream = ClassLoader.getSystemResourceAsStream("phex/resources/magmaSharedFilesYAMLExport.xsl");
                    break block9;
                }
                if (this.rssXMLHTMLExport.isSelected()) {
                    inStream = ClassLoader.getSystemResourceAsStream("phex/resources/rssSharedFilesXMLExport.xsl");
                    break block9;
                }
                if (!this.customExport.isSelected()) break block10;
                String styleFileName = this.customExportFormatTF.getText();
                File styleFile = new File(styleFileName);
                inStream = new BufferedInputStream(new FileInputStream(styleFile));
                break block9;
            }
            IOUtil.closeQuietly(inStream);
            IOUtil.closeQuietly(outStream);
            return;
        }
        try {
            HashMap<String, String> exportOptions = null;
            if (this.magnetInclXs.isSelected()) {
                exportOptions = new HashMap<String, String>();
                exportOptions.put("UseMagnetURLWithXS", "true");
            }
            ShareManager.getInstance().exportSharedFiles(inStream, outStream, exportOptions);
        }
        catch (IOException exp) {
            try {
                NLogger.error("USER_INTERFACE", (Object)exp, (Throwable)exp);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(inStream);
                IOUtil.closeQuietly(outStream);
                throw throwable;
            }
            IOUtil.closeQuietly(inStream);
            IOUtil.closeQuietly(outStream);
        }
        IOUtil.closeQuietly(inStream);
        IOUtil.closeQuietly(outStream);
    }

    private final class ExportTypeListener
    implements ActionListener {
        private ExportTypeListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String filename = ExportDialog.this.outputFileTF.getText();
                String ext = FileUtils.getFileExtension(filename);
                if (ExportDialog.this.defaultHTMLExport.isSelected()) {
                    if (!ext.equals("htm") && !ext.equals("html")) {
                        filename = FileUtils.replaceFileExtension(filename, "html");
                    }
                } else if (ExportDialog.this.magmaYAMLHTMLExport.isSelected()) {
                    if (!ext.equals("magma")) {
                        filename = FileUtils.replaceFileExtension(filename, "magma");
                    }
                } else if (ExportDialog.this.rssXMLHTMLExport.isSelected() && !ext.equals("xml")) {
                    filename = FileUtils.replaceFileExtension(filename, "xml");
                }
                ExportDialog.this.outputFileTF.setText(filename);
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }
    }

    private final class BrowseCustomFileBtnListener
    implements ActionListener {
        private BrowseCustomFileBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ExportDialog.this.customExport.setSelected(true);
                if (SystemUtils.IS_OS_MAC_OSX) {
                    FileDialog dia = new FileDialog((Frame)GUIRegistry.getInstance().getMainFrame(), Localizer.getString("ExportDialog_SelectCustomStyleFile"), 0);
                    dia.show();
                    ExportDialog.this.customExportFormatTF.setText(dia.getDirectory() + dia.getFile());
                } else {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle(Localizer.getString("ExportDialog_SelectCustomStyleFile"));
                    chooser.setFileSelectionMode(0);
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || FileUtils.getFileExtension(file).equalsIgnoreCase("XSL");
                        }

                        public String getDescription() {
                            return "XSL-Stylesheet";
                        }
                    });
                    int rc = chooser.showOpenDialog(ExportDialog.this);
                    if (rc == 0) {
                        File file = chooser.getSelectedFile();
                        ExportDialog.this.customExportFormatTF.setText(file.getAbsolutePath());
                    }
                }
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }
    }

    private final class BrowseOutFileBtnListener
    implements ActionListener {
        private BrowseOutFileBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (SystemUtils.IS_OS_MAC_OSX) {
                    FileDialog dia = new FileDialog((Frame)GUIRegistry.getInstance().getMainFrame(), Localizer.getString("ExportDialog_SelectOutputFile"), 1);
                    dia.show();
                    String filename = dia.getDirectory() + dia.getFile();
                    filename = this.adjustFileExtension(filename);
                    ExportDialog.this.outputFileTF.setText(filename);
                } else {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle(Localizer.getString("ExportDialog_SelectOutputFile"));
                    chooser.setFileSelectionMode(0);
                    chooser.setMultiSelectionEnabled(false);
                    int rc = chooser.showSaveDialog(ExportDialog.this);
                    if (rc == 0) {
                        File file = chooser.getSelectedFile();
                        String filename = this.adjustFileExtension(file.getAbsolutePath());
                        ExportDialog.this.outputFileTF.setText(filename);
                    }
                }
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }

        private String adjustFileExtension(String filename) {
            String ext = FileUtils.getFileExtension(filename);
            if (ExportDialog.this.defaultHTMLExport.isSelected()) {
                if (!ext.equals("htm") && !ext.equals("html")) {
                    filename = filename + ".html";
                }
            } else if (ExportDialog.this.magmaYAMLHTMLExport.isSelected()) {
                if (!ext.equals("magma")) {
                    filename = filename + ".magma";
                }
            } else if (ExportDialog.this.rssXMLHTMLExport.isSelected() && !ext.equals("xml")) {
                filename = filename + ".rss.xml";
            }
            return filename;
        }
    }

    private final class CancelBtnListener
    implements ActionListener {
        private CancelBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ExportDialog.this.closeDialog();
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ExportDialog.this.startExport();
                ExportDialog.this.closeDialog();
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }
    }
}

