/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import phex.common.Cfg;
import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.PlainMultiLinePanel;
import phex.utils.Localizer;

public class SelectNetworkDialog
extends JDialog {
    private JComboBox networkCbx;
    private JCheckBox autoJoinNetworkChkbx;
    private JCheckBox autoConnectChkbx;

    public SelectNetworkDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("SelectNet_SelectNetwork"), true);
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SelectNetworkDialog.this.closeDialog(false);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        FormLayout layout = new FormLayout("10dlu, right:d, 4dlu, max(200dlu;d):grow", "p, 3dlu, p:grow, 6dlu, p, 3dlu, p, 3dlu, p, 9dlu, p");
        PanelBuilder builder = new PanelBuilder(layout, contentPanel);
        CellConstraints cc = new CellConstraints();
        builder.setDefaultDialogBorder();
        builder.addSeparator(Localizer.getString("SelectNet_SelectNetworkToJoin"), cc.xywh(1, 1, 4, 1));
        PlainMultiLinePanel multiLineText = new PlainMultiLinePanel(Localizer.getString("SelectNet_NetworkSelectionText"));
        builder.add((Component)multiLineText, cc.xywh(2, 3, 3, 1));
        this.networkCbx = new JComboBox();
        this.networkCbx.setEditable(true);
        this.networkCbx.addItem(Cfg.DEFAULT_NETWORK_TO_USE);
        if (Cfg.DEFAULT_NETWORK_TO_USE != "<General Gnutella Network>") {
            this.networkCbx.addItem("<General Gnutella Network>");
        }
        for (int i = 0; i < ServiceManager.sCfg.mNetNetworkHistory.size(); ++i) {
            this.networkCbx.addItem(ServiceManager.sCfg.mNetNetworkHistory.get(i));
        }
        NetworkManager networkMgr = NetworkManager.getInstance();
        this.networkCbx.setSelectedItem(networkMgr.getGnutellaNetwork().getName());
        builder.addLabel(Localizer.getString("SelectNet_NetworkName"), cc.xy(2, 5));
        builder.add((Component)this.networkCbx, cc.xy(4, 5));
        this.autoJoinNetworkChkbx = new JCheckBox(Localizer.getString("SelectNet_AutoJoinNetwork"), ServiceManager.sCfg.mAutoJoin);
        builder.add((Component)this.autoJoinNetworkChkbx, cc.xywh(2, 7, 3, 1));
        this.autoConnectChkbx = new JCheckBox(Localizer.getString("SelectNet_AutoConnectNetwork"), ServiceManager.sCfg.mAutoConnect);
        builder.add((Component)this.autoConnectChkbx, cc.xywh(2, 9, 3, 1));
        ButtonActionHandler actionHandler = new ButtonActionHandler();
        JButton okButton = new JButton(Localizer.getString("OK"));
        okButton.setDefaultCapable(true);
        okButton.addActionListener(actionHandler);
        okButton.setActionCommand("OK");
        JButton cancelButton = new JButton(Localizer.getString("Cancel"));
        cancelButton.addActionListener(actionHandler);
        cancelButton.setActionCommand("CANCEL");
        JPanel buttonPanel = ButtonBarFactory.buildOKCancelBar(okButton, cancelButton);
        builder.add((Component)buttonPanel, cc.xywh(1, 11, 4, 1));
        contentPane.validate();
        contentPanel.doLayout();
        contentPanel.revalidate();
        this.doLayout();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog(boolean triggerSave) {
        if (triggerSave) {
            ServiceManager.sCfg.save();
            NetworkManager.getInstance().leaveNetwork();
            NetworkManager.getInstance().joinNetwork();
        }
        this.setVisible(false);
        this.dispose();
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean triggerSave = false;
            if (e.getActionCommand().equals("OK")) {
                boolean autoConnect;
                boolean autoJoin;
                String networkName = (String)SelectNetworkDialog.this.networkCbx.getEditor().getItem();
                if ((networkName = networkName.trim()).length() == 0) {
                    networkName = Cfg.DEFAULT_NETWORK_TO_USE;
                }
                if (!ServiceManager.sCfg.mCurrentNetwork.equals(networkName)) {
                    ServiceManager.sCfg.mCurrentNetwork = networkName;
                    triggerSave = true;
                }
                if (ServiceManager.sCfg.mAutoJoin != (autoJoin = SelectNetworkDialog.this.autoJoinNetworkChkbx.isSelected())) {
                    ServiceManager.sCfg.mAutoJoin = autoJoin;
                    triggerSave = true;
                }
                if (ServiceManager.sCfg.mAutoConnect != (autoConnect = SelectNetworkDialog.this.autoConnectChkbx.isSelected())) {
                    ServiceManager.sCfg.mAutoConnect = autoConnect;
                    triggerSave = true;
                }
                if (!networkName.equals("<General Gnutella Network>")) {
                    ServiceManager.sCfg.mNetNetworkHistory.remove(networkName);
                    ServiceManager.sCfg.mNetNetworkHistory.add(0, networkName);
                    if (ServiceManager.sCfg.mNetNetworkHistory.size() > 20) {
                        ServiceManager.sCfg.mNetNetworkHistory.remove(20);
                    }
                    triggerSave = true;
                }
            }
            SelectNetworkDialog.this.closeDialog(triggerSave);
        }
    }
}

