/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.editors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import phex.gui.dialogs.filter.RuleDescriptionPanel;
import phex.rules.condition.FilenameCondition;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.StringUtils;

public class FileNameCondEditor
extends JDialog {
    private RuleDescriptionPanel ruleDescPanel;
    private FilenameCondition orgCondition;
    private FilenameCondition condition;
    private JTextField termTF;
    private JList termsList;
    private TermsModel termsModel;

    public FileNameCondEditor(FilenameCondition cond, RuleDescriptionPanel descPanel, JDialog parentDialog) {
        super(parentDialog, Localizer.getString("FileNameCondEditor_DialogTitle"), true);
        this.ruleDescPanel = descPanel;
        this.orgCondition = cond;
        this.condition = new FilenameCondition(cond);
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("4dlu, d, 2dlu, d, d:grow, 4dlu, d, 4dlu", "4dlu, p, 2dlu, p, 10dlu, p, 2dlu, p, fill:p:grow, 4dlu, p, 2dlu, p 4dlu");
        PanelBuilder contentPB = new PanelBuilder(layout, contentPanel);
        int columnCount = layout.getColumnCount();
        int rowCount = layout.getRowCount();
        JLabel label = new JLabel(Localizer.getString("FileNameCondEditor_ConditionToAdd"));
        contentPB.add((Component)label, cc.xywh(2, 2, 5, 1));
        label = new JLabel(Localizer.getString("FileNameCondEditor_Term"));
        label.setToolTipText(Localizer.getString("FileNameCondEditor_TTTTerm"));
        contentPB.add((Component)label, cc.xywh(2, 4, 1, 1));
        this.termTF = new JTextField(25);
        this.termTF.setToolTipText(Localizer.getString("FileNameCondEditor_TTTTerm"));
        contentPB.add((Component)this.termTF, cc.xywh(4, 4, 1, 1));
        JButton addBtn = new JButton(Localizer.getString("FileNameCondEditor_Add"));
        addBtn.addActionListener(new AddActionListener());
        addBtn.setToolTipText(Localizer.getString("FileNameCondEditor_TTTAdd"));
        contentPB.add((Component)addBtn, cc.xywh(7, 4, 1, 1));
        label = new JLabel(Localizer.getString("FileNameCondEditor_FileNameConditions"));
        contentPB.add((Component)label, cc.xywh(2, 6, 5, 1));
        this.termsModel = new TermsModel();
        this.termsList = new JList(this.termsModel);
        this.termsList.setCellRenderer(new TermsRenderer());
        contentPB.add((Component)new JScrollPane(this.termsList), cc.xywh(2, 8, 4, 2));
        JButton removeBtn = new JButton(Localizer.getString("FileNameCondEditor_Remove"));
        removeBtn.addActionListener(new RemoveActionListener());
        removeBtn.setToolTipText(Localizer.getString("FileNameCondEditor_TTTRemove"));
        contentPB.add((Component)removeBtn, cc.xywh(7, 8, 1, 1));
        contentPB.add((Component)new JSeparator(), cc.xywh(1, rowCount - 3, columnCount, 1));
        JButton okBtn = new JButton(Localizer.getString("OK"));
        okBtn.addActionListener(new OkBtnListener());
        okBtn.setDefaultCapable(true);
        okBtn.setRequestFocusEnabled(true);
        JButton cancelBtn = new JButton(Localizer.getString("Cancel"));
        cancelBtn.addActionListener(closeEventHandler);
        JPanel btnPanel = ButtonBarFactory.buildOKCancelBar(okBtn, cancelBtn);
        contentPB.add((Component)btnPanel, cc.xywh(2, rowCount - 1, columnCount - 2, 1));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(okBtn);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public final class TermsRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
            } else {
                this.setText("'" + value.toString() + "'");
            }
            return this;
        }
    }

    public final class TermsModel
    extends AbstractListModel {
        public int getSize() {
            return FileNameCondEditor.this.condition.getTermsCount();
        }

        public Object getElementAt(int index) {
            return FileNameCondEditor.this.condition.getTermsList().get(index);
        }

        public void fireChange() {
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            FileNameCondEditor.this.closeDialog();
        }

        public void actionPerformed(ActionEvent e) {
            FileNameCondEditor.this.closeDialog();
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FileNameCondEditor.this.orgCondition.update(FileNameCondEditor.this.condition);
                FileNameCondEditor.this.ruleDescPanel.updateRuleData();
                FileNameCondEditor.this.closeDialog();
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }
    }

    private final class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int idx = FileNameCondEditor.this.termsList.getSelectedIndex();
            Object[] values = FileNameCondEditor.this.termsList.getSelectedValues();
            for (int i = 0; i < values.length; ++i) {
                FileNameCondEditor.this.condition.removeTerm((String)values[i]);
            }
            FileNameCondEditor.this.termsModel.fireChange();
            int modelSize = FileNameCondEditor.this.termsModel.getSize();
            if (modelSize == 0) {
                FileNameCondEditor.this.termTF.requestFocusInWindow();
            } else {
                FileNameCondEditor.this.termsList.setSelectedIndex(Math.max(0, Math.min(idx, modelSize - 1)));
            }
        }
    }

    private final class AddActionListener
    implements ActionListener {
        private AddActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String term = FileNameCondEditor.this.termTF.getText().trim();
            if (StringUtils.isEmpty(term)) {
                return;
            }
            FileNameCondEditor.this.condition.addTerm(term);
            FileNameCondEditor.this.termTF.setText("");
            FileNameCondEditor.this.termsModel.fireChange();
            FileNameCondEditor.this.termTF.requestFocusInWindow();
        }
    }
}

