/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import phex.gui.dialogs.filter.RuleDescOwnerDialog;
import phex.gui.dialogs.filter.RuleDescriptionPanel;
import phex.gui.dialogs.filter.wizard.RulePropertiesPanel;
import phex.gui.dialogs.filter.wizard.condition.ConditionPanel;
import phex.gui.dialogs.filter.wizard.consequence.ConsequencePanel;
import phex.gui.dialogs.filter.wizard.exception.ExceptionPanel;
import phex.rules.Rule;
import phex.rules.condition.Condition;
import phex.rules.condition.NotCondition;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.StringUtils;

public class FilterWizardDialog
extends JDialog
implements RuleDescOwnerDialog {
    private static final int CONDITION_PAGE = 1;
    private static final int CONSEQUENCE_PAGE = 2;
    private static final int EXCEPTION_PAGE = 3;
    private static final int RULE_PROPERTIES_PAGE = 4;
    private Rule editRule;
    private JPanel ruleEditPanel;
    private ConditionPanel conditionPanel;
    private ConsequencePanel consequencePanel;
    private ExceptionPanel exceptionPanel;
    private RulePropertiesPanel rulePropertiesPanel;
    private RuleDescriptionPanel ruleDescPanel;
    private int currentPage = 1;
    private JButton finishBtn;
    private JButton backBtn;
    private JButton nextBtn;

    public FilterWizardDialog(JDialog parent) {
        this(new Rule(), parent);
    }

    public FilterWizardDialog(Rule ruleToEdit, JDialog parent) {
        super(parent, Localizer.getString("RuleWizard_DialogTitle"), true);
        this.editRule = ruleToEdit;
        if (this.editRule.isDefaultRule()) {
            this.currentPage = 4;
        }
        this.prepareComponent();
        this.updateRuleData();
    }

    public Rule getEditRule() {
        return this.editRule;
    }

    public void updateRuleData() {
        if (this.conditionPanel != null) {
            this.conditionPanel.updateRuleData();
        }
        if (this.consequencePanel != null) {
            this.consequencePanel.updateRuleData();
        }
        if (this.exceptionPanel != null) {
            this.exceptionPanel.updateRuleData();
        }
        if (this.rulePropertiesPanel != null) {
            this.rulePropertiesPanel.updateRuleData();
        }
        this.ruleDescPanel.updateRuleData();
        this.setFinishBtnEnabled(!StringUtils.isEmpty(this.editRule.getName()));
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("4dlu, fill:d:grow, 4dlu", "4dlu, fill:p:grow, 12dlu, fill:p:grow, 8dlu,p, 2dlu, p 4dlu");
        PanelBuilder contentPB = new PanelBuilder(layout, contentPanel);
        int columnCount = layout.getColumnCount();
        int rowCount = layout.getRowCount();
        this.ruleEditPanel = new JPanel();
        this.ruleEditPanel.setLayout(new BorderLayout());
        contentPB.add((Component)this.ruleEditPanel, cc.xywh(2, 2, 1, 1));
        this.ruleDescPanel = new RuleDescriptionPanel(this);
        contentPB.add((Component)this.ruleDescPanel, cc.xywh(2, 4, 1, 1));
        contentPB.add((Component)new JSeparator(), cc.xywh(1, rowCount - 3, columnCount, 1));
        this.backBtn = new JButton(Localizer.getString("WizardDialog_Back"));
        this.backBtn.addActionListener(new BackBtnListener());
        this.nextBtn = new JButton(Localizer.getString("WizardDialog_Next"));
        this.nextBtn.setDefaultCapable(true);
        this.nextBtn.setRequestFocusEnabled(true);
        this.nextBtn.addActionListener(new NextBtnListener());
        this.finishBtn = new JButton(Localizer.getString("WizardDialog_Finish"));
        this.finishBtn.addActionListener(new FinishBtnListener());
        JButton cancelBtn = new JButton(Localizer.getString("WizardDialog_Cancel"));
        cancelBtn.addActionListener(closeEventHandler);
        JPanel btnPanel = ButtonBarFactory.buildWizardBar(this.backBtn, this.nextBtn, this.finishBtn, cancelBtn);
        contentPB.add((Component)btnPanel, cc.xywh(2, rowCount - 1, columnCount - 2, 1));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.nextBtn);
        this.updatePage();
        this.pack();
        int height = this.getHeight();
        this.setSize(height * 5 / 4, height);
        this.setLocationRelativeTo(this.getParent());
    }

    public void setFinishBtnEnabled(boolean state) {
        this.finishBtn.setEnabled(state);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private boolean isRuleInputComplete() {
        List list = this.editRule.getConditions();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Condition condition = (Condition)iterator.next();
            if (condition instanceof NotCondition) {
                condition = ((NotCondition)condition).getContainedCondition();
            }
            if (condition.isComplete()) continue;
            return false;
        }
        return true;
    }

    private void updatePage() {
        this.ruleEditPanel.removeAll();
        JPanel newPage = null;
        switch (this.currentPage) {
            case 1: {
                if (this.conditionPanel == null) {
                    this.conditionPanel = new ConditionPanel(this);
                }
                newPage = this.conditionPanel;
                this.backBtn.setEnabled(false);
                this.nextBtn.setEnabled(true);
                break;
            }
            case 2: {
                if (this.consequencePanel == null) {
                    this.consequencePanel = new ConsequencePanel(this);
                }
                newPage = this.consequencePanel;
                this.backBtn.setEnabled(true);
                this.nextBtn.setEnabled(true);
                break;
            }
            case 3: {
                if (this.exceptionPanel == null) {
                    this.exceptionPanel = new ExceptionPanel(this);
                }
                newPage = this.exceptionPanel;
                this.backBtn.setEnabled(true);
                this.nextBtn.setEnabled(true);
                break;
            }
            case 4: {
                if (this.rulePropertiesPanel == null) {
                    this.rulePropertiesPanel = new RulePropertiesPanel(this);
                }
                newPage = this.rulePropertiesPanel;
                this.nextBtn.setEnabled(false);
                if (this.editRule != null && this.editRule.isDefaultRule()) {
                    this.backBtn.setEnabled(false);
                    break;
                }
                this.backBtn.setEnabled(true);
            }
        }
        this.ruleEditPanel.add(newPage, "Center");
        this.updateRuleData();
        this.ruleEditPanel.doLayout();
        this.ruleEditPanel.revalidate();
        this.ruleEditPanel.repaint();
        Dimension prefSize = this.getPreferredSize();
        Dimension currSize = this.getSize();
        if (prefSize.height > currSize.height) {
            int height = Math.max(prefSize.height, currSize.height);
            this.setSize(height * 5 / 4, height);
            this.doLayout();
        }
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            FilterWizardDialog.this.editRule = null;
            FilterWizardDialog.this.closeDialog();
        }

        public void actionPerformed(ActionEvent e) {
            FilterWizardDialog.this.editRule = null;
            FilterWizardDialog.this.closeDialog();
        }
    }

    private final class FinishBtnListener
    implements ActionListener {
        private FinishBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FilterWizardDialog.this.closeDialog();
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }
    }

    private final class BackBtnListener
    implements ActionListener {
        private BackBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                switch (FilterWizardDialog.this.currentPage) {
                    case 2: {
                        FilterWizardDialog.this.currentPage = 1;
                        break;
                    }
                    case 3: {
                        FilterWizardDialog.this.currentPage = 2;
                        break;
                    }
                    case 4: {
                        FilterWizardDialog.this.currentPage = 3;
                    }
                }
                FilterWizardDialog.this.updatePage();
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }
    }

    private final class NextBtnListener
    implements ActionListener {
        private NextBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (!FilterWizardDialog.this.isRuleInputComplete()) {
                    this.displayRuleInputMissingError();
                    return;
                }
                switch (FilterWizardDialog.this.currentPage) {
                    case 1: {
                        FilterWizardDialog.this.currentPage = 2;
                        break;
                    }
                    case 2: {
                        FilterWizardDialog.this.currentPage = 3;
                        break;
                    }
                    case 3: {
                        FilterWizardDialog.this.currentPage = 4;
                    }
                }
                FilterWizardDialog.this.updatePage();
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }

        private void displayRuleInputMissingError() {
            JOptionPane.showMessageDialog(FilterWizardDialog.this, Localizer.getString("RuleWizard_MissingRuleInputText"), Localizer.getString("RuleWizard_MissingRuleInputTitle"), 0);
        }
    }
}

