/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import phex.common.ServiceManager;
import phex.common.bandwidth.BandwidthManager;
import phex.common.format.NumberFormatUtils;
import phex.gui.common.GUIRegistry;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class BandwidthPane
extends OptionsSettingsPane {
    private int UNLIMITED_VALUE = 101;
    private SpeedDefinition[] speedDefinitions = new SpeedDefinition[]{new SpeedDefinition("Modem", 56), new SpeedDefinition("ISDN", 64), new SpeedDefinition("DualISDN", 128), new SpeedDefinition("DSLCable1", 256), new SpeedDefinition("DSLCable2", 512), new SpeedDefinition("DSLCable3", 768), new SpeedDefinition("T1", 1544), new SpeedDefinition("10LAN", 10000), new SpeedDefinition("T3", 44736), new SpeedDefinition("100LAN", 100000), new SpeedDefinition("1000LAN", 1000000)};
    private Dictionary linearSliderLabels = new Hashtable(5);
    private JComboBox connectionSpeedCbx;
    private JLabel totalBandwidthLabel;
    private JSlider totalBandwidthSldr;
    private JLabel netBandwidthLabel;
    private JSlider netBandwidthSldr;
    private JLabel downloadBandwidthLabel;
    private JSlider downloadBandwidthSldr;
    private JLabel uploadBandwidthLabel;
    private JSlider uploadBandwidthSldr;
    private JCheckBox useLogSlider;
    private double maxConnectionBandwidth;
    private double currentTotalBandwidth;
    private double currentNetBandwidth;
    private double currentDownloadBandwidth;
    private double currentUploadBandwidth;
    private boolean updateSliderLabels = true;

    public BandwidthPane() {
        super("Bandwidth");
        this.linearSliderLabels.put(new Integer(0), new JLabel("0%", 0));
        this.linearSliderLabels.put(new Integer(25), new JLabel("25%", 0));
        this.linearSliderLabels.put(new Integer(50), new JLabel("50%", 0));
        this.linearSliderLabels.put(new Integer(75), new JLabel("75%", 0));
        this.linearSliderLabels.put(new Integer(100), new JLabel("100%", 0));
    }

    protected void prepareComponent() {
        boolean linearScale = !GUIRegistry.getInstance().useLogBandwidthSlider();
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        this.add((Component)contentPanel, "Center");
        FormLayout layout = new FormLayout("10dlu, d, 2dlu, d, right:d:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, p, 3dlu, p");
        contentPanel.setLayout(layout);
        PanelBuilder builder = new PanelBuilder(layout, contentPanel);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Localizer.getString("NetworkSpeedSettings"), cc.xywh(1, 1, 5, 1));
        builder.addLabel(Localizer.getString("ConnectionTypeSpeed") + ": ", cc.xy(2, 3));
        this.connectionSpeedCbx = new JComboBox<SpeedDefinition>(this.speedDefinitions);
        this.connectionSpeedCbx.addItemListener(new SpeedItemListener());
        builder.add((Component)this.connectionSpeedCbx, cc.xy(4, 3));
        builder.addLabel(Localizer.getString("TotalBandwidth") + ": ", cc.xywh(2, 5, 3, 1));
        this.totalBandwidthLabel = new JLabel();
        builder.add((Component)this.totalBandwidthLabel, cc.xy(5, 5));
        this.totalBandwidthSldr = new JSlider(0, 0, 101, 0);
        this.totalBandwidthSldr.addChangeListener(new SliderChangeListener());
        this.totalBandwidthSldr.setPaintLabels(true);
        builder.add((Component)this.totalBandwidthSldr, cc.xywh(2, 7, 4, 1));
        builder.addSeparator(Localizer.getString("PhexBandwidthSettings"), cc.xywh(1, 9, 5, 1));
        builder.addLabel(Localizer.getString("MaxNetworkBandwidth") + ": ", cc.xywh(2, 11, 3, 1));
        this.netBandwidthLabel = new JLabel();
        builder.add((Component)this.netBandwidthLabel, cc.xy(5, 11));
        this.netBandwidthSldr = new JSlider(0, 0, 101, 0);
        this.netBandwidthSldr.addChangeListener(new SliderChangeListener());
        builder.add((Component)this.netBandwidthSldr, cc.xywh(2, 13, 4, 1));
        builder.addLabel(Localizer.getString("MaxDownloadBandwidth") + ": ", cc.xywh(2, 15, 3, 1));
        this.downloadBandwidthLabel = new JLabel();
        builder.add((Component)this.downloadBandwidthLabel, cc.xy(5, 15));
        this.downloadBandwidthSldr = new JSlider(0, 0, 101, 0);
        this.downloadBandwidthSldr.addChangeListener(new SliderChangeListener());
        builder.add((Component)this.downloadBandwidthSldr, cc.xywh(2, 17, 4, 1));
        builder.addLabel(Localizer.getString("MaxUploadBandwidth") + ": ", cc.xywh(2, 19, 3, 1));
        this.uploadBandwidthLabel = new JLabel();
        builder.add((Component)this.uploadBandwidthLabel, cc.xy(5, 19));
        this.uploadBandwidthSldr = new JSlider(0, 0, 101, 0);
        this.uploadBandwidthSldr.addChangeListener(new SliderChangeListener());
        builder.add((Component)this.uploadBandwidthSldr, cc.xywh(2, 21, 4, 1));
        this.useLogSlider = new JCheckBox(Localizer.getString("BandwidthSettings_UseLogarithmicSliders"), !linearScale);
        this.useLogSlider.setToolTipText(Localizer.getString("BandwidthSettings_TTTUseLogarithmicSliders"));
        this.useLogSlider.addActionListener(new LogSliderActionListener());
        builder.add((Component)this.useLogSlider, cc.xywh(2, 23, 4, 1, "right, center"));
        this.initConfigValues();
    }

    public void checkInput(HashMap inputDic) {
    }

    public void displayErrorMessage(HashMap inputDic) {
    }

    public void saveAndApplyChanges(HashMap inputDic) {
        SpeedDefinition def = (SpeedDefinition)this.connectionSpeedCbx.getSelectedItem();
        int value = def.getSpeedInKbps();
        if (ServiceManager.sCfg.networkSpeedKbps != value) {
            ServiceManager.sCfg.networkSpeedKbps = value;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.maxTotalBandwidth != (value = this.totalBandwidthSldr.getValue() == this.UNLIMITED_VALUE ? Integer.MAX_VALUE : (int)Math.round(this.currentTotalBandwidth))) {
            BandwidthManager.getInstance().setPhexTotalBandwidth(value);
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.mNetMaxRate != (value = this.netBandwidthSldr.getValue() == this.UNLIMITED_VALUE ? Integer.MAX_VALUE : (int)Math.round(this.currentNetBandwidth))) {
            BandwidthManager.getInstance().setNetworkBandwidth(value);
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.mDownloadMaxBandwidth != (value = this.downloadBandwidthSldr.getValue() == this.UNLIMITED_VALUE ? Integer.MAX_VALUE : (int)Math.round(this.currentDownloadBandwidth))) {
            BandwidthManager.getInstance().setDownloadBandwidth(value);
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.mUploadMaxBandwidth != (value = this.uploadBandwidthSldr.getValue() == this.UNLIMITED_VALUE ? Integer.MAX_VALUE : (int)Math.round(this.currentUploadBandwidth))) {
            BandwidthManager.getInstance().setUploadBandwidth(value);
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
    }

    private void initConfigValues() {
        int netSpeed = ServiceManager.sCfg.networkSpeedKbps;
        for (int i = 0; i < this.speedDefinitions.length; ++i) {
            SpeedDefinition currentDef = this.speedDefinitions[i];
            int speedDiff = currentDef.getSpeedInKbps() - netSpeed;
            if (speedDiff < 0) continue;
            this.connectionSpeedCbx.setSelectedIndex(i);
            if (i != 0) break;
            this.updateMaxConnectionBandwidth(currentDef);
            break;
        }
        double bandwidth = ServiceManager.sCfg.maxTotalBandwidth;
        this.totalBandwidthSldr.setValue(this.bw2raw(bandwidth, this.maxConnectionBandwidth));
        bandwidth = ServiceManager.sCfg.mNetMaxRate;
        this.netBandwidthSldr.setValue(this.bw2raw(bandwidth, this.currentTotalBandwidth));
        bandwidth = ServiceManager.sCfg.mDownloadMaxBandwidth;
        this.downloadBandwidthSldr.setValue(this.bw2raw(bandwidth, this.currentTotalBandwidth));
        bandwidth = ServiceManager.sCfg.mUploadMaxBandwidth;
        this.uploadBandwidthSldr.setValue(this.bw2raw(bandwidth, this.currentTotalBandwidth));
    }

    private void calculateBandwidth() {
        String labelText;
        int value = this.totalBandwidthSldr.getValue();
        if (value == this.UNLIMITED_VALUE) {
            labelText = Localizer.getString("Unlimited");
            this.currentTotalBandwidth = this.maxConnectionBandwidth;
        } else {
            this.currentTotalBandwidth = this.raw2bw(value, this.maxConnectionBandwidth);
            labelText = NumberFormatUtils.formatSignificantByteSize(this.currentTotalBandwidth) + Localizer.getString("PerSec");
        }
        this.totalBandwidthLabel.setText(labelText);
        value = this.netBandwidthSldr.getValue();
        if (value == this.UNLIMITED_VALUE) {
            labelText = Localizer.getString("Unlimited");
            this.currentNetBandwidth = this.maxConnectionBandwidth;
        } else {
            this.currentNetBandwidth = this.raw2bw(value, this.currentTotalBandwidth);
            labelText = NumberFormatUtils.formatSignificantByteSize(this.currentNetBandwidth) + Localizer.getString("PerSec");
        }
        this.netBandwidthLabel.setText(labelText);
        value = this.downloadBandwidthSldr.getValue();
        if (value == this.UNLIMITED_VALUE) {
            labelText = Localizer.getString("Unlimited");
            this.currentDownloadBandwidth = this.maxConnectionBandwidth;
        } else {
            this.currentDownloadBandwidth = this.raw2bw(value, this.currentTotalBandwidth);
            labelText = NumberFormatUtils.formatSignificantByteSize(this.currentDownloadBandwidth) + Localizer.getString("PerSec");
        }
        this.downloadBandwidthLabel.setText(labelText);
        value = this.uploadBandwidthSldr.getValue();
        if (value == this.UNLIMITED_VALUE) {
            labelText = Localizer.getString("Unlimited");
            this.currentUploadBandwidth = this.maxConnectionBandwidth;
        } else {
            this.currentUploadBandwidth = this.raw2bw(value, this.currentTotalBandwidth);
            labelText = NumberFormatUtils.formatSignificantByteSize(this.currentUploadBandwidth) + Localizer.getString("PerSec");
        }
        this.uploadBandwidthLabel.setText(labelText);
        if (this.updateSliderLabels) {
            if (GUIRegistry.getInstance().useLogBandwidthSlider()) {
                Hashtable<Integer, JLabel> logSliderLabels = new Hashtable<Integer, JLabel>();
                logSliderLabels.put(new Integer(0), new JLabel("0%", 0));
                double subBandwidth = this.maxConnectionBandwidth / 200.0;
                int val = this.bw2raw(subBandwidth, this.maxConnectionBandwidth);
                logSliderLabels.put(new Integer(val), new JLabel("0.5%", 0));
                subBandwidth = this.maxConnectionBandwidth / 20.0;
                val = this.bw2raw(subBandwidth, this.maxConnectionBandwidth);
                logSliderLabels.put(new Integer(val), new JLabel("5%", 0));
                logSliderLabels.put(new Integer(100), new JLabel("100%", 0));
                this.totalBandwidthSldr.setLabelTable(logSliderLabels);
            } else {
                this.totalBandwidthSldr.setLabelTable(this.linearSliderLabels);
            }
            this.updateSliderLabels = false;
        }
    }

    private double raw2bw(int sliderValue, double maximum) {
        if (sliderValue == 0) {
            return 0.0;
        }
        if (GUIRegistry.getInstance().useLogBandwidthSlider()) {
            double exponent = (double)sliderValue / 100.0;
            double substractor = 0.0;
            double pow = Math.pow(maximum - substractor, exponent);
            double res = pow + substractor * exponent;
            return res;
        }
        return (double)sliderValue * maximum / 100.0;
    }

    private int bw2raw(double bwValue, double maximum) {
        if (bwValue == 0.0) {
            return 0;
        }
        if (bwValue > maximum) {
            return this.UNLIMITED_VALUE;
        }
        if (GUIRegistry.getInstance().useLogBandwidthSlider()) {
            double exponent = Math.log(bwValue) / Math.log(maximum);
            int sliderValue = (int)Math.round(exponent * 100.0);
            return sliderValue;
        }
        return (int)(bwValue * 100.0 / maximum);
    }

    private void updateMaxConnectionBandwidth(SpeedDefinition speedDefinition) {
        this.maxConnectionBandwidth = speedDefinition.getSpeedInKB() * 1024.0;
        this.updateSliderLabels = true;
        this.calculateBandwidth();
    }

    private void updateLogSliderUsage() {
        this.updateSliderLabels = true;
        GUIRegistry.getInstance().setLogBandwidthSliderUsed(this.useLogSlider.isSelected());
        this.calculateBandwidth();
    }

    private static class SpeedDefinition {
        private String representation;
        private int speedInKbps;

        public SpeedDefinition(String aRepresentation, int aSpeedInKbps) {
            this.representation = Localizer.getString(aRepresentation);
            this.speedInKbps = aSpeedInKbps;
        }

        public double getSpeedInKB() {
            return this.speedInKbps / 8;
        }

        public int getSpeedInKbps() {
            return this.speedInKbps;
        }

        public String toString() {
            return this.representation;
        }
    }

    private class SpeedItemListener
    implements ItemListener {
        private SpeedItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                SpeedDefinition speedDefinition = (SpeedDefinition)e.getItem();
                BandwidthPane.this.updateMaxConnectionBandwidth(speedDefinition);
            }
        }
    }

    private class LogSliderActionListener
    implements ActionListener {
        private LogSliderActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            BandwidthPane.this.updateLogSliderUsage();
        }
    }

    private class SliderChangeListener
    implements ChangeListener {
        private SliderChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            BandwidthPane.this.calculateBandwidth();
        }
    }
}

