/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import phex.common.ServiceManager;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class DisconnectPane
extends OptionsSettingsPane {
    private JCheckBox applyPolicyChkbx;
    private IntegerTextField maxSendQueueTF;
    private JSlider dropPacketExceedsSlider;
    private JLabel dropPacketExceedsLabel;
    private IntegerTextField minSharedFilesTF;
    private IntegerTextField minSharedMBTF;
    private JCheckBox emptyVendorStringChkbx;
    private static final String APPLY_POLICY_KEY = "applyPolicy";
    private static final String SEND_QUEUE_KEY = "sendQueue";
    private static final String DROP_PACKET_KEY = "dropPacket";
    private static final String VENDOR_KEY = "vendor";
    private static final String SHARED_FILES_KEY = "sharedFiles";
    private static final String SHARED_MB_KEY = "sharedMb";

    public DisconnectPane() {
        super("DisconnectPolicy");
    }

    protected void prepareComponent() {
        this.setLayout(new GridBagLayout());
        JPanel generalPanel = new JPanel(new GridBagLayout());
        generalPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("DisconnectPolicy")));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(3, 0, 5, 0);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)generalPanel, constraints);
        this.applyPolicyChkbx = new JCheckBox(Localizer.getString("DisconnectNodesAccordingRules"), ServiceManager.sCfg.mDisconnectApplyPolicy);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 4;
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 5, 0);
        constraints.weightx = 1.0;
        generalPanel.add((Component)this.applyPolicyChkbx, constraints);
        this.emptyVendorStringChkbx = new JCheckBox(Localizer.getString("DisconnectNoVendorNodes"), ServiceManager.sCfg.isNoVendorNodeDisconnected);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 15, 3, 0);
        constraints.gridwidth = 4;
        generalPanel.add((Component)this.emptyVendorStringChkbx, constraints);
        JLabel label = new JLabel(Localizer.getString("SendQueueExceeds") + Localizer.getString("ColonSign") + " ");
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 15, 3, 5);
        generalPanel.add((Component)label, constraints);
        this.maxSendQueueTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetMaxSendQueue), 3, 3);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 3, 0);
        generalPanel.add((Component)this.maxSendQueueTF, constraints);
        label = new JLabel(Localizer.getString("MinSharedFiles") + Localizer.getString("ColonSign") + " ");
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 15, 3, 5);
        generalPanel.add((Component)label, constraints);
        this.minSharedFilesTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.freeloaderFiles), 4, 4);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 3, 0);
        generalPanel.add((Component)this.minSharedFilesTF, constraints);
        label = new JLabel(Localizer.getString("MinSharedMB") + Localizer.getString("ColonSign") + " ");
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 5;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 15, 3, 5);
        generalPanel.add((Component)label, constraints);
        this.minSharedMBTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.freeloaderShareSize), 4, 4);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 5;
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 3, 0);
        generalPanel.add((Component)this.minSharedMBTF, constraints);
        label = new JLabel(Localizer.getString("DropPacketExceeds") + Localizer.getString("ColonSign") + " ");
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 15, 3, 5);
        generalPanel.add((Component)label, constraints);
        JPanel percentPanel = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 6;
        constraints.gridwidth = 3;
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 3, 0);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        generalPanel.add((Component)percentPanel, constraints);
        this.dropPacketExceedsLabel = new JLabel(String.valueOf(ServiceManager.sCfg.mDisconnectDropRatio) + Localizer.getString("PercentSign"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 3, 5);
        percentPanel.add((Component)this.dropPacketExceedsLabel, constraints);
        this.dropPacketExceedsSlider = new JSlider(0, 100, ServiceManager.sCfg.mDisconnectDropRatio);
        this.dropPacketExceedsSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DisconnectPane.this.dropPacketExceedsLabel.setText(String.valueOf(DisconnectPane.this.dropPacketExceedsSlider.getValue()) + Localizer.getString("PercentSign"));
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 3, 0);
        percentPanel.add((Component)this.dropPacketExceedsSlider, constraints);
    }

    public void checkInput(HashMap inputDic) {
        try {
            inputDic.put(SEND_QUEUE_KEY, new Integer(this.maxSendQueueTF.getText()));
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.maxSendQueueTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            inputDic.put(SHARED_FILES_KEY, new Integer(this.minSharedFilesTF.getText()));
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.minSharedFilesTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            inputDic.put(SHARED_MB_KEY, new Integer(this.minSharedMBTF.getText()));
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.minSharedMBTF);
            this.setInputValid(inputDic, false);
            return;
        }
        inputDic.put(DROP_PACKET_KEY, new Integer(this.dropPacketExceedsSlider.getValue()));
        inputDic.put(APPLY_POLICY_KEY, this.applyPolicyChkbx.isSelected());
        inputDic.put(VENDOR_KEY, this.emptyVendorStringChkbx.isSelected());
        this.setInputValid(inputDic, true);
    }

    public void saveAndApplyChanges(HashMap inputDic) {
        boolean changed = false;
        Boolean applyPolicy = (Boolean)inputDic.get(APPLY_POLICY_KEY);
        Integer sendQueue = (Integer)inputDic.get(SEND_QUEUE_KEY);
        Integer dropPacket = (Integer)inputDic.get(DROP_PACKET_KEY);
        Boolean vendor = (Boolean)inputDic.get(VENDOR_KEY);
        Integer sharedFiles = (Integer)inputDic.get(SHARED_FILES_KEY);
        Integer sharedMb = (Integer)inputDic.get(SHARED_MB_KEY);
        if (applyPolicy != null && applyPolicy != ServiceManager.sCfg.mDisconnectApplyPolicy) {
            ServiceManager.sCfg.mDisconnectApplyPolicy = applyPolicy;
            changed = true;
        }
        if (sendQueue != null && sendQueue != ServiceManager.sCfg.mNetMaxSendQueue) {
            ServiceManager.sCfg.mNetMaxSendQueue = sendQueue;
            changed = true;
        }
        if (dropPacket != null && dropPacket != ServiceManager.sCfg.mDisconnectDropRatio) {
            ServiceManager.sCfg.mDisconnectDropRatio = dropPacket;
            changed = true;
        }
        if (vendor != null && vendor != ServiceManager.sCfg.isNoVendorNodeDisconnected) {
            ServiceManager.sCfg.isNoVendorNodeDisconnected = vendor;
            changed = true;
        }
        if (sharedFiles != null && sharedFiles != ServiceManager.sCfg.freeloaderFiles) {
            ServiceManager.sCfg.freeloaderFiles = sharedFiles;
            changed = true;
        }
        if (sharedMb != null && sharedMb != ServiceManager.sCfg.freeloaderShareSize) {
            ServiceManager.sCfg.freeloaderShareSize = sharedMb;
            changed = true;
        }
        if (changed) {
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
    }
}

