/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import phex.common.ServiceManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.LookAndFeelFailedException;
import phex.gui.common.LookAndFeelUtils;
import phex.gui.common.MainFrame;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.gui.renderer.LAFListCellRenderer;
import phex.gui.renderer.LAFThemeListCellRenderer;
import phex.gui.tabs.search.SearchTab;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class GeneralUIPane
extends OptionsSettingsPane {
    private static final String INSTANCIATED_LAF_KEY = "InstanciatedLAF";
    private static final String INSTANCIATED_THEME_KEY = "InstanciatedLAFTheme";
    private static final String LAF_ERROR_KEY = "LAFError";
    private static final String LAF_NOT_SUPPORTED = "LAFNotSupported";
    private static final String LAF_NOT_FOUND = "LAFNotFound";
    private static final String LAF_ACCESS_ERROR = "LAFAccessError";
    private static final String LAF_INSTANTIATION_ERROR = "LAFInstantiationError";
    private static final String THEME_NOT_FOUND = "ThemeNotFound";
    private static final String THEME_ACCESS_ERROR = "ThemeAccessError";
    private static final String THEME_INSTANTIATION_ERROR = "ThemeInstantiationError";
    private GUIRegistry guiRegistry = GUIRegistry.getInstance();
    private JComboBox lafBox;
    private DefaultComboBoxModel themeModel;
    private JComboBox themeBox;
    private JCheckBox displayTooltipChkbx;
    private JCheckBox showTableHorizontalLinesChkbx;
    private JCheckBox showTableVerticalLinesChkbx;
    private JCheckBox minimizeWhenClosingChkbx;

    public GeneralUIPane() {
        super("General");
    }

    public void checkInput(HashMap inputDic) {
        inputDic.remove(INSTANCIATED_LAF_KEY);
        inputDic.remove(LAF_ERROR_KEY);
        inputDic.remove(INSTANCIATED_THEME_KEY);
        UIManager.LookAndFeelInfo lafInfo = (UIManager.LookAndFeelInfo)this.lafBox.getSelectedItem();
        try {
            Class<?> lnfClass = Class.forName(lafInfo.getClassName());
            LookAndFeel laf = (LookAndFeel)lnfClass.newInstance();
            if (!laf.isSupportedLookAndFeel()) {
                inputDic.put(LAF_ERROR_KEY, LAF_NOT_SUPPORTED);
                this.setInputValid(inputDic, false);
                return;
            }
            inputDic.put(INSTANCIATED_LAF_KEY, laf);
        }
        catch (ClassNotFoundException exp) {
            inputDic.put(LAF_ERROR_KEY, LAF_NOT_FOUND);
            this.setInputValid(inputDic, false);
            return;
        }
        catch (IllegalAccessException exp) {
            inputDic.put(LAF_ERROR_KEY, LAF_ACCESS_ERROR);
            this.setInputValid(inputDic, false);
            return;
        }
        catch (InstantiationException exp) {
            inputDic.put(LAF_ERROR_KEY, LAF_INSTANTIATION_ERROR);
            this.setInputValid(inputDic, false);
            return;
        }
        LookAndFeelUtils.ThemeInfo themeInfo = (LookAndFeelUtils.ThemeInfo)this.themeBox.getSelectedItem();
        LookAndFeelUtils.ThemeInfo currentTheme = LookAndFeelUtils.getCurrentTheme(UIManager.getLookAndFeel().getClass().getName());
        if (themeInfo != null && currentTheme != null && themeInfo.getClassName().equals(currentTheme.getClassName())) {
            themeInfo = null;
        }
        if (themeInfo != null) {
            try {
                Class<?> themeClass = Class.forName(themeInfo.getClassName());
                Object theme = themeClass.newInstance();
                inputDic.put(INSTANCIATED_THEME_KEY, theme);
            }
            catch (ClassNotFoundException exp) {
                inputDic.put(LAF_ERROR_KEY, THEME_NOT_FOUND);
                this.setInputValid(inputDic, false);
                return;
            }
            catch (IllegalAccessException exp) {
                inputDic.put(LAF_ERROR_KEY, THEME_ACCESS_ERROR);
                this.setInputValid(inputDic, false);
                return;
            }
            catch (InstantiationException exp) {
                inputDic.put(LAF_ERROR_KEY, THEME_INSTANTIATION_ERROR);
                this.setInputValid(inputDic, false);
                return;
            }
        }
        this.setInputValid(inputDic, true);
    }

    public void displayErrorMessage(HashMap inputDic) {
        Object value = inputDic.get(LAF_ERROR_KEY);
        if (value != null) {
            JOptionPane.showMessageDialog(this, Localizer.getString((String)value), Localizer.getString(LAF_ERROR_KEY), 0);
        }
    }

    public void saveAndApplyChanges(HashMap inputDic) {
        boolean minimizeOnClose;
        boolean tooltip;
        Object theme;
        LookAndFeel laf = (LookAndFeel)inputDic.get(INSTANCIATED_LAF_KEY);
        if (!UIManager.getLookAndFeel().getClass().getName().equals(laf.getClass().getName())) {
            try {
                LookAndFeelUtils.setLookAndFeel(laf);
            }
            catch (LookAndFeelFailedException exp) {
                JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + laf.getName(), "Error", 0);
            }
        }
        if ((theme = inputDic.get(INSTANCIATED_THEME_KEY)) != null) {
            LookAndFeelUtils.setCurrentTheme(laf.getClass().getName(), theme);
        }
        if (ServiceManager.sCfg.mUIDisplayTooltip != (tooltip = this.displayTooltipChkbx.isSelected())) {
            ServiceManager.sCfg.mUIDisplayTooltip = tooltip;
            ToolTipManager.sharedInstance().setEnabled(tooltip);
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.minimizeToBackground != (minimizeOnClose = this.minimizeWhenClosingChkbx.isSelected())) {
            ServiceManager.sCfg.minimizeToBackground = minimizeOnClose;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        boolean triggerUIUpdate = false;
        boolean showHorizontalLines = this.showTableHorizontalLinesChkbx.isSelected();
        if (this.guiRegistry.getShowTableHorizontalLines() != showHorizontalLines) {
            this.guiRegistry.setShowTableHorizontalLines(showHorizontalLines);
            triggerUIUpdate = true;
        }
        boolean showVerticalLines = this.showTableVerticalLinesChkbx.isSelected();
        if (this.guiRegistry.getShowTableVerticalLines() != showVerticalLines) {
            this.guiRegistry.setShowTableVerticalLines(showVerticalLines);
            triggerUIUpdate = true;
        }
        if (triggerUIUpdate) {
            GUIUtils.updateComponentsUI();
        }
    }

    protected void prepareComponent() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        this.add((Component)contentPanel, "Center");
        FormLayout layout = new FormLayout("10dlu, d, 2dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 5dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 5dlu, p");
        layout.setRowGroups(new int[][]{{3, 5, 7, 9, 11}});
        contentPanel.setLayout(layout);
        PanelBuilder builder = new PanelBuilder(layout, contentPanel);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Localizer.getString("GeneralUserInterfaceSettings"), cc.xywh(1, 1, 5, 1));
        JLabel lafLabel = builder.addLabel(Localizer.getString("LookAndFeel"), cc.xy(2, 3));
        lafLabel.setToolTipText(Localizer.getString("TTTLookAndFeel"));
        UIManager.LookAndFeelInfo[] lafs = LookAndFeelUtils.getAvailableLAFs();
        this.lafBox = new JComboBox<UIManager.LookAndFeelInfo>(lafs);
        this.lafBox.addItemListener(new LAFItemListener());
        int currentLAFIndex = this.determineCurrentLAFIndex(lafs);
        this.lafBox.setSelectedIndex(currentLAFIndex);
        this.lafBox.setRenderer(new LAFListCellRenderer());
        this.lafBox.setToolTipText(Localizer.getString("TTTLookAndFeel"));
        builder.add((Component)this.lafBox, cc.xy(4, 3));
        JLabel themeLabel = builder.addLabel(Localizer.getString("ColorTheme"), cc.xy(2, 5));
        themeLabel.setToolTipText(Localizer.getString("TTTColorTheme"));
        this.themeModel = new DefaultComboBoxModel();
        this.themeBox = new JComboBox(this.themeModel);
        this.themeBox.setToolTipText(Localizer.getString("TTTColorTheme"));
        builder.add((Component)this.themeBox, cc.xy(4, 5));
        UIManager.LookAndFeelInfo laf = (UIManager.LookAndFeelInfo)this.lafBox.getSelectedItem();
        this.updateThemes(laf);
        this.themeBox.setRenderer(new LAFThemeListCellRenderer());
        this.displayTooltipChkbx = new JCheckBox(Localizer.getString("DisplayTooltipText"), ServiceManager.sCfg.mUIDisplayTooltip);
        this.displayTooltipChkbx.setToolTipText(Localizer.getString("TTTDisplayTooltipText"));
        builder.add((Component)this.displayTooltipChkbx, cc.xywh(2, 7, 3, 1));
        this.showTableHorizontalLinesChkbx = new JCheckBox(Localizer.getString("ShowTableHorizontalLines"), this.guiRegistry.getShowTableHorizontalLines());
        this.showTableHorizontalLinesChkbx.setToolTipText(Localizer.getString("TTTShowTableHorizontalLines"));
        builder.add((Component)this.showTableHorizontalLinesChkbx, cc.xywh(2, 9, 3, 1));
        this.showTableVerticalLinesChkbx = new JCheckBox(Localizer.getString("ShowTableVerticalLines"), this.guiRegistry.getShowTableVerticalLines());
        this.showTableVerticalLinesChkbx.setToolTipText(Localizer.getString("TTTShowTableVerticalLines"));
        builder.add((Component)this.showTableVerticalLinesChkbx, cc.xywh(2, 11, 3, 1));
        String backgroundText = GUIRegistry.getInstance().getDesktopIndicator() != null ? Localizer.getString("WhenClosingMinToSysTray") : Localizer.getString("WhenClosingMinToBackground");
        this.minimizeWhenClosingChkbx = new JCheckBox(backgroundText, ServiceManager.sCfg.minimizeToBackground);
        builder.add((Component)this.minimizeWhenClosingChkbx, cc.xywh(2, 13, 3, 1));
        JButton clearSearchHistory = new JButton(Localizer.getString("UISettings_ClearSearchHistory"));
        clearSearchHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
                SearchTab searchTab = (SearchTab)mainFrame.getTab(1101);
                searchTab.clearSearchHistory();
            }
        });
        builder.add((Component)clearSearchHistory, cc.xywh(2, 15, 3, 1, "left,center"));
    }

    private int determineCurrentLAFIndex(UIManager.LookAndFeelInfo[] lafs) {
        LookAndFeel laf = UIManager.getLookAndFeel();
        String lafClassName = laf.getClass().getName();
        for (int i = 0; i < lafs.length; ++i) {
            if (!lafClassName.equals(lafs[i].getClassName())) continue;
            return i;
        }
        return -1;
    }

    private int determineCurrentThemeIndex(UIManager.LookAndFeelInfo lafs) {
        LookAndFeelUtils.ThemeInfo themeInfo = LookAndFeelUtils.getCurrentTheme(lafs.getClassName());
        if (themeInfo == null) {
            return -1;
        }
        return this.themeModel.getIndexOf(themeInfo);
    }

    private void updateThemes(UIManager.LookAndFeelInfo lafInfo) {
        LookAndFeelUtils.ThemeInfo[] themes = LookAndFeelUtils.getAvailableThemes(lafInfo.getClassName());
        this.themeModel = new DefaultComboBoxModel<LookAndFeelUtils.ThemeInfo>(themes);
        if (this.themeBox != null) {
            this.themeBox.setModel(this.themeModel);
            int currentThemeIndex = this.determineCurrentThemeIndex(lafInfo);
            this.themeBox.setSelectedIndex(currentThemeIndex);
        }
    }

    private class LAFItemListener
    implements ItemListener {
        private LAFItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            try {
                UIManager.LookAndFeelInfo lafInfo;
                if (e.getStateChange() == 1 && (lafInfo = (UIManager.LookAndFeelInfo)e.getItem()) != null) {
                    GeneralUIPane.this.updateThemes(lafInfo);
                }
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }
    }
}

