/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import phex.event.SearchListChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.query.QueryManager;
import phex.query.Search;
import phex.query.SearchContainer;

public class SearchComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private Object selectedItem = null;
    private SearchContainer searchContainer = QueryManager.getInstance().getSearchContainer();

    public SearchComboBoxModel() {
        this.searchContainer.addSearchListChangeListener(new SearchContainerChangeListener());
    }

    public int getSize() {
        return this.searchContainer.getSearchCount();
    }

    public Object getElementAt(int index) {
        Search search = this.searchContainer.getSearchAt(index);
        if (search == null) {
            this.fireIntervalRemoved(this, index, index);
            return null;
        }
        return search;
    }

    public void setSelectedItem(Object anItem) {
        this.selectedItem = anItem;
        this.fireContentsChanged(this, -1, -1);
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public class SearchContainerChangeListener
    implements SearchListChangeListener {
        private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

        public void searchChanged(int position) {
            this.lazyEventQueue.addListDataEvent(new ListDataEvent(SearchComboBoxModel.this, 0, position, position));
        }

        public void searchAdded(Search search, int position) {
            SearchComboBoxModel.this.fireIntervalAdded(SearchComboBoxModel.this, position, position);
            SearchComboBoxModel.this.setSelectedItem(SearchComboBoxModel.this.getElementAt(position));
        }

        public void searchRemoved(Search search, int position) {
            SearchComboBoxModel.this.fireIntervalRemoved(SearchComboBoxModel.this, position, position);
            SearchComboBoxModel.this.setSelectedItem(SearchComboBoxModel.this.getElementAt(0));
        }
    }
}

