/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import phex.common.format.HostSpeedFormatUtils;
import phex.download.RemoteFile;
import phex.gui.common.treetable.AbstractTreeTableModel;
import phex.gui.common.treetable.TreeTableModel;
import phex.gui.models.ISearchDataModel;
import phex.gui.models.ISortableModel;
import phex.gui.renderer.FileSizeCellRenderer;
import phex.gui.renderer.HostAddressCellRenderer;
import phex.gui.tabs.search.SearchResultElement;
import phex.utils.Localizer;

public class SearchTreeTableModel
extends AbstractTreeTableModel
implements TreeTableModel,
ISortableModel {
    public static final int HOST_COLUMN_ID = 1001;
    public static final int FILE_COLUMN_ID = 1002;
    public static final int EXTENSION_COLUMN_ID = 1003;
    public static final int SIZE_COLUMN_ID = 1004;
    public static final int SCORE_COLUMN_ID = 1005;
    public static final int HOST_RATING_COLUMN_ID = 1006;
    public static final int HOST_SPEED_COLUMN_ID = 1007;
    public static final int HOST_VENDOR_COLUMN_ID = 1008;
    public static final int META_DATA_COLUMN_ID = 1009;
    public static final int SHA1_COLUMN_ID = 1010;
    public static final int FILE_MODEL_INDEX = 0;
    public static final int EXTENSION_MODEL_INDEX = 1;
    public static final int SIZE_MODEL_INDEX = 2;
    public static final int SCORE_MODEL_INDEX = 3;
    public static final int HOST_RATING_MODEL_INDEX = 4;
    public static final int HOST_SPEED_MODEL_INDEX = 5;
    public static final int HOST_MODEL_INDEX = 6;
    public static final int HOST_VENDOR_MODEL_INDEX = 7;
    public static final int META_DATA_MODEL_INDEX = 8;
    public static final int SHA1_MODEL_INDEX = 9;
    private static String[] tableColumns = new String[]{Localizer.getString("File"), Localizer.getString("Type"), Localizer.getString("Size"), Localizer.getString("Score"), Localizer.getString("Rating"), Localizer.getString("HostSpeed"), Localizer.getString("SharingHost"), Localizer.getString("Vendor"), Localizer.getString("Information"), Localizer.getString("SHA1")};
    private static Class[] tableClasses = new Class[]{AbstractTreeTableModel.hierarchicalColumnClass, String.class, FileSizeCellRenderer.class, Short.class, Short.class, Integer.class, HostAddressCellRenderer.class, String.class, String.class, String.class};
    private static Object TREE_ROOT = new Object();
    private ISearchDataModel displayedDataModel;
    private int sortedColumn = -1;
    private boolean isAscending;

    public SearchTreeTableModel() {
        super(TREE_ROOT, tableColumns, tableClasses);
    }

    public void setDisplayedSearch(ISearchDataModel dataModel) {
        if (this.displayedDataModel != dataModel) {
            if (this.displayedDataModel != null) {
                this.displayedDataModel.setVisualizationModel(null);
            }
            this.displayedDataModel = dataModel;
            this.fireTreeStructureChanged(TREE_ROOT, new Object[]{TREE_ROOT}, null, null);
            if (this.displayedDataModel != null) {
                this.sortByColumn(this.sortedColumn, this.isAscending);
                this.displayedDataModel.setVisualizationModel(this);
            }
        }
    }

    public ISearchDataModel getDisplayedResultsData() {
        return this.displayedDataModel;
    }

    public Object getValueAt(Object node, int column) {
        switch (column) {
            case 0: {
                RemoteFile remoteFile = this.getRemoteFile(node);
                return remoteFile.getDisplayName();
            }
            case 1: {
                return this.getRemoteFile(node).getFileExt();
            }
            case 2: {
                return this.getRemoteFile(node).getFileSizeObject();
            }
            case 8: {
                return this.getRemoteFile(node).getMetaData();
            }
            case 9: {
                return this.getRemoteFile(node).getSHA1();
            }
            case 3: {
                if (node instanceof SearchResultElement) {
                    return ((SearchResultElement)node).getValue(3);
                }
                return ((RemoteFile)node).getScore();
            }
            case 4: {
                if (node instanceof SearchResultElement) {
                    return ((SearchResultElement)node).getValue(4);
                }
                return ((RemoteFile)node).getQueryHitHost().getHostRatingObject();
            }
            case 5: {
                if (node instanceof SearchResultElement) {
                    return HostSpeedFormatUtils.formatHostSpeed(((Number)((SearchResultElement)node).getValue(5)).longValue());
                }
                return HostSpeedFormatUtils.formatHostSpeed(((RemoteFile)node).getSpeedObject());
            }
            case 6: {
                if (node instanceof SearchResultElement) {
                    return ((SearchResultElement)node).getValue(6);
                }
                return ((RemoteFile)node).getHostAddress();
            }
            case 7: {
                if (node instanceof SearchResultElement) {
                    return ((SearchResultElement)node).getValue(7);
                }
                return ((RemoteFile)node).getQueryHitHost().getVendor();
            }
        }
        return "";
    }

    private RemoteFile getRemoteFile(Object node) {
        if (node instanceof SearchResultElement) {
            return ((SearchResultElement)node).getSingleRemoteFile();
        }
        return (RemoteFile)node;
    }

    public Object getChild(Object parent, int index) {
        Object child = parent == TREE_ROOT ? this.displayedDataModel.getSearchElementAt(index) : ((SearchResultElement)parent).getRemoteFileAt(index);
        return child;
    }

    public int getChildCount(Object parent) {
        int count = parent == TREE_ROOT && this.displayedDataModel != null ? this.displayedDataModel.getSearchElementCount() : (parent instanceof SearchResultElement ? ((SearchResultElement)parent).getRemoteFileListCount() : 0);
        return count;
    }

    public int mapColumnIDToModelIndex(int columnId) {
        switch (columnId) {
            case 1001: {
                return 6;
            }
            case 1002: {
                return 0;
            }
            case 1003: {
                return 1;
            }
            case 1004: {
                return 2;
            }
            case 1005: {
                return 3;
            }
            case 1006: {
                return 4;
            }
            case 1007: {
                return 5;
            }
            case 1008: {
                return 7;
            }
            case 1009: {
                return 8;
            }
            case 1010: {
                return 9;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int columnId) {
        return columnId != 1002;
    }

    public static int[] getColumnIdArray() {
        int[] columnIds = new int[]{1002, 1003, 1004, 1005, 1006, 1007, 1001, 1008, 1009, 1010};
        return columnIds;
    }

    public int getSortByColumn() {
        return this.sortedColumn;
    }

    public boolean isSortedAscending() {
        return this.isAscending;
    }

    public void sortByColumn(int column, boolean isSortedAscending) {
        this.sortedColumn = column;
        this.isAscending = isSortedAscending;
        if (this.displayedDataModel == null) {
            return;
        }
        switch (column) {
            case 2: {
                this.displayedDataModel.setSortBy(1, isSortedAscending);
                break;
            }
            case 0: {
                this.displayedDataModel.setSortBy(2, isSortedAscending);
                break;
            }
            case 1: {
                this.displayedDataModel.setSortBy(3, isSortedAscending);
                break;
            }
            case 9: {
                this.displayedDataModel.setSortBy(4, isSortedAscending);
                break;
            }
            case 6: {
                this.displayedDataModel.setSortBy(5, isSortedAscending);
                break;
            }
            case 3: {
                this.displayedDataModel.setSortBy(10, isSortedAscending);
                break;
            }
            case 4: {
                this.displayedDataModel.setSortBy(9, isSortedAscending);
                break;
            }
            case 5: {
                this.displayedDataModel.setSortBy(8, isSortedAscending);
                break;
            }
            case 7: {
                this.displayedDataModel.setSortBy(7, isSortedAscending);
                break;
            }
            case 8: {
                this.displayedDataModel.setSortBy(6, isSortedAscending);
            }
        }
    }
}

