/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import phex.gui.common.table.FWTable;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;

public class NetworkRowRenderer
implements TableCellRenderer {
    private static final Color FAILED_COLOR = Color.gray;
    private static final Color CONNECTING_COLOR = new Color(127, 0, 0);
    private static final Color CONNECTED_COLOR = new Color(0, 127, 0);
    private NetworkHostsContainer hostsContainer;

    public NetworkRowRenderer() {
        HostManager hostMgr = HostManager.getInstance();
        this.hostsContainer = hostMgr.getNetworkHostsContainer();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRenderer renderer = table.getDefaultRenderer(table.getColumnClass(column));
        Component comp = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        FWTable fwTable = (FWTable)table;
        comp.setForeground(table.getSelectionForeground());
        if (row < this.hostsContainer.getNetworkHostCount()) {
            int modelRow = fwTable.convertRowIndexToModel(row);
            Host host = this.hostsContainer.getNetworkHostAt(modelRow);
            if (host == null) {
                return comp;
            }
            switch (host.getStatus()) {
                case 0: {
                    break;
                }
                case 1: 
                case 5: {
                    comp.setForeground(FAILED_COLOR);
                    break;
                }
                case 2: 
                case 3: {
                    comp.setForeground(CONNECTING_COLOR);
                    break;
                }
                case 4: {
                    comp.setForeground(CONNECTED_COLOR);
                }
            }
        }
        return comp;
    }
}

