/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class ProgressCellRenderer
extends JProgressBar
implements TableCellRenderer {
    protected static Border border = new EmptyBorder(2, 5, 2, 5);

    public ProgressCellRenderer() {
        super(0, 100);
        this.setOpaque(true);
        this.setBorder(border);
        this.setStringPainted(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setBackground(table.getBackground());
        }
        Color back = this.getBackground();
        boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
        this.setOpaque(!colorMatch);
        if (value instanceof Number) {
            Number progress = (Number)value;
            if (progress.intValue() >= 0) {
                this.setValue(progress.intValue());
                this.setString(progress.toString() + " %");
            } else {
                this.setValue(0);
                this.setString("? %");
            }
        } else {
            this.setValue(0);
            this.setString("0 %");
        }
        return this;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "AccessibleValue") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public static class UIResource
    extends ProgressCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

