/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.download.swarming.SwarmingManager;
import phex.gui.common.LabeledIcon;
import phex.gui.tabs.search.SearchResultElement;
import phex.share.ShareManager;
import phex.share.SharedFilesService;

public class SearchTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Color DOWNLOAD_COLOR = new Color(0, 127, 0);
    private static final Color SHARE_COLOR = Color.lightGray;
    private SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
    private SwarmingManager swarmingMgr = SwarmingManager.getInstance();
    private JTree tree;

    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (sel) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        String stringValue = this.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.tree = tree;
        this.hasFocus = hasFocus;
        this.setText(stringValue);
        if (!tree.isEnabled()) {
            this.setEnabled(false);
            if (leaf) {
                this.setDisabledIcon(this.getLeafIcon());
            } else if (expanded) {
                this.setDisabledIcon(this.getOpenIcon());
            } else {
                this.setDisabledIcon(this.getClosedIcon());
            }
        } else {
            this.setEnabled(true);
            if (leaf) {
                this.setIcon(this.getLeafIcon());
            } else if (expanded) {
                this.setIcon(this.getOpenIcon());
            } else {
                LabeledIcon icon = (LabeledIcon)this.getClosedIcon();
                if (value instanceof SearchResultElement) {
                    int count = ((SearchResultElement)value).getRemoteFileListCount();
                    icon.setLabel(String.valueOf(count));
                } else {
                    icon.setLabel(null);
                }
                this.setIcon(icon);
            }
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        this.selected = sel;
        return this;
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        RemoteFile remoteFile = value instanceof SearchResultElement ? ((SearchResultElement)value).getSingleRemoteFile() : (value instanceof RemoteFile ? (RemoteFile)value : null);
        if (remoteFile == null) {
            return "";
        }
        URN urn = remoteFile.getURN();
        boolean isShared = this.sharedFilesService.isURNShared(urn);
        if (isShared) {
            this.setForeground(SHARE_COLOR);
        } else {
            boolean isDownloaded = this.swarmingMgr.isURNDownloaded(urn);
            if (isDownloaded) {
                this.setForeground(DOWNLOAD_COLOR);
            }
        }
        return remoteFile.getDisplayName();
    }
}

