/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.models.StatisticsTableModel;
import phex.gui.tabs.FWTab;
import phex.utils.Localizer;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumnList;

public class StatisticsTab
extends FWTab {
    private static final String STATISTICS_TABLE_IDENTIFIER = "StatisticsTable";
    private StatisticsTableModel statisticsModel;
    private FWTableColumnModel statisticsColumnModel;
    private FWTable statisticsTable;
    private JScrollPane statisticsTableScrollPane;

    public StatisticsTab() {
        super(1006, Localizer.getString("Statistics"), GUIRegistry.getInstance().getIconFactory().getIcon("Statistics"), Localizer.getString("TTTStatistics"), Localizer.getChar("StatisticsMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("StatisticsAccelerator")), 6);
    }

    public void initComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout tabLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:p:grow, 2dlu");
        PanelBuilder tabBuilder = new PanelBuilder(tabLayout, this);
        JPanel contentPanel = new JPanel();
        FWElegantPanel banner = new FWElegantPanel(Localizer.getString("Statistics"), contentPanel);
        tabBuilder.add((Component)banner, cc.xy(2, 2));
        FormLayout contentLayout = new FormLayout("fill:d:grow", "fill:d:grow");
        PanelBuilder contentBuilder = new PanelBuilder(contentLayout, contentPanel);
        this.statisticsModel = new StatisticsTableModel();
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(guiSettings, STATISTICS_TABLE_IDENTIFIER);
        this.buildStatisticsTableColumnModel(dTable);
        this.statisticsTable = new FWTable((TableModel)new FWSortedTableModel(this.statisticsModel), this.statisticsColumnModel);
        this.statisticsTable.activateAllHeaderActions();
        this.statisticsTable.setAutoResizeMode(0);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.statisticsTable);
        this.statisticsTableScrollPane = FWTable.createFWTableScrollPane(this.statisticsTable);
        contentBuilder.add((Component)this.statisticsTableScrollPane, cc.xy(1, 1));
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public void updateUI() {
        super.updateUI();
        if (this.statisticsTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.statisticsTableScrollPane);
        }
    }

    private void buildStatisticsTableColumnModel(DTable tableSettings) {
        int[] columnIds = StatisticsTableModel.getColumnIdArray();
        DTableColumnList columnList = null;
        if (tableSettings != null) {
            columnList = tableSettings.getTableColumnList();
        }
        this.statisticsColumnModel = new FWTableColumnModel(this.statisticsModel, columnIds, columnList);
    }

    public void appendDGuiSettings(DGuiSettings dSettings) {
        super.appendDGuiSettings(dSettings);
        DTableColumnList dList = this.statisticsColumnModel.createDGuiTableColumnList();
        DTable dTable = new DTable();
        dTable.setTableColumnList(dList);
        dTable.setTableIdentifier(STATISTICS_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
    }
}

