/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import phex.chat.ChatManager;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.common.log.LogBuffer;
import phex.event.UploadFilesChangeListener;
import phex.gui.actions.BanHostActionUtils;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.MainFrame;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.dialogs.LogBufferDialog;
import phex.gui.models.UploadFilesTableModel;
import phex.gui.tabs.FWTab;
import phex.upload.UploadManager;
import phex.upload.UploadState;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.URLUtil;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumnList;

public class UploadTab
extends FWTab {
    private static final String UPLOAD_TABLE_IDENTIFIER = "UploadTable";
    private static final UploadState[] EMPTY_UPLOADSTATE_ARRAY = new UploadState[0];
    private UploadManager uploadManager;
    private MainFrame mainFrame;
    private FWTable uploadTable;
    private JScrollPane uploadTableScrollPane;
    private UploadFilesTableModel uploadModel;
    private FWTableColumnModel uploadColumnModel;
    private JPopupMenu uploadPopup;

    public UploadTab(MainFrame frame) {
        super(1004, Localizer.getString("Upload"), GUIRegistry.getInstance().getIconFactory().getIcon("Upload"), Localizer.getString("TTTUpload"), Localizer.getChar("UploadMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("UploadAccelerator")), 3);
        this.mainFrame = frame;
        this.uploadManager = UploadManager.getInstance();
        this.uploadManager.addUploadFilesChangeListener(new UploadStateChangeHandler());
    }

    public void initComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout tabLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:p:grow, 2dlu");
        PanelBuilder tabBuilder = new PanelBuilder(tabLayout, this);
        JPanel contentPanel = new JPanel();
        FWElegantPanel banner = new FWElegantPanel(Localizer.getString("Uploads"), contentPanel);
        tabBuilder.add((Component)banner, cc.xy(2, 2));
        FormLayout contentLayout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder contentBuilder = new PanelBuilder(contentLayout, contentPanel);
        this.uploadModel = new UploadFilesTableModel();
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(guiSettings, UPLOAD_TABLE_IDENTIFIER);
        this.buildUploadTableColumnModel(dTable);
        MouseHandler mouseHandler = new MouseHandler();
        this.uploadTable = new FWTable((TableModel)new FWSortedTableModel(this.uploadModel), this.uploadColumnModel);
        this.uploadTable.activateAllHeaderActions();
        this.uploadTable.setAutoResizeMode(0);
        this.uploadTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.uploadTable.addMouseListener(mouseHandler);
        this.uploadTableScrollPane = FWTable.createFWTableScrollPane(this.uploadTable);
        this.uploadTableScrollPane.addMouseListener(mouseHandler);
        contentBuilder.add((Component)this.uploadTableScrollPane, cc.xy(1, 1));
        GUIUtils.adjustTableProgresssBarHeight(this.uploadTable);
        FWToolBar uploadToolbar = new FWToolBar(0);
        uploadToolbar.setBorderPainted(false);
        uploadToolbar.setFloatable(false);
        contentBuilder.add((Component)uploadToolbar, cc.xy(1, 3));
        this.uploadPopup = new JPopupMenu();
        FWAction action = new AbortUploadAction();
        this.addTabAction(action);
        uploadToolbar.addAction(action);
        this.uploadPopup.add(action);
        action = new RemoveUploadAction();
        this.addTabAction(action);
        uploadToolbar.addAction(action);
        this.uploadPopup.add(action);
        action = new ViewBitziTicketAction();
        this.addTabAction(action);
        this.uploadPopup.add(action);
        uploadToolbar.addSeparator();
        this.uploadPopup.addSeparator();
        action = new AddToFavoritesAction();
        this.addTabAction(action);
        this.uploadPopup.add(action);
        action = new BrowseHostAction();
        this.addTabAction(action);
        uploadToolbar.addAction(action);
        this.uploadPopup.add(action);
        action = new ChatToHostAction();
        this.addTabAction(action);
        uploadToolbar.addAction(action);
        this.uploadPopup.add(action);
        BanHostActionProvider banHostActionProvider = new BanHostActionProvider();
        BanHostActionUtils.BanHostActionMenu bhActionMenu = BanHostActionUtils.createActionMenu(banHostActionProvider);
        this.uploadPopup.add(bhActionMenu.menu);
        this.addTabActions(bhActionMenu.actions);
        action = BanHostActionUtils.createToolBarAction(banHostActionProvider);
        uploadToolbar.addAction(action);
        this.addTabAction(action);
        uploadToolbar.addSeparator();
        this.uploadPopup.addSeparator();
        action = new ClearUploadsAction();
        this.addTabAction(action);
        uploadToolbar.addAction(action);
        this.uploadPopup.add(action);
        if (ServiceManager.sCfg.uploadStateLogBufferSize > 0L) {
            action = new UploadStateLogAction();
            this.addTabAction(action);
            uploadToolbar.addAction(action);
            this.uploadPopup.add(action);
        }
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public void updateUI() {
        super.updateUI();
        if (this.uploadTable != null) {
            GUIUtils.adjustTableProgresssBarHeight(this.uploadTable);
        }
        if (this.uploadTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.uploadTableScrollPane);
        }
    }

    private UploadState[] getSelectedUploadStates() {
        int[] viewRows = this.uploadTable.getSelectedRows();
        if (viewRows.length == 0) {
            return EMPTY_UPLOADSTATE_ARRAY;
        }
        int[] modelRows = this.uploadTable.convertRowIndicesToModel(viewRows);
        UploadState[] states = this.uploadManager.getUploadStatesAt(modelRows);
        return states;
    }

    private UploadState getSelectedUploadState() {
        int viewRow = this.uploadTable.getSelectedRow();
        int modelRow = this.uploadTable.convertRowIndexToModel(viewRow);
        UploadState state = this.uploadManager.getUploadStateAt(modelRow);
        return state;
    }

    private void buildUploadTableColumnModel(DTable tableSettings) {
        int[] columnIds = UploadFilesTableModel.getColumnIdArray();
        DTableColumnList columnList = null;
        if (tableSettings != null) {
            columnList = tableSettings.getTableColumnList();
        }
        this.uploadColumnModel = new FWTableColumnModel(this.uploadModel, columnIds, columnList);
    }

    public void appendDGuiSettings(DGuiSettings dSettings) {
        super.appendDGuiSettings(dSettings);
        DTableColumnList dList = this.uploadColumnModel.createDGuiTableColumnList();
        DTable dTable = new DTable();
        dTable.setTableColumnList(dList);
        dTable.setTableIdentifier(UPLOAD_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        private void popupMenu(Component source, int x, int y) {
            if (source == UploadTab.this.uploadTable || source == UploadTab.this.uploadTableScrollPane) {
                UploadTab.this.uploadPopup.show(source, x, y);
            }
        }
    }

    private class UploadStateChangeHandler
    implements UploadFilesChangeListener {
        private UploadStateChangeHandler() {
        }

        public void uploadFileChanged(int position) {
            UploadTab.this.refreshTabActions();
        }

        public void uploadFileAdded(int position) {
            UploadTab.this.refreshTabActions();
        }

        public void uploadQueueChanged() {
        }

        public void uploadFileRemoved(int position) {
            UploadTab.this.refreshTabActions();
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                UploadTab.this.refreshTabActions();
            }
        }
    }

    private class UploadStateLogAction
    extends FWAction {
        public UploadStateLogAction() {
            super(Localizer.getString("UploadTab_ViewLog"), null, Localizer.getString("UploadTab_TTTViewLog"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UploadState uploadState = UploadTab.this.getSelectedUploadState();
                LogBuffer buffer = UploadManager.getInstance().getUploadStateLogBuffer();
                Collection logRecords = buffer.getLogRecords(uploadState);
                if (logRecords != null) {
                    LogBufferDialog dialog = new LogBufferDialog(logRecords);
                    dialog.setVisible(true);
                }
            }
            catch (Throwable th) {
                NLogger.error("Download", (Object)th, th);
            }
        }

        public void refreshActionState() {
            UploadState uploadState;
            if (UploadTab.this.uploadTable.getSelectedRowCount() == 1 && (uploadState = UploadTab.this.getSelectedUploadState()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    class ClearUploadsAction
    extends FWAction {
        ClearUploadsAction() {
            super(Localizer.getString("ClearCompleted"), GUIRegistry.getInstance().getIconFactory().getIcon("Trash"), Localizer.getString("TTTClearCompleted"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            UploadTab.this.uploadManager.cleanUploadStateList();
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getIconFactory().getIcon("BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            UploadState state = UploadTab.this.getSelectedUploadState();
            if (state == null) {
                return;
            }
            GUIActionPerformer.browseHost(state.getHostAddress());
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getIconFactory().getIcon("Bitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            block3: {
                UploadState state = UploadTab.this.getSelectedUploadState();
                if (state == null) {
                    return;
                }
                String url = URLUtil.buildBitziLookupURL(state.getFileURN());
                try {
                    BrowserLauncher.openURL(url);
                }
                catch (IOException exp) {
                    NLogger.warn("USER_INTERFACE", (Object)exp, (Throwable)exp);
                    Object[] dialogOptions = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int choice = JOptionPane.showOptionDialog(UploadTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, dialogOptions, Localizer.getString("Yes"));
                    if (choice != 0) break block3;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(url), null);
                }
            }
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class AddToFavoritesAction
    extends FWAction {
        public AddToFavoritesAction() {
            super(Localizer.getString("AddToFavorites"), GUIRegistry.getInstance().getIconFactory().getIcon("FavoriteHost"), Localizer.getString("TTTAddToFavorites"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            UploadState[] states = UploadTab.this.getSelectedUploadStates();
            DestAddress[] addresses = new DestAddress[states.length];
            for (int i = 0; i < states.length; ++i) {
                addresses[i] = states[i].getHostAddress();
            }
            GUIActionPerformer.addHostsToFavorites(addresses);
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private final class BanHostActionProvider
    implements BanHostActionUtils.BanHostActionProvider {
        private BanHostActionProvider() {
        }

        public DestAddress[] getBanHostAddresses() {
            UploadState[] states = UploadTab.this.getSelectedUploadStates();
            DestAddress[] addresses = new DestAddress[states.length];
            for (int i = 0; i < states.length; ++i) {
                addresses[i] = states[i].getHostAddress();
            }
            return addresses;
        }

        public boolean isBanHostActionEnabled(boolean allowMultipleAddresses) {
            return UploadTab.this.uploadTable.getSelectedRow() >= 0 && (allowMultipleAddresses || UploadTab.this.uploadTable.getSelectedRowCount() <= 1);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            UploadState state = UploadTab.this.getSelectedUploadState();
            if (state == null) {
                return;
            }
            ChatManager.getInstance().openChat(state.getHostAddress());
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class RemoveUploadAction
    extends FWAction {
        RemoveUploadAction() {
            super(Localizer.getString("RemoveUpload"), GUIRegistry.getInstance().getIconFactory().getIcon("Remove"), Localizer.getString("TTTRemoveUpload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            UploadState[] states = UploadTab.this.getSelectedUploadStates();
            for (int i = 0; i < states.length; ++i) {
                if (states[i] == null) continue;
                UploadTab.this.uploadManager.removeUploadState(states[i]);
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class AbortUploadAction
    extends FWAction {
        AbortUploadAction() {
            super(Localizer.getString("AbortUpload"), GUIRegistry.getInstance().getIconFactory().getIcon("Stop"), Localizer.getString("TTTAbortUpload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            UploadState[] states = UploadTab.this.getSelectedUploadStates();
            for (int i = 0; i < states.length; ++i) {
                if (states[i] == null || !states[i].isUploadRunning()) continue;
                states[i].stopUpload();
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            UploadState[] states = UploadTab.this.getSelectedUploadStates();
            boolean state = false;
            for (int i = 0; i < states.length; ++i) {
                if (states[i] == null || !states[i].isUploadRunning()) continue;
                state = true;
                break;
            }
            this.setEnabled(state);
        }
    }
}

