/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.download;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.lang.SystemUtils;
import phex.common.format.NumberFormatUtils;
import phex.download.swarming.SWDownloadFile;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IconFactory;
import phex.gui.common.MultiScopeProgressBar;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.SystemShellExecute;
import phex.xml.sax.gui.DGuiSettings;

public class DownloadOverviewPanel
extends JPanel {
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
    private SWDownloadFile lastDownloadFile;
    private long lastFinishedScopeLength;
    private Icon defProgressIcon;
    private Icon twinkleProgressIcon;
    private MultiScopeProgressBar progressBar;
    private JLabel progressLabel;
    private Timer resetProgressTwinkleTimer;
    private JLabel progressIconLabel;
    private JLabel downloadedLabel;
    private JLabel remainingLabel;
    private JLabel etaLabel;
    private JLabel createdLabel;
    private JLabel totalSizeLabel;
    private JLabel lastDownloadedLabel;
    private JLabel downloadRateLabel;
    private JLabel maxRateLabel;
    private JLabel downloadingCandidatesLabel;
    private JLabel queuedCandidatesLabel;
    private JLabel connectingCandidatesLabel;
    private JLabel goodCandidatesLabel;
    private JLabel badCandidatesLabel;
    private JLabel totalCandidatesLabel;
    private JTextField fileNameTxt;
    private JTextField incompleteFileTxt;

    public DownloadOverviewPanel() {
        ActionListener updateInterfaceAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DownloadOverviewPanel.this.updateInterface();
                }
                catch (Throwable th) {
                    NLogger.error("USER_INTERFACE", (Object)th, th);
                }
            }
        };
        Timer timer = new Timer(2000, updateInterfaceAction);
        timer.start();
    }

    public void initializeComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("6dlu, fill:d:grow, 6dlu", "6dlu, p, 6dlu, p, 6dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(layout, this);
        JPanel progressPanel = this.buildProgressPanel();
        panelBuilder.add((Component)progressPanel, cc.xy(2, 2));
        JPanel infoPanel = this.buildInfoPanel();
        panelBuilder.add((Component)infoPanel, cc.xy(2, 4));
        JPanel info2Panel = this.buildInfo2Panel();
        panelBuilder.add((Component)info2Panel, cc.xy(2, 6));
    }

    private JPanel buildProgressPanel() {
        JPanel subPanel = new JPanel();
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("d, 2dlu, d, 2dlu, fill:d:grow, 2dlu, right:25dlu", "p");
        PanelBuilder panelBuilder = new PanelBuilder(layout, subPanel);
        IconFactory iconFactory = GUIRegistry.getInstance().getIconFactory();
        this.defProgressIcon = iconFactory.getIcon("PhexWizard");
        this.twinkleProgressIcon = iconFactory.getIcon("PhexWizardTwinkle");
        this.progressIconLabel = new JLabel(Localizer.getString("DownloadOverview_Progress"));
        this.progressIconLabel.setIcon(this.defProgressIcon);
        panelBuilder.add((Component)this.progressIconLabel, cc.xy(3, 1));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DownloadOverviewPanel.this.progressIconLabel.setIcon(DownloadOverviewPanel.this.defProgressIcon);
                }
                catch (Throwable th) {
                    NLogger.error("USER_INTERFACE", (Object)th, th);
                }
            }
        };
        this.resetProgressTwinkleTimer = new Timer(175, actionListener);
        this.resetProgressTwinkleTimer.setRepeats(false);
        this.progressBar = new MultiScopeProgressBar();
        panelBuilder.add((Component)this.progressBar, cc.xy(5, 1));
        this.progressLabel = new JLabel(" 100 %");
        panelBuilder.add((Component)this.progressLabel, cc.xy(7, 1));
        return subPanel;
    }

    private JPanel buildInfoPanel() {
        JPanel subPanel = new JPanel();
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("d, 4dlu, right:d, fill:8dlu:grow, d, 4dlu, right:d, fill:8dlu:grow, d, 4dlu, right:d", "p, 2dlu, p, 2dlu, p, 2dlu, p, 6dlu, p, 2dlu, p, 2dlu, p");
        layout.setColumnGroups(new int[][]{{1, 5, 9}, {3, 7, 11}});
        PanelBuilder panelBuilder = new PanelBuilder(layout, subPanel);
        panelBuilder.addSeparator(Localizer.getString("DownloadOverview_Transfer"), cc.xywh(1, 1, layout.getColumnCount(), 1));
        JLabel label = new JLabel(Localizer.getString("DownloadOverview_Downloaded"));
        panelBuilder.add((Component)label, cc.xy(1, 3));
        this.downloadedLabel = new JLabel();
        panelBuilder.add((Component)this.downloadedLabel, cc.xy(3, 3));
        label = new JLabel(Localizer.getString("DownloadOverview_Remaining"));
        panelBuilder.add((Component)label, cc.xy(5, 3));
        this.remainingLabel = new JLabel();
        panelBuilder.add((Component)this.remainingLabel, cc.xy(7, 3));
        label = new JLabel(Localizer.getString("DownloadOverview_DownloadRate"));
        panelBuilder.add((Component)label, cc.xy(9, 3));
        this.downloadRateLabel = new JLabel();
        panelBuilder.add((Component)this.downloadRateLabel, cc.xy(11, 3));
        label = new JLabel(Localizer.getString("DownloadOverview_FileSize"));
        panelBuilder.add((Component)label, cc.xy(1, 5));
        this.totalSizeLabel = new JLabel();
        panelBuilder.add((Component)this.totalSizeLabel, cc.xy(3, 5));
        label = new JLabel(Localizer.getString("DownloadOverview_EstimatedTime"));
        panelBuilder.add((Component)label, cc.xy(5, 5));
        this.etaLabel = new JLabel();
        panelBuilder.add((Component)this.etaLabel, cc.xy(7, 5));
        label = new JLabel(Localizer.getString("DownloadOverview_MaximalRate"));
        panelBuilder.add((Component)label, cc.xy(9, 5));
        this.maxRateLabel = new JLabel();
        panelBuilder.add((Component)this.maxRateLabel, cc.xy(11, 5));
        label = new JLabel(Localizer.getString("DownloadOverview_LastDownloaded"));
        panelBuilder.add((Component)label, cc.xy(1, 7));
        this.lastDownloadedLabel = new JLabel();
        panelBuilder.add((Component)this.lastDownloadedLabel, cc.xy(3, 7));
        label = new JLabel(Localizer.getString("DownloadOverview_Created"));
        panelBuilder.add((Component)label, cc.xy(9, 7));
        this.createdLabel = new JLabel();
        panelBuilder.add((Component)this.createdLabel, cc.xy(11, 7));
        panelBuilder.addSeparator(Localizer.getString("DownloadOverview_Candidates"), cc.xywh(1, 9, 11, 1));
        label = new JLabel(Localizer.getString("DownloadOverview_DownloadingCandidates"));
        panelBuilder.add((Component)label, cc.xy(1, 11));
        this.downloadingCandidatesLabel = new JLabel();
        panelBuilder.add((Component)this.downloadingCandidatesLabel, cc.xy(3, 11));
        label = new JLabel(Localizer.getString("DownloadOverview_QueuedCandidates"));
        panelBuilder.add((Component)label, cc.xy(5, 11));
        this.queuedCandidatesLabel = new JLabel();
        panelBuilder.add((Component)this.queuedCandidatesLabel, cc.xy(7, 11));
        label = new JLabel(Localizer.getString("DownloadOverview_ConnectingCandidates"));
        panelBuilder.add((Component)label, cc.xy(9, 11));
        this.connectingCandidatesLabel = new JLabel();
        panelBuilder.add((Component)this.connectingCandidatesLabel, cc.xy(11, 11));
        label = new JLabel(Localizer.getString("DownloadOverview_GoodCandidates"));
        panelBuilder.add((Component)label, cc.xy(1, 13));
        this.goodCandidatesLabel = new JLabel();
        panelBuilder.add((Component)this.goodCandidatesLabel, cc.xy(3, 13));
        label = new JLabel(Localizer.getString("DownloadOverview_BadCandidates"));
        panelBuilder.add((Component)label, cc.xy(5, 13));
        this.badCandidatesLabel = new JLabel();
        panelBuilder.add((Component)this.badCandidatesLabel, cc.xy(7, 13));
        label = new JLabel(Localizer.getString("DownloadOverview_TotalCandidates"));
        panelBuilder.add((Component)label, cc.xy(9, 13));
        this.totalCandidatesLabel = new JLabel();
        panelBuilder.add((Component)this.totalCandidatesLabel, cc.xy(11, 13));
        return subPanel;
    }

    private JPanel buildInfo2Panel() {
        JPanel subPanel = new JPanel();
        CellConstraints cc = new CellConstraints();
        String systemExtraCols = "";
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC_OSX) {
            systemExtraCols = ", 4dlu, d";
        }
        FormLayout layout = new FormLayout("d, 4dlu, 1dlu:grow" + systemExtraCols, "p, 2dlu, p, 2dlu, p, 2dlu, p, 2dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(layout, subPanel);
        panelBuilder.addSeparator(Localizer.getString("DownloadOverview_Information"), cc.xywh(1, 1, layout.getColumnCount(), 1));
        JLabel label = new JLabel(Localizer.getString("DownloadOverview_FileName"));
        panelBuilder.add((Component)label, cc.xy(1, 3));
        this.fileNameTxt = new JTextField();
        this.fileNameTxt.setEditable(false);
        this.fileNameTxt.setFont(UIManager.getFont("Label.font"));
        this.fileNameTxt.setForeground(UIManager.getColor("Label.foreground"));
        this.fileNameTxt.setBackground(UIManager.getColor("Label.background"));
        this.fileNameTxt.setMinimumSize(new Dimension(0, 0));
        panelBuilder.add((Component)this.fileNameTxt, cc.xy(3, 3));
        label = new JLabel(Localizer.getString("DownloadOverview_IncompleteFile"));
        panelBuilder.add((Component)label, cc.xy(1, 5));
        this.incompleteFileTxt = new JTextField();
        this.incompleteFileTxt.setEditable(false);
        this.incompleteFileTxt.setFont(UIManager.getFont("Label.font"));
        this.incompleteFileTxt.setForeground(UIManager.getColor("Label.foreground"));
        this.incompleteFileTxt.setBackground(UIManager.getColor("Label.background"));
        panelBuilder.add((Component)this.incompleteFileTxt, cc.xy(3, 5));
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC_OSX) {
            JButton exploreFileBtn = new JButton(GUIRegistry.getInstance().getIconFactory().getIcon("Explore"));
            exploreFileBtn.setToolTipText(Localizer.getString("DownloadOverview_Explore"));
            exploreFileBtn.setMargin(GUIUtils.EMPTY_INSETS);
            exploreFileBtn.addActionListener(new ExploreActionListener());
            panelBuilder.add((Component)exploreFileBtn, cc.xy(5, 5));
        }
        return subPanel;
    }

    public void updateDownloadFileInfo(SWDownloadFile file) {
        this.lastDownloadFile = file;
        this.lastFinishedScopeLength = this.lastDownloadFile != null ? this.lastDownloadFile.getFinishedScopeList().getAggregatedLength() : -1L;
        this.updateInterface();
    }

    private void updateInterface() {
        long curFinishedScopeLength;
        if (this.lastDownloadFile == null) {
            this.progressBar.setDownloadFile(null);
            this.progressLabel.setText("");
            this.downloadedLabel.setText("");
            this.downloadedLabel.setToolTipText("");
            this.remainingLabel.setText("");
            this.remainingLabel.setToolTipText("");
            this.totalSizeLabel.setText("");
            this.totalSizeLabel.setToolTipText("");
            this.createdLabel.setText("");
            this.lastDownloadedLabel.setText("");
            this.downloadRateLabel.setText("");
            this.downloadRateLabel.setToolTipText("");
            this.maxRateLabel.setText("");
            this.downloadingCandidatesLabel.setText("");
            this.queuedCandidatesLabel.setText("");
            this.connectingCandidatesLabel.setText("");
            this.goodCandidatesLabel.setText("");
            this.badCandidatesLabel.setText("");
            this.totalCandidatesLabel.setText("");
            this.fileNameTxt.setText("");
            this.incompleteFileTxt.setText("");
            return;
        }
        this.progressBar.setDownloadFile(this.lastDownloadFile);
        this.progressLabel.setText(this.lastDownloadFile.getProgress().toString() + " %");
        this.downloadedLabel.setText(NumberFormatUtils.formatSignificantByteSize(this.lastDownloadFile.getTransferredDataSize()));
        this.downloadedLabel.setToolTipText(NumberFormatUtils.formatFullByteSize(this.lastDownloadFile.getTransferredDataSize()));
        long remaining = this.lastDownloadFile.getTotalDataSize() - this.lastDownloadFile.getTransferredDataSize();
        this.remainingLabel.setText(NumberFormatUtils.formatSignificantByteSize(remaining));
        this.remainingLabel.setToolTipText(NumberFormatUtils.formatFullByteSize(remaining));
        this.totalSizeLabel.setText(NumberFormatUtils.formatSignificantByteSize(this.lastDownloadFile.getTotalDataSize()));
        this.totalSizeLabel.setToolTipText(NumberFormatUtils.formatFullByteSize(this.lastDownloadFile.getTotalDataSize()));
        this.createdLabel.setText(this.dateFormat.format(this.lastDownloadFile.getCreatedDate()));
        this.lastDownloadedLabel.setText(this.dateFormat.format(this.lastDownloadFile.getDownloadedDate()));
        this.downloadRateLabel.setText(NumberFormatUtils.formatSignificantByteSize(this.lastDownloadFile.getTransferSpeed()) + Localizer.getString("PerSec"));
        this.downloadRateLabel.setToolTipText(NumberFormatUtils.formatFullByteSize(this.lastDownloadFile.getTransferSpeed()) + Localizer.getString("PerSec"));
        long maxRate = this.lastDownloadFile.getDownloadThrottlingRate();
        String maxRateStr = maxRate >= Integer.MAX_VALUE ? Localizer.getDecimalFormatSymbols().getInfinity() : NumberFormatUtils.formatSignificantByteSize(maxRate) + Localizer.getString("PerSec");
        this.maxRateLabel.setText(maxRateStr);
        this.downloadingCandidatesLabel.setText(String.valueOf(this.lastDownloadFile.getDownloadingCandidatesCount()));
        this.queuedCandidatesLabel.setText(String.valueOf(this.lastDownloadFile.getQueuedCandidatesCount()));
        this.connectingCandidatesLabel.setText(String.valueOf(this.lastDownloadFile.getConnectingCandidatesCount()));
        this.goodCandidatesLabel.setText(String.valueOf(this.lastDownloadFile.getGoodCandidateCount()));
        this.badCandidatesLabel.setText(String.valueOf(this.lastDownloadFile.getBadCandidateCount()));
        this.totalCandidatesLabel.setText(String.valueOf(this.lastDownloadFile.getCandidatesCount()));
        String destFile = this.lastDownloadFile.getDestinationFileName();
        if (!this.fileNameTxt.getText().equals(destFile)) {
            this.fileNameTxt.setText(destFile);
            this.fileNameTxt.setCaretPosition(0);
        }
        String path = this.lastDownloadFile.getIncompleteFile().getAbsolutePath();
        if (!this.incompleteFileTxt.getText().equals(path)) {
            this.incompleteFileTxt.setText(path);
            this.incompleteFileTxt.setCaretPosition(0);
        }
        if (this.lastFinishedScopeLength != (curFinishedScopeLength = this.lastDownloadFile.getFinishedScopeList().getAggregatedLength())) {
            this.lastFinishedScopeLength = curFinishedScopeLength;
            this.progressIconLabel.setIcon(this.twinkleProgressIcon);
            this.resetProgressTwinkleTimer.restart();
        }
    }

    public class ExploreActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (DownloadOverviewPanel.this.lastDownloadFile == null) {
                return;
            }
            File file = DownloadOverviewPanel.this.lastDownloadFile.getIncompleteFile();
            if (file == null) {
                return;
            }
            File dir = file.getParentFile();
            try {
                SystemShellExecute.exploreFolder(dir);
            }
            catch (IOException exp) {
                // empty catch block
            }
        }
    }
}

