/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import phex.event.ShareChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.tabs.library.LibraryNode;
import phex.share.ShareManager;
import phex.share.SharedDirectory;
import phex.share.SharedFilesService;
import phex.utils.DirectoryOnlyFileFilter;
import phex.utils.Localizer;

public class SharingTreeModel
implements TreeModel {
    private SharedFilesService fileService = ShareManager.getInstance().getSharedFilesService();
    private FileFilter dirFilter = new DirectoryOnlyFileFilter();
    protected EventListenerList listenerList = new EventListenerList();
    private RootTreeNode root = new RootTreeNode();
    private Object[] rootChilds;
    private FileSystemView fsv = FileSystemView.getFileSystemView();

    public SharingTreeModel() {
        this.updateFileSystem();
        FileSystemChangeListener listener = new FileSystemChangeListener();
        ShareManager.getInstance().getSharedFilesService().addSharedFilesChangeListener(listener);
    }

    public void updateFileSystem() {
        this.root.updateChilds();
        this.fireTreeStructureChanged();
    }

    public Object getRoot() {
        return this.root;
    }

    public int getChildCount(Object node) {
        return ((TreeNode)node).getChildCount();
    }

    public Object getChild(Object node, int index) {
        return ((TreeNode)node).getChildAt(index);
    }

    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    private void fireTreeStructureChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? SharingTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, new TreePath(new Object[]{this.root, this.root.childs[0]}));
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    private class SharedDirectoryTreeNode
    implements TreeNode,
    LibraryNode {
        private SharedDirectory sharedDirectory;
        private TreeNode[] childs;
        private TreeNode parent;

        public SharedDirectoryTreeNode(SharedDirectory dir, TreeNode parent) {
            this.sharedDirectory = dir;
            this.parent = parent;
        }

        public String getDisplayName() {
            return SharingTreeModel.this.fsv.getSystemDisplayName(this.sharedDirectory.getSystemFile());
        }

        public String getTooltipText() {
            return this.sharedDirectory.getSystemFile().getAbsolutePath();
        }

        public Icon getDisplayIcon() {
            return SharingTreeModel.this.fsv.getSystemIcon(this.sharedDirectory.getSystemFile());
        }

        public File getSystemFile() {
            return this.sharedDirectory.getSystemFile();
        }

        public TreeNode getChildAt(int childIndex) {
            this.initChilds();
            return this.childs[childIndex];
        }

        public int getChildCount() {
            this.initChilds();
            return this.childs.length;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public boolean isLeaf() {
            this.initChilds();
            return this.childs.length == 0;
        }

        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.childs.length; ++i) {
                if (this.childs[i] != node) continue;
                return i;
            }
            return -1;
        }

        public boolean getAllowsChildren() {
            throw new UnsupportedOperationException();
        }

        public Enumeration children() {
            throw new UnsupportedOperationException();
        }

        private void initChilds() {
            if (this.childs != null) {
                return;
            }
            ArrayList<SharedDirectoryTreeNode> childsList = new ArrayList<SharedDirectoryTreeNode>();
            File dir = this.sharedDirectory.getSystemFile();
            File[] childDirs = dir.listFiles(SharingTreeModel.this.dirFilter);
            for (int i = 0; i < childDirs.length; ++i) {
                SharedDirectory sharedDir = SharingTreeModel.this.fileService.getSharedDirectory(childDirs[i]);
                if (sharedDir == null || sharedDir.getType() != 1) continue;
                childsList.add(new SharedDirectoryTreeNode(sharedDir, this));
            }
            this.childs = childsList.toArray(new TreeNode[childsList.size()]);
        }
    }

    private class SharedFilesTreeNode
    implements TreeNode,
    LibraryNode {
        private TreeNode[] childs;

        public SharedFilesTreeNode() {
            this.updateChilds();
        }

        public String getDisplayName() {
            return Localizer.getString("LibraryTab_SharedFiles");
        }

        public String getTooltipText() {
            return Localizer.getString("LibraryTab_SharedFiles");
        }

        public Icon getDisplayIcon() {
            return GUIRegistry.getInstance().getIconFactory().getIcon("ShareFolder");
        }

        public File getSystemFile() {
            return null;
        }

        public void updateChilds() {
            ArrayList<SharedDirectoryTreeNode> childsList = new ArrayList<SharedDirectoryTreeNode>();
            SharedDirectory[] sharedDirs = SharingTreeModel.this.fileService.getSharedDirectories();
            for (int i = 0; i < sharedDirs.length; ++i) {
                if (sharedDirs[i].getType() == 2) continue;
                File parent = sharedDirs[i].getSystemFile().getParentFile();
                SharedDirectory sharedDirectory = null;
                if (parent != null) {
                    sharedDirectory = SharingTreeModel.this.fileService.getSharedDirectory(parent);
                }
                if (parent != null && sharedDirectory != null && sharedDirectory.getType() != 2) continue;
                childsList.add(new SharedDirectoryTreeNode(sharedDirs[i], this));
            }
            this.childs = childsList.toArray(new TreeNode[childsList.size()]);
        }

        public TreeNode getChildAt(int childIndex) {
            return this.childs[childIndex];
        }

        public int getChildCount() {
            return this.childs.length;
        }

        public TreeNode getParent() {
            return SharingTreeModel.this.root;
        }

        public boolean isLeaf() {
            return false;
        }

        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.childs.length; ++i) {
                if (this.childs[i] != node) continue;
                return i;
            }
            return -1;
        }

        public boolean getAllowsChildren() {
            throw new UnsupportedOperationException();
        }

        public Enumeration children() {
            throw new UnsupportedOperationException();
        }
    }

    private class RootTreeNode
    implements TreeNode {
        private TreeNode[] childs;

        public RootTreeNode() {
            this.childs = new TreeNode[]{new SharedFilesTreeNode()};
            this.updateChilds();
        }

        public void updateChilds() {
            ((SharedFilesTreeNode)this.childs[0]).updateChilds();
        }

        public TreeNode getChildAt(int childIndex) {
            return this.childs[childIndex];
        }

        public int getChildCount() {
            return this.childs.length;
        }

        public TreeNode getParent() {
            return null;
        }

        public boolean isLeaf() {
            return false;
        }

        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.childs.length; ++i) {
                if (this.childs[i] != node) continue;
                return i;
            }
            return -1;
        }

        public boolean getAllowsChildren() {
            throw new UnsupportedOperationException();
        }

        public Enumeration children() {
            throw new UnsupportedOperationException();
        }
    }

    public class FileSystemChangeListener
    implements ShareChangeListener {
        public void sharedDirectoriesChanged() {
            SharingTreeModel.this.updateFileSystem();
        }
    }
}

