/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.network;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import phex.common.address.DestAddress;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconFactory;
import phex.host.FavoriteHost;

public class FavoritesListRenderer
extends DefaultListCellRenderer {
    private IconFactory iconFactory = GUIRegistry.getInstance().getIconFactory();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof FavoriteHost) {
            FavoriteHost host = (FavoriteHost)value;
            DestAddress hostAddress = host.getHostAddress();
            this.setText(hostAddress.getFullHostName());
            String countryCode = hostAddress.getCountryCode();
            Icon icon = null;
            if (countryCode != null && countryCode.length() > 0) {
                icon = this.iconFactory.getIcon("Flag_" + countryCode);
            }
            this.setIcon(icon);
        }
        return this;
    }
}

