/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.network;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.Keymap;
import phex.chat.ChatManager;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.connection.NetworkManager;
import phex.event.NetworkListener;
import phex.gui.actions.BanHostActionUtils;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWPopupMenu;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IconFactory;
import phex.gui.common.MainFrame;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.models.NetworkTableModel;
import phex.gui.renderer.NetworkRowRenderer;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.network.NetFavoritesPanel;
import phex.gwebcache.GWebCacheContainer;
import phex.gwebcache.GWebCacheManager;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.MsgManager;
import phex.net.presentation.PresentationManager;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumnList;

public class NetworkTab
extends FWTab {
    private static final String NETWORK_TABLE_IDENTIFIER = "NetworkTable";
    private static final Host[] EMPTY_HOST_ARRAY = new Host[0];
    private MainFrame mainFrame;
    private HostManager hostMgr;
    private NetworkHostsContainer hostsContainer;
    private GWebCacheContainer gWebCacheCont;
    private MsgManager msgManager;
    private FWTable networkTable;
    private JScrollPane networkTableScrollPane;
    private FWTableColumnModel networkColumnModel;
    private NetworkTableModel networkModel;
    private FWPopupMenu networkPopup;
    private JLabel myIPLabel;
    private DefaultComboBoxModel connectToComboModel;
    private JComboBox connectToComboBox;
    private JLabel catcherStatLabel;
    private JLabel gWebCacheStatLabel;
    private static final String DISCONNECT_HOST_ACTION_KEY = "DisconnectHostAction";
    private static final String CHAT_TO_HOST_ACTION_KEY = "ChatToHostAction";
    private static final String BROWSE_HOST_ACTION_KEY = "BrowseHostAction";
    private static final String ADD_TO_FAVORITES_ACTION_KEY = "AddToFavoritesAction";

    public NetworkTab(MainFrame frame) {
        super(1000, Localizer.getString("GnutellaNet"), GUIRegistry.getInstance().getIconFactory().getIcon("Network"), Localizer.getString("TTTGnutellaNet"), Localizer.getChar("GnutellaNetMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("GnutellaNetAccelerator")), 0);
        this.mainFrame = frame;
        this.hostMgr = HostManager.getInstance();
        this.hostsContainer = this.hostMgr.getNetworkHostsContainer();
        this.gWebCacheCont = GWebCacheManager.getInstance().getGWebCacheContainer();
        this.msgManager = MsgManager.getInstance();
    }

    public void initComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:d:grow, 4dlu, d, 2dlu");
        PanelBuilder contentBuilder = new PanelBuilder(layout, this);
        JPanel upperPanel = new JPanel();
        FWElegantPanel upperElegantPanel = new FWElegantPanel(Localizer.getString("Connections"), upperPanel);
        layout = new FormLayout("0dlu, d, 2dlu, d, 10dlu:grow, d, 2dlu, d, 2dlu, d, 0dlu", "fill:d:grow, 3dlu, p");
        PanelBuilder upperBuilder = new PanelBuilder(layout, upperPanel);
        this.networkModel = new NetworkTableModel();
        DTable xmlTable = GUIUtils.getDGuiTableByIdentifier(guiSettings, NETWORK_TABLE_IDENTIFIER);
        this.buildNetworkTableColumnModel(xmlTable);
        this.networkTable = new FWTable((TableModel)new FWSortedTableModel(this.networkModel), this.networkColumnModel);
        this.networkTable.activateAllHeaderActions();
        this.networkTable.setAutoResizeMode(0);
        this.networkTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        MouseHandler mouseHandler = new MouseHandler();
        this.networkTable.addMouseListener(mouseHandler);
        this.networkTableScrollPane = FWTable.createFWTableScrollPane(this.networkTable);
        this.networkTableScrollPane.addMouseListener(mouseHandler);
        upperBuilder.add((Component)this.networkTableScrollPane, cc.xywh(2, 1, 9, 1));
        JLabel label = new JLabel(Localizer.getString("NetworkTab_MyAddress"));
        upperBuilder.add((Component)label, cc.xy(2, 3));
        this.myIPLabel = new JLabel("");
        this.myIPLabel.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
                }
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
                }
            }

            private void popupMenu(Component source, int x, int y) {
                JPopupMenu menu = new JPopupMenu();
                menu.add(new CopyMyIpAction());
                menu.show(source, x, y);
            }
        });
        upperBuilder.add((Component)this.myIPLabel, cc.xy(4, 3));
        label = new JLabel(Localizer.getString("ConnectTo") + Localizer.getChar("ColonSign"));
        upperBuilder.add((Component)label, cc.xy(6, 3));
        ConnectToHostHandler connectToHostHandler = new ConnectToHostHandler();
        this.connectToComboModel = new DefaultComboBoxModel<Object>(ServiceManager.sCfg.connectToHistory.toArray());
        this.connectToComboBox = new JComboBox(this.connectToComboModel);
        this.connectToComboBox.setEditable(true);
        JTextField editor = (JTextField)this.connectToComboBox.getEditor().getEditorComponent();
        Keymap keymap = JTextField.addKeymap("ConnectToEditor", editor.getKeymap());
        editor.setKeymap(keymap);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), connectToHostHandler);
        GUIUtils.assignKeymapToComboBoxEditor(keymap, this.connectToComboBox);
        this.connectToComboBox.setSelectedItem("");
        this.connectToComboBox.setPrototypeDisplayValue("123.123.123.123:12345");
        upperBuilder.add((Component)this.connectToComboBox, cc.xy(8, 3));
        JButton connectHostButton = new JButton(Localizer.getString("Connect"));
        connectHostButton.addActionListener(connectToHostHandler);
        upperBuilder.add((Component)connectHostButton, cc.xy(10, 3));
        JPanel lowerPanel = new JPanel();
        layout = new FormLayout("d, fill:10dlu:grow, d", "top:p");
        layout.setColumnGroups(new int[][]{{1, 3}});
        PanelBuilder lowerBuilder = new PanelBuilder(layout, lowerPanel);
        NetFavoritesPanel favoritesPanel = new NetFavoritesPanel();
        lowerBuilder.add((Component)favoritesPanel, cc.xy(1, 1));
        JPanel cacheStatusPanel = new JPanel();
        layout = new FormLayout("8dlu, right:d, 2dlu, right:d, 2dlu, d, 2dlu:grow, 8dlu", "p, 3dlu, p, 3dlu, p, 3dlu, bottom:p:grow");
        PanelBuilder cacheStatusBuilder = new PanelBuilder(layout, cacheStatusPanel);
        lowerBuilder.add((Component)cacheStatusPanel, cc.xy(3, 1));
        cacheStatusBuilder.addSeparator(Localizer.getString("NetworkTab_ConnectionInfo"), cc.xywh(1, 1, 8, 1));
        cacheStatusBuilder.addLabel(Localizer.getString("NetworkTab_HostCacheContains"), cc.xy(2, 3));
        this.catcherStatLabel = new JLabel();
        cacheStatusBuilder.add((Component)this.catcherStatLabel, cc.xy(4, 3));
        cacheStatusBuilder.addLabel(Localizer.getString("NetworkTab_Hosts"), cc.xy(6, 3));
        cacheStatusBuilder.addLabel(Localizer.getString("NetworkTab_GWebCacheContains"), cc.xy(2, 5));
        this.gWebCacheStatLabel = new JLabel();
        cacheStatusBuilder.add((Component)this.gWebCacheStatLabel, cc.xy(4, 5));
        cacheStatusBuilder.addLabel(Localizer.getString("NetworkTab_Caches"), cc.xy(6, 5));
        final JButton queryWebCache = new JButton(Localizer.getString("QueryGWebCache"));
        queryWebCache.setToolTipText(Localizer.getString("TTTQueryGWebCache"));
        queryWebCache.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                queryWebCache.setEnabled(false);
                Runnable runner = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            NetworkTab.this.gWebCacheCont.queryMoreHosts(false);
                            NetworkTab.this.gWebCacheCont.queryMoreGWebCaches(false);
                        }
                        catch (Throwable th) {
                            NLogger.error("GLOBAL", (Object)th, th);
                        }
                        finally {
                            queryWebCache.setEnabled(true);
                        }
                    }
                };
                ThreadPool.getInstance().addJob(runner, "UserGWebCacheQuery-" + Integer.toHexString(runner.hashCode()));
            }
        });
        cacheStatusBuilder.add((Component)queryWebCache, cc.xywh(2, 7, 5, 1));
        contentBuilder.add((Component)upperElegantPanel, cc.xy(2, 2));
        contentBuilder.add((Component)lowerPanel, cc.xy(2, 4));
        NetworkRowRenderer networkRowRenderer = new NetworkRowRenderer();
        Enumeration<TableColumn> enumr = this.networkColumnModel.getColumns();
        while (enumr.hasMoreElements()) {
            TableColumn column = enumr.nextElement();
            column.setCellRenderer(networkRowRenderer);
        }
        this.networkPopup = new FWPopupMenu();
        FWAction action = new DisconnectHostAction();
        this.addTabAction(DISCONNECT_HOST_ACTION_KEY, action);
        this.networkTable.getActionMap().put(DISCONNECT_HOST_ACTION_KEY, action);
        this.networkTable.getInputMap(1).put((KeyStroke)action.getValue("AcceleratorKey"), DISCONNECT_HOST_ACTION_KEY);
        this.networkPopup.addAction(action);
        this.networkPopup.addSeparator();
        action = new AddToFavoritesAction();
        this.addTabAction(ADD_TO_FAVORITES_ACTION_KEY, action);
        this.networkPopup.addAction(action);
        action = new BrowseHostAction();
        this.addTabAction(BROWSE_HOST_ACTION_KEY, action);
        this.networkPopup.addAction(action);
        action = new ChatToHostAction();
        this.addTabAction(CHAT_TO_HOST_ACTION_KEY, action);
        this.networkPopup.addAction(action);
        BanHostActionProvider banHostActionProvider = new BanHostActionProvider();
        BanHostActionUtils.BanHostActionMenu bhActionMenu = BanHostActionUtils.createActionMenu(banHostActionProvider);
        this.networkPopup.add(bhActionMenu.menu);
        this.addTabActions(bhActionMenu.actions);
        this.networkPopup.addSeparator();
        JMenu netMenu = new JMenu(Localizer.getString("Network"));
        netMenu.add(GUIRegistry.getInstance().getGlobalAction("ConnectNetworkAction"));
        netMenu.add(GUIRegistry.getInstance().getGlobalAction("DisconnectNetworkAction"));
        this.networkPopup.add(netMenu);
        NetworkManager networkMgr = NetworkManager.getInstance();
        IPChangedListener ipListener = new IPChangedListener();
        ipListener.networkIPChanged(networkMgr.getLocalAddress());
        networkMgr.addNetworkListener(ipListener);
    }

    public void updateUI() {
        super.updateUI();
        if (this.connectToComboBox != null) {
            GUIUtils.adjustComboBoxHeight(this.connectToComboBox);
            ListCellRenderer renderer = this.connectToComboBox.getRenderer();
            if (renderer != null) {
                FontMetrics fm = this.connectToComboBox.getFontMetrics(this.connectToComboBox.getFont());
                int width = fm.getMaxAdvance() * 15;
                Dimension dim = this.connectToComboBox.getMaximumSize();
                dim.width = Math.min(width, dim.width);
                dim = this.connectToComboBox.getPreferredSize();
                dim.width = Math.min(width, dim.width);
            }
        }
        if (this.networkTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.networkTableScrollPane);
        }
    }

    public void appendDGuiSettings(DGuiSettings dSettings) {
        super.appendDGuiSettings(dSettings);
        DTableColumnList dList = this.networkColumnModel.createDGuiTableColumnList();
        DTable dTable = new DTable();
        dTable.setTableColumnList(dList);
        dTable.setTableIdentifier(NETWORK_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
    }

    public void tabSelectedNotify() {
        this.refresh();
    }

    public void refresh() {
        this.catcherStatLabel.setText(String.valueOf(this.hostMgr.getCaughtHostsContainer().getCaughtHostsCount()));
        this.gWebCacheStatLabel.setText(String.valueOf(this.gWebCacheCont.getGWebCacheCount()));
        this.networkModel.fireTableDataChanged();
    }

    private void buildNetworkTableColumnModel(DTable tableSettings) {
        int[] columnIds = NetworkTableModel.getColumnIdArray();
        DTableColumnList columnList = null;
        if (tableSettings != null) {
            columnList = tableSettings.getTableColumnList();
        }
        this.networkColumnModel = new FWTableColumnModel(this.networkModel, columnIds, columnList);
    }

    private Host[] getSelectedHosts() {
        int[] viewRows = this.networkTable.getSelectedRows();
        if (viewRows.length == 0) {
            return EMPTY_HOST_ARRAY;
        }
        int[] modelRows = this.networkTable.convertRowIndicesToModel(viewRows);
        Host[] hosts = this.hostsContainer.getNetworkHostsAt(modelRows);
        return hosts;
    }

    private Host getSelectedHost() {
        int viewRow = this.networkTable.getSelectedRow();
        int modelRow = this.networkTable.convertRowIndexToModel(viewRow);
        if (modelRow < 0) {
            return null;
        }
        Host hosts = this.hostsContainer.getNetworkHostAt(modelRow);
        return hosts;
    }

    class CopyMyIpAction
    extends FWAction {
        CopyMyIpAction() {
            super(Localizer.getString("Copy"), (Icon)IconFactory.EMPTY_IMAGE_16, Localizer.getString("TTTCopyMyIP"));
        }

        public void actionPerformed(ActionEvent e) {
            DestAddress address = NetworkManager.getInstance().getLocalAddress();
            StringSelection data = new StringSelection(address.getFullHostName());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(data, data);
        }

        public void refreshActionState() {
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        private void popupMenu(Component source, int x, int y) {
            if (source == NetworkTab.this.networkTable || source == NetworkTab.this.networkTableScrollPane) {
                NetworkTab.this.networkPopup.show(source, x, y);
            }
        }
    }

    private class ConnectToHostHandler
    extends AbstractAction
    implements ActionListener {
        private ConnectToHostHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            String str = (String)NetworkTab.this.connectToComboBox.getEditor().getItem();
            NetworkTab.this.connectToComboModel.setSelectedItem(str);
            str = str.trim();
            if (str.length() == 0) {
                return;
            }
            int idx = NetworkTab.this.connectToComboModel.getIndexOf(str);
            if (idx < 0) {
                NetworkTab.this.connectToComboModel.insertElementAt(str, 0);
                if (NetworkTab.this.connectToComboModel.getSize() > ServiceManager.sCfg.maxConnectToHistorySize) {
                    NetworkTab.this.connectToComboModel.removeElementAt(NetworkTab.this.connectToComboModel.getSize() - 1);
                }
                this.saveConnectToHostList();
            } else if (idx > 0) {
                NetworkTab.this.connectToComboModel.removeElementAt(idx);
                NetworkTab.this.connectToComboModel.insertElementAt(str, 0);
                this.saveConnectToHostList();
            }
            this.connectToHost(str);
            NetworkTab.this.connectToComboBox.setSelectedItem("");
        }

        private void connectToHost(String hostAddr) {
            if (hostAddr.length() == 0) {
                return;
            }
            StringTokenizer tokens = new StringTokenizer(hostAddr, ";");
            String firstHost = tokens.nextToken();
            try {
                DestAddress address = PresentationManager.getInstance().createHostAddress(firstHost, 6346);
                NetworkTab.this.hostMgr.getNetworkHostsContainer().createOutgoingConnectionToHost(address);
            }
            catch (MalformedDestAddressException exp) {
                // empty catch block
            }
            NetworkTab.this.networkModel.fireTableDataChanged();
            while (tokens.hasMoreTokens()) {
                String hostString = tokens.nextToken();
                try {
                    DestAddress address = PresentationManager.getInstance().createHostAddress(hostString, 6346);
                    NetworkTab.this.hostMgr.getCaughtHostsContainer().addCaughtHost(address, (short)2);
                }
                catch (MalformedDestAddressException exp) {}
            }
        }

        private void saveConnectToHostList() {
            int length = NetworkTab.this.connectToComboModel.getSize();
            ArrayList ipList = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                ipList.add(NetworkTab.this.connectToComboModel.getElementAt(i));
            }
            ServiceManager.sCfg.connectToHistory.clear();
            ServiceManager.sCfg.connectToHistory.addAll(ipList);
            ServiceManager.sCfg.save();
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                NetworkTab.this.refreshTabActions();
            }
        }
    }

    private class IPChangedListener
    implements NetworkListener {
        private IPChangedListener() {
        }

        public void networkIPChanged(DestAddress localAddress) {
            String newAddress = localAddress.getFullHostName();
            if (newAddress.equals(NetworkTab.this.myIPLabel.getText())) {
                return;
            }
            NetworkTab.this.myIPLabel.setText(newAddress);
            String countryCode = localAddress.getCountryCode();
            Icon icon = null;
            if (countryCode != null && countryCode.length() > 0) {
                icon = GUIRegistry.getInstance().getIconFactory().getIcon("Flag_" + countryCode);
            }
            NetworkTab.this.myIPLabel.setIcon(icon);
        }

        public void connectedToNetwork() {
        }

        public void disconnectedFromNetwork() {
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getIconFactory().getIcon("BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            Host host = NetworkTab.this.getSelectedHost();
            if (host == null) {
                return;
            }
            GUIActionPerformer.browseHost(host.getHostAddress());
        }

        public void refreshActionState() {
            Host host;
            if (NetworkTab.this.networkTable.getSelectedRowCount() == 1 && (host = NetworkTab.this.getSelectedHost()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            Host host = NetworkTab.this.getSelectedHost();
            if (host == null) {
                return;
            }
            ChatManager.getInstance().openChat(host.getHostAddress());
        }

        public void refreshActionState() {
            Host host;
            if (NetworkTab.this.networkTable.getSelectedRowCount() == 1 && (host = NetworkTab.this.getSelectedHost()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class AddToFavoritesAction
    extends FWAction {
        public AddToFavoritesAction() {
            super(Localizer.getString("AddToFavorites"), GUIRegistry.getInstance().getIconFactory().getIcon("FavoriteHost"), Localizer.getString("TTTAddToFavorites"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            Host[] hosts = NetworkTab.this.getSelectedHosts();
            DestAddress[] addresses = new DestAddress[hosts.length];
            for (int i = 0; i < hosts.length; ++i) {
                addresses[i] = hosts[i].getHostAddress();
            }
            GUIActionPerformer.addHostsToFavorites(addresses);
        }

        public void refreshActionState() {
            if (NetworkTab.this.networkTable.getSelectedRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private final class BanHostActionProvider
    implements BanHostActionUtils.BanHostActionProvider {
        private BanHostActionProvider() {
        }

        public DestAddress[] getBanHostAddresses() {
            Host[] hosts = NetworkTab.this.getSelectedHosts();
            NetworkTab.this.hostMgr.removeNetworkHosts(hosts);
            DestAddress[] addresses = new DestAddress[hosts.length];
            for (int i = 0; i < hosts.length; ++i) {
                addresses[i] = hosts[i].getHostAddress();
            }
            return addresses;
        }

        public boolean isBanHostActionEnabled(boolean allowMultipleAddresses) {
            return NetworkTab.this.networkTable.getSelectedRow() >= 0 && (allowMultipleAddresses || NetworkTab.this.networkTable.getSelectedRowCount() <= 1);
        }
    }

    private class DisconnectHostAction
    extends FWAction {
        public DisconnectHostAction() {
            super(Localizer.getString("DisconnectHost"), GUIRegistry.getInstance().getIconFactory().getIcon("DisconnectHost"), Localizer.getString("TTTDisconnectHost"), null, KeyStroke.getKeyStroke(127, 0));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            Host[] hosts = NetworkTab.this.getSelectedHosts();
            NetworkTab.this.hostMgr.removeNetworkHosts(hosts);
        }

        public void refreshActionState() {
            if (NetworkTab.this.networkTable.getSelectedRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }
}

