/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.monitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import phex.common.IntObj;
import phex.download.RemoteFile;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.gui.models.ISearchDataModel;
import phex.gui.models.SearchTreeTableModel;
import phex.gui.tabs.search.SearchResultElement;
import phex.gui.tabs.search.SearchResultElementComparator;
import phex.msg.MsgManager;
import phex.query.QueryResultMonitor;
import phex.query.SearchFilter;

public class ResultMonitorDataModel
implements ISearchDataModel,
SearchDataListener {
    private ArrayList allRemoteFiles;
    private HashSet allSearchResultSHA1Set;
    private int allSearchResultCount;
    private ArrayList displayedSearchResults;
    private HashMap displayedSearchResultSHA1Map;
    private SearchTreeTableModel visualizationModel;
    private SearchResultElementComparator comparator;
    protected SearchFilter searchFilter;
    private IntObj searchElementCountObj;
    private IntObj filteredElementCountObj;

    public ResultMonitorDataModel() {
        QueryResultMonitor monitor = MsgManager.getInstance().getQueryResultMonitor();
        monitor.addSearchDataListener(this);
        this.allRemoteFiles = new ArrayList();
        this.allSearchResultSHA1Set = new HashSet();
        this.allSearchResultCount = 0;
        this.displayedSearchResults = new ArrayList();
        this.displayedSearchResultSHA1Map = new HashMap();
        this.searchElementCountObj = new IntObj();
        this.filteredElementCountObj = new IntObj();
        this.comparator = new SearchResultElementComparator();
        this.searchFilter = null;
    }

    public int getSearchElementCount() {
        return this.displayedSearchResults.size();
    }

    public IntObj getSearchElementCountObj() {
        if (this.searchElementCountObj.intValue() != this.displayedSearchResults.size()) {
            this.searchElementCountObj.setValue(this.displayedSearchResults.size());
        }
        return this.searchElementCountObj;
    }

    public IntObj getFilteredElementCountObj() {
        int count = this.getFilteredElementCount();
        if (this.filteredElementCountObj.intValue() != count) {
            this.filteredElementCountObj.setValue(count);
        }
        return this.filteredElementCountObj;
    }

    public int getFilteredElementCount() {
        return this.allSearchResultCount - this.displayedSearchResults.size();
    }

    public SearchResultElement getSearchElementAt(int index) {
        if (index < 0 || index >= this.displayedSearchResults.size()) {
            return null;
        }
        return (SearchResultElement)this.displayedSearchResults.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSearchResults(Object[] newSearchResults) {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                for (int i = 0; i < newSearchResults.length; ++i) {
                    RemoteFile remoteFile = (RemoteFile)newSearchResults[i];
                    this.addSearchResultForDisplay(remoteFile);
                    this.addSearchResultToAll(remoteFile);
                }
            }
        }
    }

    private void addSearchResultToAll(RemoteFile remoteFile) {
        this.allRemoteFiles.add(remoteFile);
        String sha1 = remoteFile.getSHA1();
        boolean found = false;
        if (sha1 != null) {
            found = this.allSearchResultSHA1Set.contains(sha1);
        }
        if (!found) {
            ++this.allSearchResultCount;
            if (sha1 != null && sha1.length() > 0) {
                this.allSearchResultSHA1Set.add(sha1);
            }
        }
    }

    private void addSearchResultForDisplay(RemoteFile remoteFile) {
        boolean isFiltered = this.isFiltered(remoteFile);
        if (isFiltered) {
            return;
        }
        SearchResultElement resultElement = null;
        String sha1 = remoteFile.getSHA1();
        if (sha1 != null) {
            resultElement = (SearchResultElement)this.displayedSearchResultSHA1Map.get(sha1);
        }
        if (resultElement != null) {
            resultElement.addRemoteFile(remoteFile);
            this.fireSearchResultAdded(remoteFile, resultElement);
        } else {
            resultElement = new SearchResultElement(remoteFile);
            int index = Collections.binarySearch(this.displayedSearchResults, resultElement, this.comparator);
            if (index <= 0) {
                if (sha1 != null && sha1.length() > 0) {
                    this.displayedSearchResultSHA1Map.put(sha1, resultElement);
                }
                this.displayedSearchResults.add(-index - 1, resultElement);
                this.fireNewSearchResultAdded(resultElement, -index - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSortBy(int sortField, boolean isSortedAscending) {
        ArrayList arrayList = this.displayedSearchResults;
        synchronized (arrayList) {
            this.comparator.setSortField(sortField, isSortedAscending);
            Collections.sort(this.displayedSearchResults, this.comparator);
            this.fireAllSearchResultsChanged();
        }
    }

    public void setVisualizationModel(SearchTreeTableModel model) {
        this.visualizationModel = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSearchFilter(SearchFilter aSearchFilter) {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.searchFilter = aSearchFilter;
                this.searchFilter.setLastTimeUsed(System.currentTimeMillis());
                this.updateFilteredQueryList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSearchFilter() {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.searchFilter = null;
                this.updateFilteredQueryList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSearchResults() {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.allRemoteFiles.clear();
                this.allSearchResultSHA1Set.clear();
                this.allSearchResultCount = 0;
                this.displayedSearchResults.clear();
                this.displayedSearchResultSHA1Map.clear();
                this.fireAllSearchResultsChanged();
            }
        }
    }

    public SearchFilter getSearchFilter() {
        return this.searchFilter;
    }

    private boolean isFiltered(RemoteFile remoteFile) {
        boolean isFiltered = false;
        if (this.searchFilter != null) {
            isFiltered = this.searchFilter.isFiltered(remoteFile);
        }
        return isFiltered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilteredQueryList() {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.displayedSearchResultSHA1Map.clear();
                this.displayedSearchResults.clear();
                this.fireAllSearchResultsChanged();
                Iterator iterator = this.allRemoteFiles.iterator();
                while (iterator.hasNext()) {
                    RemoteFile file = (RemoteFile)iterator.next();
                    this.addSearchResultForDisplay(file);
                }
            }
        }
    }

    public void searchDataChanged(SearchDataEvent e) {
        if (e.getType() == 1) {
            Object[] newSearchResults = e.getSearchData();
            this.addSearchResults(newSearchResults);
        }
    }

    private void fireAllSearchResultsChanged() {
        if (this.visualizationModel == null) {
            return;
        }
        Object[] path = new Object[]{this.visualizationModel.getRoot()};
        this.visualizationModel.fireTreeStructureChanged(this, path, null, null);
    }

    private void fireNewSearchResultAdded(SearchResultElement resultElement, int index) {
        if (this.visualizationModel == null) {
            return;
        }
        Object[] path = new Object[]{this.visualizationModel.getRoot()};
        int[] indices = new int[]{index};
        Object[] changes = new Object[]{resultElement};
        if (this.displayedSearchResults.size() == 1) {
            this.visualizationModel.fireTreeStructureChanged(this, path, indices, changes);
        } else {
            this.visualizationModel.fireTreeNodesInserted(this, path, indices, changes);
        }
    }

    private void fireSearchResultAdded(RemoteFile remoteFile, SearchResultElement resultElement) {
        if (this.visualizationModel == null) {
            return;
        }
        Object[] path = new Object[]{this.visualizationModel.getRoot(), resultElement};
        Object[] changes = new Object[]{remoteFile};
        this.visualizationModel.fireTreeNodesInserted(this, path, null, changes);
    }
}

