/*
 * Decompiled with CFR 0.152.
 */
package phex.gwebcache;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import phex.common.address.AddressUtils;
import phex.connection.ProtocolNotSupportedException;
import phex.gwebcache.GWebCacheContainer;
import phex.gwebcache.GWebCacheManager;
import phex.utils.NLogger;

public class GWebCache {
    private static final int MIN_RECONNECT_WAIT = 1800000;
    private URL url;
    private boolean isPhexCache;
    private long lastRequestTime;
    private int failedInRowCount;
    private int hash = 0;

    public GWebCache(URL url) throws IOException {
        this(url, false);
    }

    public GWebCache(URL url, boolean isPhexCache) throws IOException {
        if (url == null) {
            throw new NullPointerException("Null url given.");
        }
        if (!url.getProtocol().equals("http")) {
            throw new ProtocolNotSupportedException("Only http URLs are supported for a GWebCacheConnection");
        }
        if (url.getPort() == 80) {
            url = new URL(url.getProtocol(), url.getHost(), -1, url.getFile());
        }
        GWebCacheContainer container = GWebCacheManager.getInstance().getGWebCacheContainer();
        if (!isPhexCache && container.isPhexGWebCache(url.toExternalForm())) {
            NLogger.error("GWEBCACHE", "Trying to add Phex cache without Phex flag!");
            isPhexCache = true;
        }
        this.url = url;
        this.isPhexCache = isPhexCache;
    }

    public boolean isPhexCache() {
        return this.isPhexCache;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getHostDomain() {
        String host = this.url.getHost();
        if (AddressUtils.isIPHostName(host)) {
            return host;
        }
        int topLevelIdx = host.lastIndexOf(46);
        int domainIdx = host.lastIndexOf(46, topLevelIdx - 1);
        if (domainIdx != -1) {
            return host.substring(domainIdx + 1);
        }
        return host;
    }

    public int getFailedInRowCount() {
        return this.failedInRowCount;
    }

    public long getLastRequestTime() {
        return this.lastRequestTime;
    }

    public void countConnectionAttempt(boolean isFailed) {
        this.lastRequestTime = System.currentTimeMillis();
        this.failedInRowCount = isFailed ? ++this.failedInRowCount : 0;
    }

    public long getEarliestReConnectTime() {
        return (long)(1800000 * (this.failedInRowCount + 1)) + this.lastRequestTime;
    }

    public void setFailedInRowCount(int failedInRowCount) {
        this.failedInRowCount = failedInRowCount;
    }

    public void setLastRequestTime(long lastRequestTime) {
        this.lastRequestTime = lastRequestTime;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GWebCache)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GWebCache gwc = (GWebCache)obj;
        return new EqualsBuilder().append(this.url.getHost(), gwc.getUrl().getHost()).isEquals();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = new HashCodeBuilder(17, 37).append(this.url.getHost()).toHashCode();
        }
        return this.hash;
    }
}

