/*
 * Decompiled with CFR 0.152.
 */
package phex.gwebcache;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import phex.common.GeneralGnutellaNetwork;
import phex.common.ThreadPool;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.connection.ProtocolNotSupportedException;
import phex.gwebcache.GWebCache;
import phex.gwebcache.GWebCacheComparator;
import phex.gwebcache.GWebCacheConnection;
import phex.host.CaughtHostsContainer;
import phex.host.HostManager;
import phex.utils.NLogger;
import phex.utils.NormalizableURL;
import phex.utils.StringUtils;

public class GWebCacheContainer {
    private static int MIN_G_WEB_CACHES_SIZE;
    private static int MAX_G_WEB_CACHES_SIZE;
    private static List BLOCKED_WEB_CACHES;
    private static List PHEX_WEB_CACHES;
    private ArrayList allGWebCaches;
    private ArrayList functionalGWebCaches;
    private ArrayList phexGWebCaches;
    private Set uniqueGWebCacheURLs;
    private TreeSet sortedGWebCaches;
    private Random random;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GWebCacheContainer() {
        NLogger.debug("GWEBCACHE", (Object)"Initializing GWebCacheContainer");
        this.allGWebCaches = new ArrayList();
        this.phexGWebCaches = new ArrayList();
        this.functionalGWebCaches = new ArrayList();
        this.uniqueGWebCacheURLs = new HashSet();
        this.sortedGWebCaches = new TreeSet(new GWebCacheComparator());
        this.random = new Random();
        NLogger.debug("GWEBCACHE", (Object)"Initialized GWebCacheContainer");
    }

    public void initializeGWebCacheContainer() {
        this.allGWebCaches.clear();
        this.phexGWebCaches.clear();
        this.functionalGWebCaches.clear();
        this.uniqueGWebCacheURLs.clear();
        this.sortedGWebCaches.clear();
        this.insertPhexGWebCaches();
        Runnable runner = new Runnable(){

            public void run() {
                GWebCacheContainer.this.loadGWebCacheFromFile();
            }
        };
        ThreadPool.getInstance().addJob(runner, "LoadGWebCacheRunner");
    }

    public boolean queryMoreHosts(boolean preferPhex) {
        int retrys = 0;
        boolean succ = false;
        do {
            ++retrys;
            GWebCacheConnection connection = this.getRandomGWebCacheConnection(preferPhex);
            if (connection == null) continue;
            DestAddress[] hosts = connection.sendHostFileRequest();
            if (!this.verifyGWebCache(connection) || hosts == null) continue;
            CaughtHostsContainer container = HostManager.getInstance().getCaughtHostsContainer();
            for (int i = 0; i < hosts.length; ++i) {
                container.addCaughtHost(hosts[i], (short)2);
            }
            succ = true;
        } while (!succ && retrys < 5);
        return succ;
    }

    public boolean updateRemoteGWebCache(DestAddress myHostAddress, boolean preferPhex) {
        String fullHostName = null;
        if (myHostAddress != null) {
            fullHostName = myHostAddress.getFullHostName();
        }
        int retrys = 0;
        boolean succ = false;
        do {
            ++retrys;
            GWebCacheConnection connection = this.getRandomGWebCacheConnection(preferPhex);
            if (connection == null) continue;
            GWebCache gWebCache = this.getGWebCacheForUpdate(connection.getGWebCache());
            if (!($assertionsDisabled || !gWebCache.isPhexCache() && gWebCache.equals(connection.getGWebCache()))) {
                throw new AssertionError((Object)("isPhexCache: " + gWebCache.isPhexCache() + ",equals " + gWebCache.getUrl() + " - " + connection.getGWebCache().getUrl()));
            }
            String urlString = null;
            if (gWebCache != null) {
                urlString = gWebCache.getUrl().toExternalForm();
            }
            if (fullHostName == null && urlString == null) continue;
            succ = connection.updateRequest(fullHostName, urlString);
            if (this.verifyGWebCache(connection) && succ) continue;
        } while (!succ && retrys < 5);
        return succ;
    }

    public boolean queryMoreGWebCaches(boolean preferPhex) {
        int retrys = 0;
        boolean succ = false;
        do {
            ++retrys;
            GWebCacheConnection connection = this.getRandomGWebCacheConnection(preferPhex);
            if (connection == null) continue;
            URL[] urls = connection.sendURLFileRequest();
            if (!this.verifyGWebCache(connection) || urls == null) continue;
            for (int i = 0; i < urls.length; ++i) {
                try {
                    GWebCache gWebCache = new GWebCache(urls[i]);
                    if (!this.isCacheAccessAllowed(gWebCache)) continue;
                    this.insertGWebCache(gWebCache);
                    continue;
                }
                catch (IOException exp) {
                    NLogger.debug("GWEBCACHE", (Object)exp);
                }
            }
            succ = true;
        } while (!succ && retrys < 5);
        return succ;
    }

    public int getGWebCacheCount() {
        return this.allGWebCaches.size();
    }

    private GWebCache getGWebCacheForUpdate(GWebCache ignore) {
        GWebCache gWebCache = null;
        int count = this.functionalGWebCaches.size();
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            gWebCache = (GWebCache)this.functionalGWebCaches.get(0);
            if (gWebCache.equals(ignore)) {
                return null;
            }
            if (!$assertionsDisabled && gWebCache.isPhexCache()) {
                throw new AssertionError();
            }
            return gWebCache;
        }
        int tries = 0;
        do {
            int randomIndex;
            if ((gWebCache = (GWebCache)this.functionalGWebCaches.get(randomIndex = this.random.nextInt(count - 1))).equals(ignore)) continue;
            if (!$assertionsDisabled && gWebCache.isPhexCache()) {
                throw new AssertionError();
            }
            return gWebCache;
        } while (++tries < 10);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GWebCache getRandomGWebCache(boolean preferPhex) {
        this.ensureMinGWebCaches();
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            GWebCache cache;
            boolean usePhexCache;
            boolean bl = usePhexCache = preferPhex && this.random.nextInt(8) == 0;
            if (usePhexCache && this.phexGWebCaches.size() > 0) {
                int randomIndex = this.random.nextInt(this.phexGWebCaches.size());
                return (GWebCache)this.phexGWebCaches.get(randomIndex);
            }
            int count = this.allGWebCaches.size();
            if (count == 0) {
                return null;
            }
            long now = System.currentTimeMillis();
            if (now > (cache = (GWebCache)this.sortedGWebCaches.first()).getEarliestReConnectTime()) {
                return cache;
            }
            return null;
        }
    }

    private GWebCacheConnection getRandomGWebCacheConnection(boolean preferPhex) {
        GWebCacheConnection connection = null;
        GWebCache gWebCache = null;
        try {
            gWebCache = this.getRandomGWebCache(preferPhex);
            if (gWebCache == null) {
                return null;
            }
            connection = new GWebCacheConnection(gWebCache);
        }
        catch (ProtocolNotSupportedException exp) {
            this.removeGWebCache(gWebCache, true);
            return null;
        }
        return connection;
    }

    private boolean verifyGWebCache(GWebCacheConnection connection) {
        GWebCache gWebCache = connection.getGWebCache();
        this.sortedGWebCaches.remove(gWebCache);
        gWebCache.countConnectionAttempt(connection.isCacheBad());
        this.sortedGWebCaches.add(gWebCache);
        if (!(connection.isCacheBad() || gWebCache.isPhexCache() || this.functionalGWebCaches.contains(gWebCache))) {
            this.functionalGWebCaches.add(gWebCache);
        }
        this.saveGWebCacheToFile();
        return true;
    }

    private GWebCache parseGWebCacheFromLine(String line) throws IOException {
        int failedInRowCount;
        long lastRequestTime;
        String urlStr;
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount == 1) {
            urlStr = line;
            lastRequestTime = -1L;
            failedInRowCount = -1;
        } else if (tokenCount == 3) {
            urlStr = tokenizer.nextToken();
            try {
                lastRequestTime = Long.parseLong(tokenizer.nextToken());
            }
            catch (NumberFormatException exp) {
                lastRequestTime = -1L;
            }
            try {
                failedInRowCount = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException exp) {
                failedInRowCount = -1;
            }
        } else {
            NLogger.warn("GWEBCACHE", (Object)("Unknown HostCache line format: " + line));
            return null;
        }
        NormalizableURL helpUrl = new NormalizableURL(urlStr);
        helpUrl.normalize();
        URL url = new URL(helpUrl.toExternalForm());
        GWebCache cache = new GWebCache(url);
        if (lastRequestTime > 0L) {
            cache.setLastRequestTime(lastRequestTime);
        }
        if (failedInRowCount > 0) {
            cache.setFailedInRowCount(failedInRowCount);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertGWebCache(GWebCache gWebCache) {
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            if (this.allGWebCaches.size() >= MAX_G_WEB_CACHES_SIZE) {
                NLogger.error("GWEBCACHE", "Limit of 1000 GWebCaches reached.");
                this.removeGWebCache((GWebCache)this.sortedGWebCaches.last(), true);
                return;
            }
            String uniqueString = gWebCache.getHostDomain();
            if (!this.uniqueGWebCacheURLs.contains(uniqueString)) {
                this.allGWebCaches.add(gWebCache);
                this.sortedGWebCaches.add(gWebCache);
                this.uniqueGWebCacheURLs.add(uniqueString);
                if (gWebCache.isPhexCache()) {
                    this.phexGWebCaches.add(gWebCache);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGWebCache(GWebCache gWebCache, boolean force) {
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            if (this.allGWebCaches.size() > MIN_G_WEB_CACHES_SIZE || force) {
                this.allGWebCaches.remove(gWebCache);
                this.functionalGWebCaches.remove(gWebCache);
                this.sortedGWebCaches.remove(gWebCache);
                String uniqueString = gWebCache.getHostDomain();
                this.uniqueGWebCacheURLs.remove(uniqueString);
                if (gWebCache.isPhexCache()) {
                    this.phexGWebCaches.remove(gWebCache);
                }
                this.saveGWebCacheToFile();
            }
        }
    }

    private void insertGWebCacheFromLine(String gWebCacheLine) {
        try {
            GWebCache gWebCache = this.parseGWebCacheFromLine(gWebCacheLine);
            if (gWebCache != null && this.isCacheAccessAllowed(gWebCache)) {
                this.insertGWebCache(gWebCache);
            }
        }
        catch (IOException exp) {
            NLogger.debug("GWEBCACHE", (Object)exp);
        }
    }

    private void ensureMinGWebCaches() {
        if (this.allGWebCaches.size() >= 10) {
            return;
        }
        NetworkManager networkMgr = NetworkManager.getInstance();
        if (!(networkMgr.getGnutellaNetwork() instanceof GeneralGnutellaNetwork)) {
            return;
        }
        NLogger.debug("GWEBCACHE", (Object)"Load default GWebCache file.");
        InputStream inStream = ClassLoader.getSystemResourceAsStream("phex/resources/gwebcache.cfg");
        if (inStream != null) {
            InputStreamReader reader = new InputStreamReader(inStream);
            try {
                this.loadGWebCacheFromReader(reader);
                this.saveGWebCacheToFile();
            }
            catch (IOException exp) {
                NLogger.warn("GWEBCACHE", (Object)exp, (Throwable)exp);
            }
        } else {
            NLogger.warn("GWEBCACHE", (Object)"Default GWebCache file not found.");
        }
        if (this.allGWebCaches.size() < 1) {
            this.insertPhexGWebCaches();
            this.saveGWebCacheToFile();
        }
    }

    private void insertPhexGWebCaches() {
        NetworkManager networkMgr = NetworkManager.getInstance();
        if (!(networkMgr.getGnutellaNetwork() instanceof GeneralGnutellaNetwork)) {
            return;
        }
        Iterator iterator = PHEX_WEB_CACHES.iterator();
        while (iterator.hasNext()) {
            try {
                String phexCachesURL = (String)iterator.next();
                URL url = new URL(phexCachesURL);
                GWebCache cache = new GWebCache(url, true);
                this.insertGWebCache(cache);
            }
            catch (IOException e) {
                NLogger.error("GWEBCACHE", (Object)e, (Throwable)e);
            }
        }
    }

    private boolean isCacheAccessAllowed(GWebCache gWebCache) {
        URL cacheURL = gWebCache.getUrl();
        String hostName = cacheURL.getHost();
        if (AddressUtils.isIPHostName(hostName) && StringUtils.isEmpty(cacheURL.getPath())) {
            return false;
        }
        Iterator iterator = BLOCKED_WEB_CACHES.iterator();
        while (iterator.hasNext()) {
            String blocked = (String)iterator.next();
            if (hostName.indexOf(blocked) == -1) continue;
            NLogger.debug("GWEBCACHE", (Object)"GWebCache host blocked.");
            return false;
        }
        return true;
    }

    public boolean isPhexGWebCache(String url) {
        return PHEX_WEB_CACHES.indexOf(url) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGWebCacheFromFile() {
        try {
            NetworkManager networkMgr = NetworkManager.getInstance();
            File file = networkMgr.getGnutellaNetwork().getGWebCacheFile();
            if (!file.exists()) {
                return;
            }
            this.loadGWebCacheFromReader(new FileReader(file));
        }
        catch (IOException exp) {
            NLogger.error("GWEBCACHE", (Object)exp, (Throwable)exp);
        }
        finally {
            this.ensureMinGWebCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGWebCacheFromReader(Reader reader) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                this.insertGWebCacheFromLine(line);
            }
        }
        br.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGWebCacheToFile() {
        NLogger.debug("GWEBCACHE", (Object)"Saving GWebCaches.");
        try {
            NetworkManager networkMgr = NetworkManager.getInstance();
            File file = networkMgr.getGnutellaNetwork().getGWebCacheFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            ArrayList arrayList = this.allGWebCaches;
            synchronized (arrayList) {
                Iterator iterator = this.allGWebCaches.iterator();
                while (iterator.hasNext()) {
                    GWebCache gWebCache = (GWebCache)iterator.next();
                    if (gWebCache.isPhexCache()) continue;
                    writer.write(gWebCache.getUrl().toExternalForm() + " " + gWebCache.getLastRequestTime() + " " + gWebCache.getFailedInRowCount());
                    writer.newLine();
                }
            }
            writer.close();
        }
        catch (IOException exp) {
            NLogger.error("GWEBCACHE", (Object)exp, (Throwable)exp);
        }
    }

    static {
        $assertionsDisabled = !GWebCacheContainer.class.desiredAssertionStatus();
        MIN_G_WEB_CACHES_SIZE = 5;
        MAX_G_WEB_CACHES_SIZE = 1000;
        String[] arr = new String[]{"http://gc-phex02.draketo.de/gcache.php", "http://phexgwc.kouk.de/gcache.php"};
        PHEX_WEB_CACHES = Collections.unmodifiableList(Arrays.asList(arr));
        String[] blockedArr = new String[]{"gavinroy.com"};
        BLOCKED_WEB_CACHES = Collections.unmodifiableList(Arrays.asList(blockedArr));
    }
}

