/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import phex.common.IntObj;
import phex.common.address.DestAddress;

public class CaughtHost {
    private static IntObj CAUGHT_HOST_COUNTER = new IntObj(0);
    private int counter;
    private long lastFailedConnection;
    private long lastSuccessfulConnection;
    private int avgDailyUptime;
    private DestAddress hostAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaughtHost(DestAddress address) {
        IntObj intObj = CAUGHT_HOST_COUNTER;
        synchronized (intObj) {
            this.counter = CAUGHT_HOST_COUNTER.inc(1);
        }
        this.hostAddress = address;
        this.lastFailedConnection = -1L;
        this.lastSuccessfulConnection = -1L;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public void setDailyUptime(int dailyUptime) {
        this.avgDailyUptime = dailyUptime;
    }

    public int getDailyUptime() {
        return this.avgDailyUptime;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CaughtHost)) {
            return false;
        }
        return this.hostAddress.equals(((CaughtHost)o).hostAddress);
    }

    public int hashCode() {
        return ((Object)this.hostAddress).hashCode();
    }

    public int getConnectionTimeRating() {
        if (this.lastSuccessfulConnection == -1L && this.lastFailedConnection == -1L) {
            return 0;
        }
        if (this.lastFailedConnection > this.lastSuccessfulConnection) {
            return -1;
        }
        return 1;
    }

    public void setLastFailedConnection(long l) {
        this.lastFailedConnection = l;
    }

    public void setLastSuccessfulConnection(long l) {
        this.lastSuccessfulConnection = l;
    }

    public long getLastFailedConnection() {
        return this.lastFailedConnection;
    }

    public long getLastSuccessfulConnection() {
        return this.lastSuccessfulConnection;
    }

    public String toString() {
        return "CaughtHost[" + this.hostAddress.toString() + ",Failed=" + this.lastFailedConnection + ",Successful=" + this.lastSuccessfulConnection + ",Uptime=" + this.avgDailyUptime + "]";
    }

    public int getCounter() {
        return this.counter;
    }
}

