/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.TreeSet;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.event.AsynchronousDispatcher;
import phex.event.CaughtHostsChangeListener;
import phex.gwebcache.GWebCacheManager;
import phex.host.CatchedHostCache;
import phex.host.CaughtHost;
import phex.msg.PongMsg;
import phex.security.PhexSecurityManager;
import phex.udp.hostcache.UdpHostCache;
import phex.udp.hostcache.UdpHostCacheManager;
import phex.utils.IPUtils;
import phex.utils.NLogger;
import phex.utils.PriorityQueue;

public class CaughtHostsContainer {
    public static final short HIGH_PRIORITY = 2;
    public static final short NORMAL_PRIORITY = 1;
    public static final short LOW_PRIORITY = 0;
    private static final int FREE_SLOT_SET_SIZE = 8;
    private PriorityQueue caughtHosts;
    private HashSet uniqueCaughtHosts;
    private CatchedHostCache catchedHostCache;
    private Collection freeLeafSlotSet;
    private Collection freeUltrapeerSlotSet;
    private ArrayList listenerList = new ArrayList(2);
    private boolean hasChangedSinceLastSave;

    public CaughtHostsContainer() {
        int[] capacities = new int[3];
        capacities[2] = (int)Math.round((double)ServiceManager.sCfg.mNetMaxHostToCatch * 2.0 / 3.0);
        capacities[1] = (int)Math.round((double)(ServiceManager.sCfg.mNetMaxHostToCatch - capacities[2]) * 2.0 / 3.0);
        capacities[0] = ServiceManager.sCfg.mNetMaxHostToCatch - capacities[2] - capacities[1];
        this.caughtHosts = new PriorityQueue(capacities);
        this.uniqueCaughtHosts = new HashSet();
        this.catchedHostCache = new CatchedHostCache();
        Environment.getInstance().scheduleTimerTask(new SaveHostsContainerTimer(), 60000L, 60000L);
        this.freeUltrapeerSlotSet = this.createFreeSlotContainer();
        this.freeLeafSlotSet = this.createFreeSlotContainer();
    }

    public void initializeCaughtHostsContainer() {
        this.caughtHosts.clear();
        this.catchedHostCache.clear();
        this.hasChangedSinceLastSave = false;
        this.loadHostsFromFile();
    }

    public boolean addCaughtHost(PongMsg pongMsg) {
        UdpHostCache cache;
        Set udpHostCaches;
        Set ipPortPairs;
        short priority;
        int port;
        byte[] pongIP = pongMsg.getIP();
        DefaultDestAddress address = new DefaultDestAddress(pongIP, port = pongMsg.getPort());
        boolean valid = this.isValidCaughtHostAddress(address);
        if (!valid) {
            return false;
        }
        CaughtHost caughtHost = new CaughtHost(address);
        int dailyUptime = pongMsg.getDailyUptime();
        if (dailyUptime > 0) {
            caughtHost.setDailyUptime(dailyUptime);
        }
        if (pongMsg.isUltrapeerMarked()) {
            priority = 2;
            if (pongMsg.hasFreeLeafSlots()) {
                this.addToFreeLeafSlotSet(caughtHost);
            }
            if (pongMsg.hasFreeUPSlots()) {
                this.addToFreeUltrapeerSlotSet(caughtHost);
            }
        } else {
            priority = 0;
        }
        if ((ipPortPairs = pongMsg.getIPPDestAddresses()) != null) {
            Iterator iterator = ipPortPairs.iterator();
            while (iterator.hasNext()) {
                DestAddress ipPortAdd = (DestAddress)iterator.next();
                if (!this.isValidCaughtHostAddress(ipPortAdd)) continue;
                this.addToCaughtHostFetcher(caughtHost, (short)2);
            }
        }
        if ((udpHostCaches = pongMsg.getUdpHostCaches()) != null) {
            UdpHostCacheManager udpHostMgr = UdpHostCacheManager.getInstance();
            Iterator iterator = ipPortPairs.iterator();
            while (iterator.hasNext()) {
                UdpHostCache cache2 = (UdpHostCache)iterator.next();
                udpHostMgr.getUdpHostCacheContainer().addCache(cache2);
            }
        }
        if ((cache = pongMsg.getUdpHostCache()) != null) {
            UdpHostCacheManager udpHostMgr = UdpHostCacheManager.getInstance();
            udpHostMgr.getUdpHostCacheContainer().addFunctionalCache(cache);
        }
        this.addPersistentCaughtHost(caughtHost);
        boolean isNew = this.addToCaughtHostFetcher(caughtHost, priority);
        return isNew;
    }

    public void addCaughtHost(DestAddress address, short priority) {
        boolean valid = this.isValidCaughtHostAddress(address);
        if (!valid) {
            return;
        }
        CaughtHost caughtHost = new CaughtHost(address);
        this.addPersistentCaughtHost(caughtHost);
        this.addToCaughtHostFetcher(caughtHost, priority);
    }

    private synchronized boolean addToCaughtHostFetcher(CaughtHost caughtHost, short priority) {
        boolean isNew = false;
        if (!this.uniqueCaughtHosts.contains(caughtHost)) {
            isNew = this.uniqueCaughtHosts.add(caughtHost);
            Object removed = this.caughtHosts.addToHead(caughtHost, priority);
            if (removed != null) {
                this.uniqueCaughtHosts.remove(removed);
            }
            this.fireCaughtHostsChanged();
        }
        return isNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPersistentCaughtHost(CaughtHost caughtHost) {
        CatchedHostCache catchedHostCache = this.catchedHostCache;
        synchronized (catchedHostCache) {
            DestAddress address = caughtHost.getHostAddress();
            CaughtHost existingHost = this.catchedHostCache.getCaughHost(address);
            if (existingHost == null) {
                this.catchedHostCache.add(caughtHost);
            } else {
                this.catchedHostCache.remove(existingHost);
                if (caughtHost.getDailyUptime() > 0) {
                    existingHost.setDailyUptime(caughtHost.getDailyUptime());
                }
                this.catchedHostCache.add(existingHost);
            }
            this.hasChangedSinceLastSave = true;
        }
    }

    public synchronized int getCaughtHostsCount() {
        return this.caughtHosts.getSize();
    }

    public synchronized DestAddress getNextCaughtHost() {
        this.ensureMinCaughHosts();
        if (!this.caughtHosts.isEmpty()) {
            CaughtHost host = (CaughtHost)this.caughtHosts.removeMaxPriority();
            return host.getHostAddress();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportConnectionStatus(DestAddress hostAddress, boolean successfulConnection) {
        boolean valid = this.isValidCaughtHostAddress(hostAddress);
        if (!valid) {
            return;
        }
        CatchedHostCache catchedHostCache = this.catchedHostCache;
        synchronized (catchedHostCache) {
            CaughtHost existingHost = this.catchedHostCache.getCaughHost(hostAddress);
            if (existingHost == null) {
                existingHost = new CaughtHost(hostAddress);
            } else {
                this.catchedHostCache.remove(existingHost);
            }
            if (successfulConnection) {
                existingHost.setLastSuccessfulConnection(System.currentTimeMillis());
            } else {
                existingHost.setLastFailedConnection(System.currentTimeMillis());
            }
            this.catchedHostCache.add(existingHost);
            this.hasChangedSinceLastSave = true;
        }
    }

    private void ensureMinCaughHosts() {
        int minCount = (int)Math.ceil((double)ServiceManager.sCfg.mNetMaxHostToCatch / 100.0);
        if (this.caughtHosts.getSize() < minCount) {
            UdpHostCacheManager.getInstance().invokeQueryCachesRequest();
            NLogger.info("GLOBAL", (Object)" Started a UDP HOST CACHE Query to ensure min no of hosts in the caughthost container");
            GWebCacheManager.getInstance().invokeQueryMoreHostsRequest(false);
        }
    }

    private boolean isValidCaughtHostAddress(DestAddress address) {
        if (address.isLocalHost() || !address.isValidAddress() || address.isSiteLocalAddress()) {
            return false;
        }
        return !IPUtils.isPortInUserInvalidList(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFreeUltrapeerSlotSet(CaughtHost host) {
        Collection collection = this.freeUltrapeerSlotSet;
        synchronized (collection) {
            this.freeUltrapeerSlotSet.add(host);
            if (this.freeUltrapeerSlotSet.size() > 8) {
                TreeSet treeSetView = (TreeSet)this.freeUltrapeerSlotSet;
                CaughtHost last = (CaughtHost)treeSetView.last();
                this.freeUltrapeerSlotSet.remove(last);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFreeLeafSlotSet(CaughtHost host) {
        Collection collection = this.freeLeafSlotSet;
        synchronized (collection) {
            this.freeLeafSlotSet.add(host);
            if (this.freeLeafSlotSet.size() > 8) {
                TreeSet treeSetView = (TreeSet)this.freeLeafSlotSet;
                CaughtHost last = (CaughtHost)treeSetView.last();
                this.freeLeafSlotSet.remove(last);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getFreeUltrapeerSlotHosts() {
        Collection collection = this.freeUltrapeerSlotSet;
        synchronized (collection) {
            ArrayList freeHosts = new ArrayList(this.freeUltrapeerSlotSet);
            freeHosts.trimToSize();
            return freeHosts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getFreeLeafSlotHosts() {
        Collection collection = this.freeLeafSlotSet;
        synchronized (collection) {
            ArrayList freeHosts = new ArrayList(this.freeLeafSlotSet);
            freeHosts.trimToSize();
            return freeHosts;
        }
    }

    private Collection createFreeSlotContainer() {
        TreeSet freeSlotSet = new TreeSet(new SlotHostComparator());
        return freeSlotSet;
    }

    private void loadHostsFromFile() {
        NLogger.debug(CaughtHostsContainer.class, (Object)"Loading hosts file.");
        try {
            String line;
            BufferedReader br;
            NetworkManager networkMgr = NetworkManager.getInstance();
            File file = networkMgr.getGnutellaNetwork().getHostsFile();
            if (file.exists()) {
                br = new BufferedReader(new FileReader(file));
            } else {
                NLogger.debug(CaughtHostsContainer.class, (Object)"Load default hosts file.");
                InputStream inStream = ClassLoader.getSystemResourceAsStream("phex/resources/phex.hosts");
                if (inStream != null) {
                    br = new BufferedReader(new InputStreamReader(inStream));
                } else {
                    NLogger.debug(CaughtHostsContainer.class, (Object)"Default Phex Hosts file not found.");
                    return;
                }
            }
            PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
            short usedPriority = 0;
            block5: while ((line = br.readLine()) != null) {
                CaughtHost caughtHost;
                if (line.startsWith("#") || (caughtHost = this.parseCaughtHostFromLine(line)) == null) continue;
                byte access = securityMgr.controlHostAddressAccess(caughtHost.getHostAddress());
                switch (access) {
                    case 2: 
                    case 3: {
                        continue block5;
                    }
                }
                if (IPUtils.isPortInUserInvalidList(caughtHost.getHostAddress())) continue;
                this.addPersistentCaughtHost(caughtHost);
                if (usedPriority != 2 && this.caughtHosts.isFull(usedPriority)) {
                    usedPriority = (short)(usedPriority + 1);
                }
                this.addToCaughtHostFetcher(caughtHost, usedPriority);
            }
            br.close();
        }
        catch (IOException exp) {
            NLogger.warn(CaughtHostsContainer.class, (Object)exp, (Throwable)exp);
        }
    }

    private CaughtHost parseCaughtHostFromLine(String line) {
        long lastSuccessfulConnection;
        long lastFailedconnection;
        int dailyUptime;
        String hostAddressStr;
        StringTokenizer tokenizer = new StringTokenizer(line, ",");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount == 1) {
            hostAddressStr = line;
            dailyUptime = -1;
            lastFailedconnection = -1L;
            lastSuccessfulConnection = -1L;
        } else if (tokenCount == 4) {
            hostAddressStr = tokenizer.nextToken();
            try {
                lastFailedconnection = Long.parseLong(tokenizer.nextToken());
            }
            catch (NumberFormatException exp) {
                lastFailedconnection = -1L;
            }
            try {
                lastSuccessfulConnection = Long.parseLong(tokenizer.nextToken());
            }
            catch (NumberFormatException exp) {
                lastSuccessfulConnection = -1L;
            }
            try {
                dailyUptime = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException exp) {
                dailyUptime = -1;
            }
        } else {
            NLogger.warn(CaughtHostsContainer.class, (Object)("Unknown HostCache line format: " + line));
            return null;
        }
        byte[] ip = AddressUtils.parseIP(hostAddressStr);
        if (ip == null) {
            return null;
        }
        int port = AddressUtils.parsePort(hostAddressStr);
        if (port == -1) {
            return null;
        }
        DefaultDestAddress hostAddress = new DefaultDestAddress(ip, port);
        CaughtHost caughtHost = new CaughtHost(hostAddress);
        if (dailyUptime > 0) {
            caughtHost.setDailyUptime(dailyUptime);
        }
        if (lastFailedconnection > 0L) {
            caughtHost.setLastFailedConnection(lastFailedconnection);
        }
        if (lastSuccessfulConnection > 0L) {
            caughtHost.setLastSuccessfulConnection(lastSuccessfulConnection);
        }
        return caughtHost;
    }

    public void saveHostsContainer() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        this.saveCaughtHosts();
        this.hasChangedSinceLastSave = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCaughtHosts() {
        NLogger.debug(CaughtHostsContainer.class, (Object)"Start saving caught hosts.");
        try {
            NetworkManager networkMgr = NetworkManager.getInstance();
            File file = networkMgr.getGnutellaNetwork().getHostsFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            CatchedHostCache catchedHostCache = this.catchedHostCache;
            synchronized (catchedHostCache) {
                Iterator iterator = this.catchedHostCache.iterator();
                while (iterator.hasNext()) {
                    CaughtHost host = (CaughtHost)iterator.next();
                    DestAddress hostAddress = host.getHostAddress();
                    bw.write(hostAddress.getFullHostName() + "," + host.getLastFailedConnection() + "," + host.getLastSuccessfulConnection() + "," + host.getDailyUptime());
                    bw.newLine();
                }
            }
            bw.close();
        }
        catch (IOException exp) {
            NLogger.error(CaughtHostsContainer.class, (Object)exp, (Throwable)exp);
        }
        NLogger.debug(CaughtHostsContainer.class, (Object)"Finish saving caught hosts.");
    }

    public void addCaughtHostsChangeListener(CaughtHostsChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removeCaughtHostsChangeListener(CaughtHostsChangeListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireCaughtHostsChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = CaughtHostsContainer.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    CaughtHostsChangeListener listener = (CaughtHostsChangeListener)listeners[i];
                    listener.caughtHostsChanged();
                }
            }
        });
    }

    private void fireAutoConnectHostAdded(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = CaughtHostsContainer.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    CaughtHostsChangeListener listener = (CaughtHostsChangeListener)listeners[i];
                    listener.autoConnectHostAdded(position);
                }
            }
        });
    }

    private void fireAutoConnectHostRemoved(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = CaughtHostsContainer.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    CaughtHostsChangeListener listener = (CaughtHostsChangeListener)listeners[i];
                    listener.autoConnectHostRemoved(position);
                }
            }
        });
    }

    private class SlotHostComparator
    implements Comparator {
        private SlotHostComparator() {
        }

        public int compare(Object o1, Object o2) {
            DestAddress addrB;
            CaughtHost hostA = (CaughtHost)o1;
            CaughtHost hostB = (CaughtHost)o2;
            DestAddress addrA = hostA.getHostAddress();
            if (addrA.equals(addrB = hostB.getHostAddress())) {
                return 0;
            }
            if (hostA.getDailyUptime() > hostB.getDailyUptime()) {
                return -1;
            }
            if (hostA.getDailyUptime() < hostB.getDailyUptime()) {
                return 1;
            }
            return -1;
        }
    }

    private class SaveHostsContainerTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private SaveHostsContainerTimer() {
        }

        public void run() {
            try {
                ThreadPool.getInstance().addJob(new SaveHostsContainerRunner(), "SaveHostsContainer");
            }
            catch (Throwable th) {
                NLogger.error(class$phex$host$CaughtHostsContainer == null ? (class$phex$host$CaughtHostsContainer = CaughtHostsContainer.class$("phex.host.CaughtHostsContainer")) : class$phex$host$CaughtHostsContainer, (Object)th, th);
            }
        }
    }

    private class SaveHostsContainerRunner
    implements Runnable {
        private SaveHostsContainerRunner() {
        }

        public void run() {
            CaughtHostsContainer.this.saveHostsContainer();
        }
    }
}

