/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.ThreadPool;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.connection.NetworkManager;
import phex.event.AsynchronousDispatcher;
import phex.event.BookmarkedHostsChangeListener;
import phex.host.FavoriteHost;
import phex.utils.NLogger;
import phex.utils.VersionUtils;
import phex.xml.sax.DPhex;
import phex.xml.sax.DSubElementList;
import phex.xml.sax.XMLBuilder;
import phex.xml.sax.favorites.DFavoriteHost;

public class FavoritesContainer {
    private ArrayList listenerList = new ArrayList(2);
    private ArrayList favoritesList = new ArrayList();
    private boolean hasChangedSinceLastSave = false;

    public FavoritesContainer() {
        Environment.getInstance().scheduleTimerTask(new SaveFavoritesTimer(), 60000L, 60000L);
    }

    public void initializeFavorites() {
        this.favoritesList.clear();
        this.loadFromFile();
    }

    public synchronized void addFavorites(DestAddress[] addresses) {
        for (int i = 0; i < addresses.length; ++i) {
            FavoriteHost host = new FavoriteHost(addresses[i]);
            this.insertBookmarkedHost(host, this.favoritesList.size());
        }
    }

    public synchronized void addFavorite(DestAddress address) {
        FavoriteHost host = new FavoriteHost(address);
        this.insertBookmarkedHost(host, this.favoritesList.size());
    }

    private void loadFromFile() {
        NLogger.debug("Favorites", (Object)"Loading favorites file.");
        NetworkManager networkMgr = NetworkManager.getInstance();
        File favoritesFile = networkMgr.getGnutellaNetwork().getFavoritesFile();
        try {
            if (!favoritesFile.exists()) {
                return;
            }
            FileManager fileMgr = FileManager.getInstance();
            ManagedFile managedFile = fileMgr.getReadWriteManagedFile(favoritesFile);
            DPhex dPhex = XMLBuilder.loadDPhexFromFile(managedFile);
            if (dPhex == null) {
                NLogger.debug("Favorites", (Object)"No bookmarked hosts file found.");
                return;
            }
            DSubElementList dHostList = dPhex.getFavoritesList();
            if (dHostList == null) {
                NLogger.warn("Favorites", (Object)"No DFavoritesList found.");
            }
            Iterator iterator = dHostList.getSubElementList().iterator();
            while (iterator.hasNext()) {
                DFavoriteHost dHost = (DFavoriteHost)iterator.next();
                int port = dHost.getPort();
                DefaultDestAddress address = null;
                String hostName = dHost.getHostName();
                byte[] ip = dHost.getIp();
                if (hostName != null) {
                    address = new DefaultDestAddress(hostName, port);
                } else if (ip != null) {
                    address = new DefaultDestAddress(ip, port);
                }
                if (address == null) continue;
                FavoriteHost bookmarkedHost = new FavoriteHost(address);
                this.insertBookmarkedHost(bookmarkedHost, this.favoritesList.size());
            }
        }
        catch (IOException exp) {
            NLogger.error("Favorites", (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsLoadFailed", new String[]{exp.toString()});
            return;
        }
        catch (ManagedFileException exp) {
            NLogger.error("Favorites", (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsLoadFailed", new String[]{exp.toString()});
            return;
        }
    }

    public synchronized void saveFavoriteHosts() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        try {
            DPhex dPhex = new DPhex();
            dPhex.setPhexVersion(VersionUtils.getFullProgramVersion());
            DSubElementList dList = new DSubElementList("favorites-list");
            dPhex.setFavoritesList(dList);
            List list = dList.getSubElementList();
            Iterator iterator = this.favoritesList.iterator();
            while (iterator.hasNext()) {
                FavoriteHost host = (FavoriteHost)iterator.next();
                DFavoriteHost dHost = new DFavoriteHost();
                DestAddress address = host.getHostAddress();
                if (address.isIpHostName()) {
                    dHost.setIp(address.getIpAddress().getHostIP());
                } else {
                    dHost.setHostName(address.getHostName());
                }
                dHost.setPort(address.getPort());
                list.add(dHost);
            }
            NetworkManager networkMgr = NetworkManager.getInstance();
            File bookmarkFile = networkMgr.getGnutellaNetwork().getFavoritesFile();
            ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile(bookmarkFile);
            XMLBuilder.saveToFile(managedFile, dPhex);
            this.hasChangedSinceLastSave = false;
        }
        catch (IOException exp) {
            NLogger.error("Favorites", (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsSaveFailed", new String[]{exp.toString()});
        }
        catch (ManagedFileException exp) {
            NLogger.error("Favorites", (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsSaveFailed", new String[]{exp.toString()});
        }
    }

    public synchronized int getBookmarkedHostsCount() {
        return this.favoritesList.size();
    }

    public synchronized FavoriteHost getBookmarkedHostAt(int index) {
        if (index >= this.favoritesList.size()) {
            return null;
        }
        return (FavoriteHost)this.favoritesList.get(index);
    }

    private synchronized void insertBookmarkedHost(FavoriteHost host, int position) {
        if (!this.favoritesList.contains(host)) {
            this.favoritesList.add(position, host);
            this.hasChangedSinceLastSave = true;
            this.fireBookmarkedHostAdded(position);
        }
    }

    public synchronized void removeBookmarkedHost(FavoriteHost host) {
        int position = this.favoritesList.indexOf(host);
        if (position >= 0) {
            this.favoritesList.remove(position);
            this.fireBookmarkedHostRemoved(position);
            this.hasChangedSinceLastSave = true;
        }
    }

    public void addBookmarkedHostsChangeListener(BookmarkedHostsChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removeBookmarkedHostsChangeListener(BookmarkedHostsChangeListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireBookmarkedHostAdded(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = FavoritesContainer.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    BookmarkedHostsChangeListener listener = (BookmarkedHostsChangeListener)listeners[i];
                    listener.bookmarkedHostAdded(position);
                }
            }
        });
    }

    private void fireBookmarkedHostRemoved(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = FavoritesContainer.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    BookmarkedHostsChangeListener listener = (BookmarkedHostsChangeListener)listeners[i];
                    listener.bookmarkedHostRemoved(position);
                }
            }
        });
    }

    private class SaveFavoritesTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private SaveFavoritesTimer() {
        }

        public void run() {
            try {
                ThreadPool.getInstance().addJob(new SaveFavoritesRunner(), "SaveBookmarkedHosts");
            }
            catch (Throwable th) {
                NLogger.error("Favorites", (Object)th, th);
            }
        }
    }

    private class SaveFavoritesRunner
    implements Runnable {
        private SaveFavoritesRunner() {
        }

        public void run() {
            FavoritesContainer.this.saveFavoriteHosts();
        }
    }
}

