/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import phex.host.Host;
import phex.host.HostConstants;
import phex.utils.Localizer;

public class HostInfo
implements HostConstants {
    public static String getHostStatusString(Host host) {
        int status = host.getStatus();
        String lastStatusMsg = host.getLastStatusMsg();
        switch (status) {
            case 0: {
                return Localizer.getString("NetHostStatus_NotConnected");
            }
            case 1: {
                Object[] args = new Object[]{lastStatusMsg};
                return Localizer.getFormatedString("NetHostStatus_Error", args);
            }
            case 2: {
                Object[] args = new Object[]{lastStatusMsg != null ? lastStatusMsg : ""};
                return Localizer.getFormatedString("NetHostStatus_Connecting", args);
            }
            case 3: {
                Object[] args = new Object[]{lastStatusMsg};
                return Localizer.getFormatedString("NetHostStatus_Accepting", args);
            }
            case 4: {
                Object[] args = new Object[]{host.isSendQueueInRed() ? new Integer(1) : new Integer(0)};
                return Localizer.getFormatedString("NetHostStatus_Connected", args);
            }
            case 5: {
                return Localizer.getString("NetHostStatus_Disconnected");
            }
        }
        return Localizer.getString("NetHostStatus_Unknown");
    }
}

