/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.IOException;
import java.util.TimerTask;
import phex.common.AbstractManager;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.connection.ConnectionEngine;
import phex.connection.ConnectionObserver;
import phex.connection.NetworkManager;
import phex.connection.PingWorker;
import phex.event.NetworkHostsChangeListener;
import phex.host.CaughtHostsContainer;
import phex.host.FavoritesContainer;
import phex.host.Host;
import phex.host.NetworkHostsContainer;
import phex.host.UltrapeerCapabilityChecker;
import phex.utils.NLogger;

public final class HostManager
extends AbstractManager {
    private static final int MAX_PARALLEL_CONNECTION_TRIES = 20;
    private NetworkManager networkMgr;
    private CaughtHostsContainer caughtHostsContainer;
    private NetworkHostsContainer networkHostsContainer;
    private FavoritesContainer favoritesContainer = new FavoritesContainer();
    private UltrapeerCapabilityChecker upChecker;

    private HostManager() {
        this.caughtHostsContainer = new CaughtHostsContainer();
    }

    public static HostManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        this.networkMgr = NetworkManager.getInstance();
        this.networkHostsContainer = new NetworkHostsContainer();
        ConnectionObserver observer = new ConnectionObserver();
        observer.start();
        PingWorker pingWorker = new PingWorker();
        pingWorker.start();
        NetworkManager networkMgr = NetworkManager.getInstance();
        networkMgr.addNetworkListener(this.networkHostsContainer);
        this.upChecker = new UltrapeerCapabilityChecker();
        return true;
    }

    public void startupCompletedNotify() {
        Environment.getInstance().scheduleTimerTask(new HostCheckTimer(), 2000L, 2000L);
    }

    public void shutdown() {
        try {
            this.caughtHostsContainer.saveHostsContainer();
            this.favoritesContainer.saveFavoriteHosts();
        }
        catch (Exception exp) {
            NLogger.error("GLOBAL", (Object)exp, (Throwable)exp);
        }
    }

    public void acceptIncomingConnection(Host host, String requestLine) throws IOException {
        ConnectionEngine engine = new ConnectionEngine(host);
        engine.initializeIncomingConnection(requestLine);
        engine.processIncomingData();
    }

    public FavoritesContainer getFavoritesContainer() {
        return this.favoritesContainer;
    }

    public CaughtHostsContainer getCaughtHostsContainer() {
        return this.caughtHostsContainer;
    }

    public NetworkHostsContainer getNetworkHostsContainer() {
        return this.networkHostsContainer;
    }

    public boolean isShieldedLeafNode() {
        return this.networkHostsContainer.isShieldedLeafNode();
    }

    public boolean isAbleToBecomeUltrapeer() {
        if (this.isUltrapeer()) {
            return true;
        }
        return !this.isShieldedLeafNode() && ServiceManager.sCfg.allowToBecomeUP && this.upChecker.isUltrapeerCapable();
    }

    public boolean isUltrapeer() {
        return ServiceManager.sCfg.allowToBecomeUP && ServiceManager.sCfg.forceToBeUltrapeer || this.networkHostsContainer.hasLeafConnections();
    }

    public boolean areIncommingSlotsAdvertised() {
        if (this.networkHostsContainer.isShieldedLeafNode()) {
            return false;
        }
        return this.networkHostsContainer.hasPeerSlotsAvailable() || this.networkHostsContainer.hasUltrapeerSlotsAvailable() || this.networkHostsContainer.hasLeafSlotsAvailable();
    }

    public boolean isAbleToBecomeLeafNode() {
        if (!ServiceManager.sCfg.allowToBecomeLeaf) {
            return false;
        }
        return !this.isAbleToBecomeUltrapeer() || !this.networkHostsContainer.hasLeafConnections() && !this.networkHostsContainer.hasUltrapeerConnections();
    }

    public void addConnectedHost(Host host) {
        this.networkHostsContainer.addConnectedHost(host);
    }

    public void disconnectHost(Host host) {
        this.networkHostsContainer.disconnectHost(host);
    }

    public void addIncomingHost(Host host) {
        this.networkHostsContainer.addIncomingHost(host);
    }

    public void removeAllNetworkHosts() {
        this.networkHostsContainer.removeAllNetworkHosts();
    }

    public void removeNetworkHosts(Host[] hosts) {
        this.networkHostsContainer.removeNetworkHosts(hosts);
    }

    public void removeNetworkHost(Host host) {
        this.networkHostsContainer.removeNetworkHost(host);
    }

    public void addNetworkHostsChangeListener(NetworkHostsChangeListener listener) {
        this.networkHostsContainer.addNetworkHostsChangeListener(listener);
    }

    public void removeNetworkHostsChangeListener(NetworkHostsChangeListener listener) {
        this.networkHostsContainer.removeNetworkHostsChangeListener(listener);
    }

    public void doAutoConnectCheck() {
        int requiredHostCount;
        int hostCount;
        if (!this.networkMgr.isNetworkJoined() || !this.networkMgr.isConnected()) {
            return;
        }
        if (this.isAbleToBecomeUltrapeer()) {
            hostCount = this.networkHostsContainer.getUltrapeerConnectionCount();
            requiredHostCount = ServiceManager.sCfg.up2upConnections;
        } else if (this.isShieldedLeafNode() || ServiceManager.sCfg.allowToBecomeLeaf) {
            hostCount = this.networkHostsContainer.getUltrapeerConnectionCount();
            requiredHostCount = ServiceManager.sCfg.leaf2upConnections;
        } else {
            hostCount = this.networkHostsContainer.getTotalConnectionCount();
            requiredHostCount = ServiceManager.sCfg.peerConnections;
        }
        int missingCount = (requiredHostCount - hostCount) * 4;
        int allHostCount = this.networkHostsContainer.getNetworkHostCount();
        int errorHostCount = this.networkHostsContainer.getNetworkHostCount(1);
        int currentTryCount = Math.max(0, allHostCount - hostCount - errorHostCount);
        int upperLimit = Math.min(20, ServiceManager.sCfg.maxConcurrentConnectAttempts) - currentTryCount;
        int outConnectCount = Math.min(missingCount - currentTryCount, upperLimit);
        if (outConnectCount > 0) {
            NLogger.debug(HostManager.class, (Object)("Auto-connect to " + outConnectCount + " new hosts."));
            this.networkHostsContainer.createOutConnectionToNextHosts(outConnectCount);
        }
    }

    private class HostCheckTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 2000L;

        private HostCheckTimer() {
        }

        public void run() {
            try {
                HostManager.this.doAutoConnectCheck();
                HostManager.this.networkHostsContainer.periodicallyCheckHosts();
            }
            catch (Throwable th) {
                NLogger.error("GLOBAL", (Object)th, th);
            }
        }
    }

    private static class Holder {
        protected static final HostManager manager = new HostManager();

        private Holder() {
        }
    }
}

