/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.connection.OutgoingConnectionDispatcher;
import phex.event.AsynchronousDispatcher;
import phex.event.NetworkHostsChangeListener;
import phex.event.NetworkListener;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.MsgManager;
import phex.udp.UdpConnectionManager;
import phex.utils.Localizer;
import phex.utils.NLogger;

public final class NetworkHostsContainer
implements NetworkListener {
    private HostManager hostMgr;
    private ArrayList networkHosts;
    private ArrayList peerConnections;
    private ArrayList ultrapeerConnections;
    private int leafUltrapeerConnectionCount;
    private ArrayList leafConnections;
    private ArrayList listenerList = new ArrayList(3);

    public NetworkHostsContainer() {
        this.networkHosts = new ArrayList();
        this.peerConnections = new ArrayList();
        this.ultrapeerConnections = new ArrayList();
        this.leafConnections = new ArrayList();
        this.hostMgr = HostManager.getInstance();
    }

    public synchronized boolean isShieldedLeafNode() {
        return this.leafUltrapeerConnectionCount > 0;
    }

    public synchronized boolean hasLeafConnections() {
        return !this.leafConnections.isEmpty();
    }

    public synchronized boolean hasUltrapeerConnections() {
        return !this.ultrapeerConnections.isEmpty();
    }

    public boolean hasPeerSlotsAvailable() {
        if (this.hostMgr.isUltrapeer()) {
            return this.peerConnections.size() < ServiceManager.sCfg.up2peerConnections;
        }
        if (this.isShieldedLeafNode()) {
            return this.peerConnections.size() < ServiceManager.sCfg.leaf2peerConnections;
        }
        return this.peerConnections.size() < ServiceManager.sCfg.peerConnections;
    }

    public boolean hasUltrapeerSlotsAvailable() {
        return this.ultrapeerConnections.size() < ServiceManager.sCfg.up2upConnections;
    }

    public int getOpenUltrapeerSlotsCount() {
        return ServiceManager.sCfg.up2upConnections - this.ultrapeerConnections.size();
    }

    public boolean hasLeafSlotForUltrapeerAvailable() {
        return this.hasLeafSlotsAvailable() && this.ultrapeerConnections.size() < ServiceManager.sCfg.up2upConnections + 1;
    }

    public boolean hasLeafSlotsAvailable() {
        return this.leafConnections.size() < ServiceManager.sCfg.up2leafConnections;
    }

    public int getOpenLeafSlotsCount() {
        if (this.hostMgr.isUltrapeer()) {
            return ServiceManager.sCfg.up2leafConnections - this.leafConnections.size();
        }
        return 0;
    }

    public synchronized Host[] getUltrapeerConnections() {
        Host[] hosts = new Host[this.ultrapeerConnections.size()];
        this.ultrapeerConnections.toArray(hosts);
        return hosts;
    }

    public synchronized Host[] getLeafConnections() {
        Host[] hosts = new Host[this.leafConnections.size()];
        this.leafConnections.toArray(hosts);
        return hosts;
    }

    public synchronized Host[] getPeerConnections() {
        Host[] hosts = new Host[this.peerConnections.size()];
        this.peerConnections.toArray(hosts);
        return hosts;
    }

    public synchronized int getTotalConnectionCount() {
        return this.ultrapeerConnections.size() + this.leafConnections.size() + this.peerConnections.size();
    }

    public int getLeafConnectionCount() {
        return this.leafConnections.size();
    }

    public synchronized int getUltrapeerConnectionCount() {
        return this.ultrapeerConnections.size();
    }

    public DestAddress[] getPushProxies() {
        if (this.isShieldedLeafNode()) {
            Iterator iterator = this.ultrapeerConnections.iterator();
            HashSet<DestAddress> pushProxies = new HashSet<DestAddress>();
            while (iterator.hasNext() && pushProxies.size() != 4) {
                Host host = (Host)iterator.next();
                DestAddress pushProxyAddress = host.getPushProxyAddress();
                if (pushProxyAddress == null) continue;
                pushProxies.add(pushProxyAddress);
            }
            DestAddress[] addresses = new DestAddress[pushProxies.size()];
            pushProxies.toArray(addresses);
            return addresses;
        }
        return null;
    }

    public synchronized void addConnectedHost(Host host) {
        if (!this.networkHosts.contains(host)) {
            this.disconnectHost(host);
            return;
        }
        if (host.isUltrapeer()) {
            this.ultrapeerConnections.add(host);
            if (host.isLeafUltrapeerConnection()) {
                ++this.leafUltrapeerConnectionCount;
            }
        } else if (host.isUltrapeerLeafConnection()) {
            this.leafConnections.add(host);
        } else {
            this.peerConnections.add(host);
        }
    }

    public synchronized void disconnectHost(Host host) {
        if (host == null) {
            return;
        }
        if (host.isUltrapeer()) {
            boolean isRemoved = this.ultrapeerConnections.remove(host);
            if (isRemoved && host.isLeafUltrapeerConnection()) {
                --this.leafUltrapeerConnectionCount;
            }
        } else if (host.isUltrapeerLeafConnection()) {
            this.leafConnections.remove(host);
        } else {
            this.peerConnections.remove(host);
        }
        host.disconnect();
        MsgManager.getInstance().removeHost(host);
        this.fireNetworkHostChanged(host);
    }

    public synchronized void periodicallyCheckHosts() {
        long currentTime = System.currentTimeMillis();
        Host[] badHosts = new Host[this.networkHosts.size()];
        int badHostsPos = 0;
        Iterator iterator = this.networkHosts.iterator();
        while (iterator.hasNext()) {
            Host host = (Host)iterator.next();
            int status = host.getStatus();
            if (status == 4) {
                host.checkForStableConnection(currentTime);
                if (ServiceManager.sCfg.mDisconnectApplyPolicy) {
                    String policyInfraction = null;
                    if (host.tooManyDropPackets()) {
                        policyInfraction = Localizer.getString("TooManyDroppedPackets");
                    } else if (host.isSendQueueTooLong()) {
                        policyInfraction = Localizer.getString("SendQueueTooLong");
                    } else if (host.isNoVendorDisconnectApplying()) {
                        policyInfraction = Localizer.getString("NoVendorString");
                    } else if (host.isFreeloader(currentTime)) {
                        policyInfraction = Localizer.getString("FreeloaderNotSharing");
                    }
                    if (policyInfraction != null) {
                        host.setStatus(1, policyInfraction, currentTime);
                        this.disconnectHost(host);
                    }
                }
            }
            if (!ServiceManager.sCfg.mAutoCleanup || status == 4 || status == 2 || status == 3 || !host.isErrorStatusExpired(currentTime)) continue;
            badHosts[badHostsPos] = host;
            ++badHostsPos;
        }
        if (badHostsPos > 0) {
            this.removeNetworkHosts(badHosts);
        }
    }

    public synchronized Host getNetworkHostAt(int index) {
        if (index < 0 || index >= this.networkHosts.size()) {
            return null;
        }
        return (Host)this.networkHosts.get(index);
    }

    public synchronized Host[] getNetworkHostsAt(int[] indices) {
        int length = indices.length;
        Host[] hosts = new Host[length];
        for (int i = 0; i < length; ++i) {
            hosts[i] = (Host)this.networkHosts.get(indices[i]);
        }
        return hosts;
    }

    public synchronized Host getNetworkHost(DestAddress address) {
        Iterator i = this.networkHosts.iterator();
        while (i.hasNext()) {
            Host networkHost = (Host)i.next();
            DestAddress networkAddress = networkHost.getHostAddress();
            if (!networkAddress.equals(address)) continue;
            return networkHost;
        }
        return null;
    }

    public synchronized int getNetworkHostCount() {
        return this.networkHosts.size();
    }

    public synchronized int getNetworkHostCount(int status) {
        int count = 0;
        Iterator iterator = this.networkHosts.iterator();
        while (iterator.hasNext()) {
            Host host = (Host)iterator.next();
            if (host.getStatus() != status) continue;
            ++count;
        }
        return count;
    }

    public synchronized void addNetworkHost(Host host) {
        int position = this.networkHosts.size();
        this.networkHosts.add(host);
        this.fireNetworkHostAdded(position);
        try {
            UdpConnectionManager.getInstance().sendUdpPing(host.getHostAddress());
        }
        catch (IOException e) {
            NLogger.warn("UDP_OUTGOING_MESSAGES", (Object)(" could  not send udp ping to : " + host), (Throwable)e);
        }
    }

    public synchronized boolean isConnectedToHost(DestAddress address) {
        for (int i = 0; i < this.networkHosts.size(); ++i) {
            Host host = (Host)this.networkHosts.get(i);
            if (!host.getHostAddress().equals(address)) continue;
            return true;
        }
        return false;
    }

    public synchronized void createOutgoingConnectionToHost(DestAddress address) {
        OutgoingConnectionDispatcher dispatcher = new OutgoingConnectionDispatcher();
        dispatcher.setHostAddressToConnect(address);
        ThreadPool.getInstance().addJob(dispatcher, "OutgoingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
    }

    public synchronized void createOutConnectionToNextHosts(int count) {
        for (int i = 0; i < count; ++i) {
            OutgoingConnectionDispatcher dispatcher = new OutgoingConnectionDispatcher();
            ThreadPool.getInstance().addJob(dispatcher, "OutgoingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
        }
    }

    public synchronized void addIncomingHost(Host host) {
        this.addNetworkHost(host);
        this.addConnectedHost(host);
    }

    public synchronized void removeAllNetworkHosts() {
        while (this.networkHosts.size() > 0) {
            Host host = (Host)this.networkHosts.get(0);
            this.internalRemoveNetworkHost(host);
        }
    }

    public synchronized void removeNetworkHosts(Host[] hosts) {
        int length = hosts.length;
        for (int i = 0; i < length; ++i) {
            Host host = hosts[i];
            this.internalRemoveNetworkHost(host);
        }
    }

    public synchronized void removeNetworkHost(Host host) {
        this.internalRemoveNetworkHost(host);
    }

    private synchronized void internalRemoveNetworkHost(Host host) {
        if (host == null) {
            return;
        }
        this.disconnectHost(host);
        int position = this.networkHosts.indexOf(host);
        if (position >= 0) {
            this.networkHosts.remove(position);
            this.fireNetworkHostRemoved(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkHostsChangeListener(NetworkHostsChangeListener listener) {
        ArrayList arrayList = this.listenerList;
        synchronized (arrayList) {
            this.listenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetworkHostsChangeListener(NetworkHostsChangeListener listener) {
        ArrayList arrayList = this.listenerList;
        synchronized (arrayList) {
            this.listenerList.remove(listener);
        }
    }

    private void fireNetworkHostChanged(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = NetworkHostsContainer.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    NetworkHostsChangeListener listener = (NetworkHostsChangeListener)listeners[i];
                    listener.networkHostChanged(position);
                }
            }
        });
    }

    private void fireNetworkHostAdded(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = NetworkHostsContainer.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    NetworkHostsChangeListener listener = (NetworkHostsChangeListener)listeners[i];
                    listener.networkHostAdded(position);
                }
            }
        });
    }

    private void fireNetworkHostRemoved(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                try {
                    Object[] listeners = NetworkHostsContainer.this.listenerList.toArray();
                    for (int i = listeners.length - 1; i >= 0; --i) {
                        NetworkHostsChangeListener listener = (NetworkHostsChangeListener)listeners[i];
                        listener.networkHostRemoved(position);
                    }
                }
                catch (Throwable th) {
                    NLogger.error("GLOBAL", (Object)th, th);
                }
            }
        });
    }

    public void fireNetworkHostChanged(Host host) {
        int position = this.networkHosts.indexOf(host);
        if (position >= 0) {
            this.fireNetworkHostChanged(position);
        }
    }

    public void connectedToNetwork() {
    }

    public void disconnectedFromNetwork() {
        this.removeAllNetworkHosts();
    }

    public void networkIPChanged(DestAddress hostAddress) {
    }
}

