/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.map.LinkedMap;
import phex.common.Environment;
import phex.http.HTTPHeader;
import phex.utils.NLogger;

public class HTTPHeaderGroup {
    public static final HTTPHeader[] EMPTY_HTTPHEADER_ARRAY = new HTTPHeader[0];
    public static HTTPHeaderGroup EMPTY_HEADERGROUP;
    public static String COLON_SEPARATOR;
    public static HTTPHeaderGroup COMMON_HANDSHAKE_GROUP;
    public static HTTPHeaderGroup ACCEPT_HANDSHAKE_GROUP;
    protected Map headerFields;
    protected boolean lenient;

    public HTTPHeaderGroup(boolean lenient) {
        this.lenient = lenient;
        this.headerFields = new LinkedMap();
    }

    public HTTPHeaderGroup(HTTPHeaderGroup headers) {
        this.headerFields = new LinkedMap(headers.headerFields);
        this.lenient = headers.lenient;
    }

    public HTTPHeaderGroup(int size, boolean lenient) {
        this.lenient = lenient;
        this.headerFields = new LinkedMap(size);
    }

    private HTTPHeaderGroup() {
    }

    public void addHeader(HTTPHeader header) {
        String name = this.lenient ? header.getName().toLowerCase() : header.getName();
        ArrayList<HTTPHeader> values = (ArrayList<HTTPHeader>)this.headerFields.get(name);
        if (values == null) {
            values = new ArrayList<HTTPHeader>();
            this.headerFields.put(name, values);
        }
        values.add(header);
    }

    public void addHeaders(HTTPHeader[] headers) {
        for (int i = 0; i < headers.length; ++i) {
            String name = this.lenient ? headers[i].getName().toLowerCase() : headers[i].getName();
            ArrayList<HTTPHeader> values = (ArrayList<HTTPHeader>)this.headerFields.get(name);
            if (values == null) {
                values = new ArrayList<HTTPHeader>();
                this.headerFields.put(name, values);
            }
            values.add(headers[i]);
        }
    }

    public void replaceHeaders(HTTPHeaderGroup headers) {
        if (this.lenient == headers.lenient) {
            this.headerFields.putAll(headers.headerFields);
        } else {
            Iterator iterator = headers.headerFields.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                ArrayList values = (ArrayList)this.headerFields.get(key);
                String name = ((HTTPHeader)values.get(0)).getName();
                if (this.lenient) {
                    name = name.toLowerCase();
                }
                this.headerFields.put(name, values);
            }
        }
    }

    public HTTPHeader getHeader(String name) {
        if (this.lenient) {
            name = name.toLowerCase();
        }
        ArrayList values = null;
        values = (ArrayList)this.headerFields.get(name);
        if (values != null) {
            return (HTTPHeader)values.get(0);
        }
        return null;
    }

    public HTTPHeader[] getHeaders(String name) {
        if (this.lenient) {
            name = name.toLowerCase();
        }
        ArrayList values = null;
        values = (ArrayList)this.headerFields.get(name);
        if (values == null) {
            return EMPTY_HTTPHEADER_ARRAY;
        }
        HTTPHeader[] results = new HTTPHeader[values.size()];
        return values.toArray(results);
    }

    public boolean isHeaderValueEqual(String name, String compareValue) {
        HTTPHeader header = this.getHeader(name);
        if (header == null) {
            return false;
        }
        String value = header.getValue();
        return compareValue.equalsIgnoreCase(value);
    }

    public boolean isHeaderValueContaining(String name, String compareValue) {
        HTTPHeader header = this.getHeader(name);
        if (header == null) {
            return false;
        }
        String value = header.getValue();
        if (value == null) {
            return false;
        }
        if (compareValue.equalsIgnoreCase(value)) {
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!compareValue.equalsIgnoreCase(token)) continue;
            return true;
        }
        return false;
    }

    public byte getByteHeaderValue(String name, byte defaultValue) {
        HTTPHeader header = this.getHeader(name);
        if (header == null) {
            return defaultValue;
        }
        try {
            byte value = header.byteValue();
            return value;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int getIntHeaderValue(String name, int defaultValue) {
        HTTPHeader header = this.getHeader(name);
        if (header == null) {
            return defaultValue;
        }
        try {
            int value = header.intValue();
            return value;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String buildHTTPHeaderString() {
        StringBuffer buffer = new StringBuffer(30 * this.headerFields.size());
        Iterator iterator = this.headerFields.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ArrayList values = (ArrayList)this.headerFields.get(key);
            Iterator items = values.iterator();
            while (items.hasNext()) {
                HTTPHeader header = (HTTPHeader)items.next();
                buffer.append(header.getName());
                buffer.append(COLON_SEPARATOR);
                buffer.append(header.getValue());
                buffer.append("\r\n");
            }
        }
        return buffer.toString();
    }

    public static HTTPHeaderGroup createDefaultRequestHeaders() {
        HTTPHeaderGroup headers = new HTTPHeaderGroup(false);
        headers.addHeader(new HTTPHeader("User-Agent", Environment.getPhexVendor()));
        return headers;
    }

    public static HTTPHeaderGroup createDefaultResponseHeaders() {
        HTTPHeaderGroup headers = new HTTPHeaderGroup(false);
        headers.addHeader(new HTTPHeader("Server", Environment.getPhexVendor()));
        return headers;
    }

    static {
        COLON_SEPARATOR = ": ";
        try {
            EMPTY_HEADERGROUP = new EmptyHTTPHeaders();
            COMMON_HANDSHAKE_GROUP = new HTTPHeaderGroup(false);
            COMMON_HANDSHAKE_GROUP.addHeader(new HTTPHeader("User-Agent", Environment.getPhexVendor()));
            ACCEPT_HANDSHAKE_GROUP = new HTTPHeaderGroup(COMMON_HANDSHAKE_GROUP);
            ACCEPT_HANDSHAKE_GROUP.addHeader(new HTTPHeader("GGEP", "0.5"));
            ACCEPT_HANDSHAKE_GROUP.addHeader(new HTTPHeader("Vendor-Message", "0.1"));
            ACCEPT_HANDSHAKE_GROUP.addHeader(new HTTPHeader("X-Requeries", "false"));
            ACCEPT_HANDSHAKE_GROUP.addHeader(new HTTPHeader("Pong-Caching", "0.1"));
        }
        catch (Exception exp) {
            NLogger.error("GLOBAL", (Object)exp, (Throwable)exp);
        }
    }

    private static class EmptyHTTPHeaders
    extends HTTPHeaderGroup {
        EmptyHTTPHeaders() {
            this.headerFields = Collections.EMPTY_MAP;
            this.lenient = false;
        }

        public void addHeader(HTTPHeader header) {
            throw new UnsupportedOperationException("Modification of empty http headers not allowed");
        }

        public void addHeaders(HTTPHeader[] headers) {
            throw new UnsupportedOperationException("Modification of empty http headers not allowed");
        }

        public HTTPHeader getHeader(String name) {
            return null;
        }

        public HTTPHeader[] getHeaders(String name) {
            return EMPTY_HTTPHEADER_ARRAY;
        }

        public String buildHTTPHeaderString() {
            return "";
        }
    }
}

