/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import phex.http.GnutellaRequest;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;

public class HTTPRequest {
    public static final String GET_REQUEST = "GET";
    public static final String HEAD_REQUEST = "HEAD";
    public static final String HTTP_11 = "HTTP/1.1";
    public static final String CRLF = "\r\n";
    private static final char SP = ' ';
    private String requestMethod;
    private String requestURI;
    private String httpVersion;
    private GnutellaRequest gnutellaRequest;
    private boolean isGnutellaRequestParsed;
    private int contentLength;
    private String hostName;
    private int hostPort;
    private HTTPHeaderGroup httpHeaders;

    public HTTPRequest(String aRequestMethod, String aRequestURI, boolean isOutgoing) {
        this(aRequestMethod, aRequestURI, HTTP_11, isOutgoing);
    }

    public HTTPRequest(String aRequestMethod, String aRequestURI, String aHttpVersion, boolean isOutgoing) {
        this.requestMethod = aRequestMethod;
        this.requestURI = aRequestURI;
        this.httpVersion = aHttpVersion;
        this.httpHeaders = isOutgoing ? HTTPHeaderGroup.createDefaultRequestHeaders() : new HTTPHeaderGroup(true);
        this.isGnutellaRequestParsed = false;
    }

    public void setContentLength(int length, boolean addHeader) {
        this.contentLength = length;
        if (addHeader) {
            this.httpHeaders.addHeader(new HTTPHeader("Content-Length", String.valueOf(length)));
        }
    }

    public void setHost(String server, int port, boolean addHeader) {
        this.hostName = server;
        this.hostPort = port;
        if (addHeader) {
            int bufLength = this.hostName.length() + 5;
            StringBuffer buffer = new StringBuffer(bufLength);
            buffer.append(this.hostName);
            if (this.hostPort > 0) {
                buffer.append(':');
                buffer.append(String.valueOf(this.hostPort));
            }
            this.httpHeaders.addHeader(new HTTPHeader("Host", buffer.toString()));
        }
    }

    public void addHeader(HTTPHeader header) {
        this.httpHeaders.addHeader(header);
    }

    public void addHeaders(HTTPHeader[] headers) {
        this.httpHeaders.addHeaders(headers);
    }

    public HTTPHeader getHeader(String name) {
        return this.httpHeaders.getHeader(name);
    }

    public HTTPHeader[] getHeaders(String name) {
        return this.httpHeaders.getHeaders(name);
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public boolean isHeadRequest() {
        return HEAD_REQUEST.equals(this.requestMethod);
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getHTTPVersion() {
        return this.httpVersion;
    }

    public GnutellaRequest getGnutellaRequest() {
        if (!this.isGnutellaRequestParsed) {
            this.gnutellaRequest = GnutellaRequest.parseGnutellaRequest(this.requestURI);
            this.isGnutellaRequestParsed = true;
        }
        return this.gnutellaRequest;
    }

    public boolean isGnutellaRequest() {
        if (!this.isGnutellaRequestParsed) {
            this.gnutellaRequest = GnutellaRequest.parseGnutellaRequest(this.requestURI);
            this.isGnutellaRequestParsed = true;
        }
        return this.gnutellaRequest != null;
    }

    public String buildHTTPRequestString() {
        return this.requestMethod + ' ' + this.requestURI + ' ' + this.httpVersion + CRLF + this.httpHeaders.buildHTTPHeaderString() + CRLF;
    }
}

