/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import phex.common.IntObj;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.address.MalformedDestAddressException;
import phex.connection.NetworkManager;
import phex.host.CaughtHost;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.GGEPBlock;
import phex.msg.GUID;
import phex.msg.InvalidGGEPBlockException;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.PingMsg;
import phex.net.presentation.PresentationManager;
import phex.security.PhexSecurityManager;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticsManager;
import phex.udp.hostcache.UdpHostCache;
import phex.udp.hostcache.UdpHostCacheManager;
import phex.utils.GnutellaOutputStream;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.NLogger;
import phex.utils.VersionUtils;

public class PongMsg
extends Message {
    private static final int MIN_PONG_DATA_LEN = 14;
    private static final byte[] GGEP_VENDOR_CODE = new byte[5];
    private byte[] body;
    private int port;
    private byte[] ip;
    private long fileCount;
    private long fileSizeInKB;
    private int avgDailyUptime;
    private boolean isUltrapeer;
    private GGEPBlock ggepBlock;
    private Set ippDestAddresses;
    private Set udpHostCaches;
    private UdpHostCache udpHostCache;

    public PongMsg(MsgHeader aHeader, byte[] payload) {
        super(aHeader);
        this.getHeader().setPayloadType((byte)1);
        this.body = payload;
        this.getHeader().setDataLength(this.body.length);
        this.avgDailyUptime = -1;
        this.parseBody();
    }

    private PongMsg(MsgHeader header, byte[] ip, int port, int fileCount, int fileSizeInKB, boolean isUltrapeer, GGEPBlock ggepBlock) {
        super(header);
        this.getHeader().setPayloadType((byte)1);
        if (ip.length != 4) {
            throw new IllegalArgumentException("Can't accept ip that is not 4 bytes in length: " + ip.length);
        }
        this.ip = ip;
        this.port = port;
        this.fileCount = fileCount;
        this.isUltrapeer = isUltrapeer;
        this.ggepBlock = ggepBlock;
        this.fileSizeInKB = isUltrapeer ? (long)PongMsg.createUltrapeerMarking(fileSizeInKB) : (long)fileSizeInKB;
        this.buildBody();
        this.getHeader().setDataLength(this.body.length);
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getIP() {
        return this.ip;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public long getFileSizeInKB() {
        return this.fileSizeInKB;
    }

    public int getDailyUptime() {
        return this.avgDailyUptime;
    }

    public boolean hasFreeLeafSlots() {
        if (!this.ggepBlock.isExtensionAvailable("UP")) {
            return false;
        }
        byte[] data = this.ggepBlock.getExtensionData("UP");
        return data != null && data.length >= 3 && data[1] > 0;
    }

    public boolean hasFreeUPSlots() {
        if (!this.ggepBlock.isExtensionAvailable("UP")) {
            return false;
        }
        byte[] data = this.ggepBlock.getExtensionData("UP");
        return data != null && data.length >= 3 && data[2] > 0;
    }

    public Set getIPPDestAddresses() {
        return this.ippDestAddresses;
    }

    public Set getUdpHostCaches() {
        return this.udpHostCaches;
    }

    public UdpHostCache getUdpHostCache() {
        return this.udpHostCache;
    }

    public void writeMessage(GnutellaOutputStream outStream) throws IOException {
        this.getHeader().writeHeader(outStream);
        outStream.write(this.body, 0, this.body.length);
    }

    public byte[] getbytes() {
        byte[] data = new byte[23 + this.body.length];
        byte[] hdr = this.getHeader().getBytes();
        System.arraycopy(hdr, 0, data, 0, 23);
        System.arraycopy(this.body, 0, data, 23, this.body.length);
        return data;
    }

    public String getDebugString() {
        return "Pong[ IP=" + AddressUtils.ip2string(this.ip) + ", Port=" + this.port + ", FileCount=" + this.fileCount + ", FileSize=" + this.fileSizeInKB + ", AvgUptime=" + this.avgDailyUptime + ", HEX=[" + HexConverter.toHexString(this.body) + "] ]";
    }

    private void buildBody() {
        int extensionLength;
        byte[] ggepExtension;
        if (this.ggepBlock != null) {
            try {
                ggepExtension = this.ggepBlock.getBytes();
                extensionLength = ggepExtension.length;
            }
            catch (IOException exp) {
                NLogger.error("MESSAGE_ENCODE_DECODE", (Object)exp, (Throwable)exp);
                extensionLength = 0;
                ggepExtension = null;
            }
        } else {
            ggepExtension = null;
            extensionLength = 0;
        }
        this.body = new byte[14 + extensionLength];
        IOUtil.serializeShortLE((short)this.port, this.body, 0);
        System.arraycopy(this.ip, 0, this.body, 2, 4);
        IOUtil.serializeIntLE((int)this.fileCount, this.body, 6);
        IOUtil.serializeIntLE((int)this.fileSizeInKB, this.body, 10);
        if (ggepExtension != null) {
            System.arraycopy(ggepExtension, 0, this.body, 14, extensionLength);
        }
    }

    private void parseBody() {
        this.port = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(this.body, 0));
        this.ip = new byte[4];
        this.ip[0] = this.body[2];
        this.ip[1] = this.body[3];
        this.ip[2] = this.body[4];
        this.ip[3] = this.body[5];
        this.fileCount = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, 6));
        this.fileSizeInKB = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, 10));
        if (this.body.length <= 14) {
            return;
        }
        this.parseGGEPBlocks();
    }

    private void parseGGEPBlocks() {
        byte[] data;
        try {
            this.ggepBlock = GGEPBlock.mergeGGEPBlocks(GGEPBlock.parseGGEPBlocks(this.body, 14));
        }
        catch (InvalidGGEPBlockException exp) {
            NLogger.warn("MESSAGE_ENCODE_DECODE", (Object)exp);
            return;
        }
        if (this.ggepBlock.isExtensionAvailable("DU") && (data = this.ggepBlock.getExtensionData("DU")) != null) {
            try {
                this.avgDailyUptime = IOUtil.deserializeIntLE(data, 0, data.length);
            }
            catch (NumberFormatException exp) {
                NLogger.warn("MESSAGE_ENCODE_DECODE", (Object)("Invalid average uptime GGEP extension data: " + HexConverter.toHexString(data)), (Throwable)exp);
                this.avgDailyUptime = -1;
            }
            catch (IllegalArgumentException exp) {
                NLogger.warn("MESSAGE_ENCODE_DECODE", (Object)("Invalid average uptime GGEP extension data: " + HexConverter.toHexString(data)));
                this.avgDailyUptime = -1;
            }
        }
        if (this.ggepBlock.isExtensionAvailable("IPP") && (data = this.ggepBlock.getExtensionData("IPP")) != null) {
            this.ippDestAddresses = PongMsg.unpackIpPortData(data);
        }
        if (this.ggepBlock.isExtensionAvailable("PHC") && (data = this.ggepBlock.getExtensionData("PHC")) != null) {
            String packedData = new String(data);
            this.udpHostCaches = this.parsePackedHostCache(packedData);
        }
        if (this.ggepBlock.isExtensionAvailable("UDPHC")) {
            data = this.ggepBlock.getExtensionData("UDPHC");
            try {
                DefaultDestAddress address = data != null && data.length > 0 ? new DefaultDestAddress(new String(data), this.port) : new DefaultDestAddress(this.ip, this.port);
                byte access = PhexSecurityManager.getInstance().controlHostAddressAccess(address);
                if (access == 1) {
                    this.udpHostCache = new UdpHostCache(address);
                }
            }
            catch (IllegalArgumentException e) {
                NLogger.warn("UDP_HOST_CACHE", (Object)("INVALID Udp Host Cache found and ignored " + e));
            }
        }
    }

    private Set parsePackedHostCache(String packedHostCaches) {
        PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
        PresentationManager netPresMgr = PresentationManager.getInstance();
        String[] hostCaches = packedHostCaches.split("\n");
        HashSet<UdpHostCache> packedUdpHostCaches = new HashSet<UdpHostCache>(hostCaches.length);
        for (int i = 0; i < hostCaches.length; ++i) {
            int pos = hostCaches[i].indexOf("&");
            try {
                DestAddress address;
                if (pos == -1) {
                    address = netPresMgr.createHostAddress(hostCaches[i], 6346);
                } else {
                    String temp = hostCaches[i].substring(0, pos);
                    address = netPresMgr.createHostAddress(temp, 6346);
                }
                byte access = securityMgr.controlHostAddressAccess(address);
                if (access != 1) continue;
                UdpHostCache cache = new UdpHostCache(address);
                packedUdpHostCaches.add(cache);
                continue;
            }
            catch (MalformedDestAddressException e) {
                NLogger.warn("UDP_HOST_CACHE", (Object)(" Ignored One Host Cache address in a packed host cache list  " + e));
            }
        }
        return packedUdpHostCaches;
    }

    private static Set unpackIpPortData(byte[] data) {
        HashSet<DefaultDestAddress> ipPortPairs = null;
        try {
            int FIELD_SIZE = 6;
            if (data.length % 6 != 0) {
                throw new InvalidGGEPBlockException("invalid IPPORT EXTENSION DATA IN PONG");
            }
            PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
            int size = data.length / 6;
            ipPortPairs = new HashSet<DefaultDestAddress>();
            for (int i = 0; i < size; ++i) {
                int index = i * 6;
                byte[] ip = new byte[4];
                System.arraycopy(data, index, ip, 0, 4);
                int port = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(data, index + 4));
                byte access = securityMgr.controlHostIPAccess(ip);
                if (access != 1) continue;
                DefaultDestAddress current = new DefaultDestAddress(ip, port);
                ipPortPairs.add(current);
            }
        }
        catch (InvalidGGEPBlockException e) {
            NLogger.warn("MESSAGE_ENCODE_DECODE", (Object)e);
        }
        return ipPortPairs;
    }

    private static byte[] packIpPortData(Collection ipPortCollection) {
        int FIELD_SIZE = 6;
        byte[] data = new byte[ipPortCollection.size() * 6];
        int offset = 0;
        Iterator i = ipPortCollection.iterator();
        while (i.hasNext()) {
            CaughtHost host = (CaughtHost)i.next();
            DestAddress address = host.getHostAddress();
            byte[] addr = address.getIpAddress().getHostIP();
            int port = address.getPort();
            System.arraycopy(addr, 0, data, offset, 4);
            IOUtil.serializeShortLE((short)port, data, offset += 4);
            offset += 2;
        }
        return data;
    }

    public boolean isUltrapeerMarked() {
        if (this.fileSizeInKB < 8L) {
            return false;
        }
        return (this.fileSizeInKB & this.fileSizeInKB - 1L) == 0L;
    }

    public static PongMsg createUdpPongMsg(byte[] bytesMsg, Host fromHost) throws InvalidMessageException {
        MsgHeader msgHdr = MsgHeader.createMsgHeader(bytesMsg, 0);
        return PongMsg.createUdpPongMsg(msgHdr, bytesMsg, 23, fromHost);
    }

    public static PongMsg createUdpPongMsg(MsgHeader msgHdr, byte[] data, int offset, Host fromHost) throws InvalidMessageException {
        if (!MessageProcessor.isValidUdpMsgHeader(msgHdr)) {
            NLogger.warn("UDP_INCOMING_MESSAGES", (Object)(" Could not create udp pong from given byte array. Message Verification failed " + new String(data)));
            throw new InvalidMessageException(" Could not create Msg Header while trying to create udp pong Msg. Message Verification failed ");
        }
        msgHdr.setFromHost(fromHost);
        if (msgHdr.getDataLength() < 14) {
            throw new InvalidMessageException(" Could not create Msg Body while trying to create udp pong Msg");
        }
        byte[] body = MessageProcessor.createBody(msgHdr, data, offset);
        if (body == null) {
            throw new InvalidMessageException(" Could not create Msg Body while trying to create udp pong Msg");
        }
        return new PongMsg(msgHdr, body);
    }

    public static PongMsg createUdpPongMsg(PingMsg ping) {
        StatisticsManager statMgr = StatisticsManager.getInstance();
        NetworkManager networkMgr = NetworkManager.getInstance();
        ShareManager shareMgr = ShareManager.getInstance();
        HostManager hostMgr = HostManager.getInstance();
        SharedFilesService sharedFilesService = shareMgr.getSharedFilesService();
        int fileCount = sharedFilesService.getFileCount();
        int fileSize = sharedFilesService.getTotalFileSizeInKb();
        StatisticProvider uptimeProvider = statMgr.getStatisticProvider("DailyUptimeProvider");
        int avgDailyUptime = ((IntObj)uptimeProvider.getValue()).intValue();
        boolean isUltrapeer = hostMgr.isUltrapeer();
        GGEPBlock ggepBlock = PongMsg.createMyGGEPBlock(avgDailyUptime, isUltrapeer);
        byte[] scpByte = ping.getScpByte();
        Collection ipPortPairs = null;
        CaughtHostsContainer hostContainer = hostMgr.getCaughtHostsContainer();
        switch (scpByte[0] & 1) {
            case 1: {
                ipPortPairs = hostContainer.getFreeUltrapeerSlotHosts();
                break;
            }
            case 0: {
                ipPortPairs = hostContainer.getFreeLeafSlotHosts();
            }
        }
        PongMsg.addUdpPongGGEPExt(ipPortPairs, ggepBlock);
        DestAddress localAddress = networkMgr.getLocalAddress();
        IpAddress ipAddress = localAddress.getIpAddress();
        if (ipAddress == null) {
            throw new IllegalArgumentException("Can't accept null ip.");
        }
        byte[] pongIp = ipAddress.getHostIP();
        short pongPort = (short)localAddress.getPort();
        MsgHeader newHeader = new MsgHeader(ping.getHeader().getMsgID(), 1, 1, 0, 0);
        PongMsg udpPong = new PongMsg(newHeader, pongIp, pongPort, fileCount, fileSize, isUltrapeer, ggepBlock);
        NLogger.info("UDP_OUTGOING_MESSAGES", (Object)("Created udp pong  in response to ping: " + udpPong));
        return udpPong;
    }

    public static PongMsg createMyOutgoingPong(GUID msgId, byte ttl) {
        byte[] pongIp;
        StatisticsManager statMgr = StatisticsManager.getInstance();
        NetworkManager networkMgr = NetworkManager.getInstance();
        ShareManager shareMgr = ShareManager.getInstance();
        HostManager hostMgr = HostManager.getInstance();
        SharedFilesService sharedFilesService = shareMgr.getSharedFilesService();
        int fileCount = sharedFilesService.getFileCount();
        int fileSize = sharedFilesService.getTotalFileSizeInKb();
        StatisticProvider uptimeProvider = statMgr.getStatisticProvider("DailyUptimeProvider");
        int avgDailyUptime = ((IntObj)uptimeProvider.getValue()).intValue();
        boolean isUltrapeer = hostMgr.isUltrapeer();
        GGEPBlock ggepBlock = PongMsg.createMyGGEPBlock(avgDailyUptime, isUltrapeer);
        DestAddress localAddress = networkMgr.getLocalAddress();
        IpAddress localIp = localAddress.getIpAddress();
        if (localIp == null) {
            pongIp = IpAddress.UNSET_IP;
            PongMsg.addPhexExtendedDestinationGGEP(localAddress, ggepBlock);
        } else {
            pongIp = localIp.getHostIP();
        }
        MsgHeader header = new MsgHeader(msgId, 1, ttl, 0, 0);
        PongMsg pong = new PongMsg(header, pongIp, (short)localAddress.getPort(), fileCount, fileSize, isUltrapeer, ggepBlock);
        return pong;
    }

    public static PongMsg createOtherLeafsOutgoingPong(GUID msgId, byte ttl, byte hops, DestAddress address) {
        byte[] pongIp;
        MsgHeader header = new MsgHeader(msgId, 1, ttl, hops, 0);
        GGEPBlock ggepBlock = null;
        IpAddress ip = address.getIpAddress();
        if (ip == null) {
            pongIp = IpAddress.UNSET_IP;
            ggepBlock = new GGEPBlock();
            PongMsg.addPhexExtendedDestinationGGEP(address, ggepBlock);
        } else {
            pongIp = ip.getHostIP();
        }
        PongMsg pong = new PongMsg(header, pongIp, (short)address.getPort(), 0, 0, false, ggepBlock);
        return pong;
    }

    public static PongMsg createFromCachePong(GUID newGuid, byte newTTL, PongMsg pongMsg) {
        MsgHeader header = new MsgHeader(newGuid, 1, newTTL, 0, 0);
        PongMsg pong = new PongMsg(header, pongMsg.body);
        return pong;
    }

    private static GGEPBlock createMyGGEPBlock(int avgDailyUptime, boolean isUltrapeer) {
        GGEPBlock ggepBlock = new GGEPBlock();
        if (avgDailyUptime > 0) {
            ggepBlock.addExtension("DU", avgDailyUptime);
        }
        if (isUltrapeer) {
            byte[] upExtension = new byte[3];
            upExtension[0] = IOUtil.serializeGUESSVersionFormat(VersionUtils.getUltrapeerMajorVersionNumber(), VersionUtils.getUltrapeerMinorVersionNumber());
            NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
            upExtension[1] = (byte)networkHostsContainer.getOpenLeafSlotsCount();
            upExtension[2] = (byte)networkHostsContainer.getOpenUltrapeerSlotsCount();
            ggepBlock.addExtension("UP", upExtension);
        }
        ggepBlock.addExtension("VC", GGEP_VENDOR_CODE);
        return ggepBlock;
    }

    private static void addUdpPongGGEPExt(Collection ipPortPairs, GGEPBlock ggepBlock) {
        String packedCacheString;
        UdpHostCacheManager uhcMgr;
        byte[] ipPortData;
        if (ipPortPairs != null && (ipPortData = PongMsg.packIpPortData(ipPortPairs)).length >= 6) {
            ggepBlock.addExtension("IPP", ipPortData);
        }
        if ((uhcMgr = UdpHostCacheManager.getInstance()).isUdpHostCache()) {
            NetworkManager netMgr = NetworkManager.getInstance();
            DestAddress uhcAddress = netMgr.getLocalAddress();
            byte[] data = uhcAddress.isIpHostName() ? new byte[]{} : uhcAddress.getHostName().getBytes();
            ggepBlock.addExtension("UDPHC", data);
            NLogger.debug("UDP_OUTGOING_MESSAGES", (Object)"UDP HOST CACHE extension added to outgoing pongs");
        }
        if ((packedCacheString = uhcMgr.getUdpHostCacheContainer().createPackedHostCaches()).length() > 0) {
            byte[] data = IOUtil.deflate(packedCacheString.getBytes());
            ggepBlock.addExtension("PHC", data);
            NLogger.debug("UDP_OUTGOING_MESSAGES", (Object)" PACKED HOST CACHE extension added to outgoing pongs ");
        }
    }

    private static void addPhexExtendedDestinationGGEP(DestAddress address, GGEPBlock ggepBlock) {
        ggepBlock.addExtension("PHEX.EXDST", address.getHostName().getBytes());
    }

    private static int createUltrapeerMarking(int kbytes) {
        if (kbytes < 12) {
            return 8;
        }
        int bitCount = IOUtil.determineBitCount(kbytes);
        int power = (int)Math.pow(2.0, bitCount);
        int minBorder = power - power / 4;
        if (kbytes < minBorder) {
            power = (int)Math.pow(2.0, bitCount - 1);
        }
        return power;
    }

    static {
        PongMsg.GGEP_VENDOR_CODE[0] = 80;
        PongMsg.GGEP_VENDOR_CODE[1] = 72;
        PongMsg.GGEP_VENDOR_CODE[2] = 69;
        PongMsg.GGEP_VENDOR_CODE[3] = 88;
        PongMsg.GGEP_VENDOR_CODE[4] = IOUtil.serializeGUESSVersionFormat(VersionUtils.getMajorVersionNumber(), VersionUtils.getMinorVersionNumber());
    }
}

