/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.host.HostManager;
import phex.msg.GGEPBlock;
import phex.msg.GGEPExtension;
import phex.msg.GUID;
import phex.msg.InvalidGGEPBlockException;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.QueryResponseRecord;
import phex.query.QueryConstants;
import phex.upload.UploadManager;
import phex.utils.GnutellaOutputStream;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.NLogger;
import phex.xml.XMLUtils;

public class QueryResponseMsg
extends Message
implements QueryConstants {
    private static final boolean INCLUDE_QHD = true;
    private static final byte PUSH_NEEDED_MASK = 1;
    private static final byte SERVER_BUSY_MASK = 4;
    private static final byte HAS_UPLOADED_MASK = 8;
    private static final byte UPLOAD_SPEED_MASK = 16;
    private static final byte GGEP_MASK = 32;
    private static final byte CHAT_SUPPORTED_MASK = 1;
    private byte[] body;
    private short uniqueResultCount;
    private QueryResponseRecord[] records;
    private long remoteHostSpeed;
    private DestAddress destAddress;
    private GUID remoteClientID;
    private String vendorCode;
    private short pushNeededFlag;
    private short serverBusyFlag;
    private short hasUploadedFlag;
    private short uploadSpeedFlag;
    private boolean isChatSupported;
    private boolean isBrowseHostSupported;
    private DestAddress[] pushProxyAddresses;
    private boolean isParsed;

    public QueryResponseMsg(MsgHeader header, GUID clientID, DestAddress aHostAddress, int speed, QueryResponseRecord[] records) {
        super(header);
        boolean isPushNeeded;
        if (records.length > 255) {
            throw new IllegalArgumentException("A maximum of 255 records can be associated with a single response: " + records.length);
        }
        this.getHeader().setPayloadType((byte)-127);
        this.remoteClientID = clientID;
        this.destAddress = aHostAddress;
        this.remoteHostSpeed = speed;
        this.records = records;
        this.pushProxyAddresses = HostManager.getInstance().getNetworkHostsContainer().getPushProxies();
        if (NetworkManager.getInstance().hasConnectedIncoming()) {
            isPushNeeded = false;
            this.pushNeededFlag = 0;
        } else {
            isPushNeeded = true;
            this.pushNeededFlag = 1;
        }
        boolean isServerBusy = UploadManager.getInstance().isHostBusy();
        try {
            this.buildBody(isPushNeeded, isServerBusy);
        }
        catch (IOException e) {
            NLogger.error("MESSAGE_ENCODE_DECODE", (Object)e, (Throwable)e);
        }
        this.getHeader().setDataLength(this.body.length);
        this.isParsed = true;
    }

    public QueryResponseMsg(MsgHeader header, byte[] aBody) throws InvalidMessageException {
        super(header);
        this.getHeader().setPayloadType((byte)-127);
        this.body = aBody;
        header.setDataLength(this.body.length);
        int port = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(this.body, 1));
        this.destAddress = new DefaultDestAddress(this.getHostIP(), port);
        if (!this.destAddress.isValidAddress()) {
            throw new InvalidMessageException("Invalid address: " + this.destAddress);
        }
        this.isParsed = false;
    }

    private void buildBody(boolean isPushNeeded, boolean isServerBusy) throws IOException {
        ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
        int recordCount = this.records.length;
        bodyStream.write((byte)recordCount);
        IOUtil.serializeShortLE((short)this.destAddress.getPort(), bodyStream);
        byte[] ipAddress = this.destAddress.getIpAddress().getHostIP();
        bodyStream.write(ipAddress);
        IOUtil.serializeIntLE((int)this.remoteHostSpeed, bodyStream);
        for (int i = 0; i < recordCount; ++i) {
            this.records[i].write(bodyStream);
        }
        bodyStream.write(80);
        bodyStream.write(72);
        bodyStream.write(69);
        bodyStream.write(88);
        bodyStream.write(2);
        int isPushNeededByte = 0;
        if (isPushNeeded) {
            isPushNeededByte = 1;
        }
        int isServerBusyByte = 0;
        if (isServerBusy) {
            isServerBusyByte = 4;
        }
        int isGGEPUsedByte = 0;
        if (ServiceManager.sCfg.mShareBrowseDir || this.pushProxyAddresses != null && this.pushProxyAddresses.length > 0) {
            isGGEPUsedByte = 32;
        }
        bodyStream.write((byte)(isPushNeededByte | 4 | 0 | 0x10 | 0x20));
        bodyStream.write((byte)(1 | isServerBusyByte | 0 | 0 | isGGEPUsedByte));
        if (ServiceManager.sCfg.isChatEnabled) {
            bodyStream.write(1);
        } else {
            bodyStream.write(0);
        }
        byte[] ggepBytes = GGEPBlock.getQueryReplyGGEPBlock(ServiceManager.sCfg.mShareBrowseDir, this.pushProxyAddresses);
        if (ggepBytes.length > 0) {
            bodyStream.write(ggepBytes);
        }
        this.remoteClientID.write(bodyStream);
        this.body = bodyStream.toByteArray();
    }

    public short getRecordCount() {
        return (short)IOUtil.unsignedByte2int(this.body[0]);
    }

    public short getUniqueResultCount() {
        this.parseBody();
        return this.uniqueResultCount;
    }

    public byte[] getHostIP() {
        byte[] ip = new byte[]{this.body[3], this.body[4], this.body[5], this.body[6]};
        return ip;
    }

    public DestAddress getDestAddress() {
        return this.destAddress;
    }

    public long getRemoteHostSpeed() {
        this.parseBody();
        return this.remoteHostSpeed;
    }

    public String getVendorCode() {
        this.parseBody();
        return this.vendorCode;
    }

    public short getPushNeededFlag() {
        this.parseBody();
        return this.pushNeededFlag;
    }

    public short getServerBusyFlag() {
        this.parseBody();
        return this.serverBusyFlag;
    }

    public short getHasUploadedFlag() {
        this.parseBody();
        return this.hasUploadedFlag;
    }

    public short getUploadSpeedFlag() {
        this.parseBody();
        return this.uploadSpeedFlag;
    }

    public boolean isChatSupported() {
        this.parseBody();
        return this.isChatSupported;
    }

    public boolean isBrowseHostSupported() {
        this.parseBody();
        return this.isBrowseHostSupported;
    }

    public DestAddress[] getPushProxyAddresses() {
        this.parseBody();
        return this.pushProxyAddresses;
    }

    public GUID getRemoteClientID() {
        if (this.remoteClientID == null) {
            this.parseRemoteClientID();
        }
        return this.remoteClientID;
    }

    public QueryResponseRecord getMsgRecord(int i) {
        this.parseBody();
        return this.records[i];
    }

    public void copy(QueryResponseMsg b) {
        this.getHeader().copy(b.getHeader());
        this.destAddress = b.destAddress;
        this.remoteHostSpeed = b.remoteHostSpeed;
        this.remoteClientID = b.remoteClientID;
        int recordCount = b.records.length;
        this.records = new QueryResponseRecord[recordCount];
        for (int i = 0; i < recordCount; ++i) {
            QueryResponseRecord rec = new QueryResponseRecord();
            rec.copy(b.records[i]);
            this.records[i] = rec;
        }
        this.body = b.body;
    }

    public void writeMessage(GnutellaOutputStream outStream) throws IOException {
        this.getHeader().writeHeader(outStream);
        outStream.write(this.body, 0, this.body.length);
    }

    private void parseBody() {
        int n;
        if (this.isParsed) {
            return;
        }
        int offset = 0;
        int recordCount = (n = this.body[offset++]) < 0 ? 256 + n : n;
        offset += 2;
        offset += 4;
        try {
            long speed;
            this.remoteHostSpeed = speed = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, offset));
            offset += 4;
            this.uniqueResultCount = 0;
            HashSet<URN> uniqueURNs = new HashSet<URN>();
            this.records = new QueryResponseRecord[recordCount];
            for (int i = 0; i < recordCount; ++i) {
                QueryResponseRecord rec = new QueryResponseRecord();
                offset = rec.deserialize(this.body, offset);
                this.records[i] = rec;
                URN urn = rec.getURN();
                if (urn != null) {
                    uniqueURNs.add(urn);
                    continue;
                }
                this.uniqueResultCount = (short)(this.uniqueResultCount + 1);
            }
            this.uniqueResultCount = (short)(this.uniqueResultCount + uniqueURNs.size());
            this.pushNeededFlag = (short)-1;
            this.serverBusyFlag = (short)-1;
            this.hasUploadedFlag = (short)-1;
            this.uploadSpeedFlag = (short)-1;
            this.isBrowseHostSupported = false;
            if (offset <= this.getHeader().getDataLength() - 16 - 4 - 2) {
                int privateDataLength;
                this.vendorCode = new String(this.body, offset, 4, "ISO-8859-1");
                if (!this.isVendorCodeValid(this.vendorCode)) {
                    String hexVendorCode = HexConverter.toHexString(this.body, offset, 4);
                    NLogger.warn(QueryResponseMsg.class, (Object)(this.getHeader().getFromHost() + ": Illegal QHD vendor code found: " + this.vendorCode + " (" + hexVendorCode + "). Body: " + HexConverter.toHexString(this.body)));
                    this.vendorCode = hexVendorCode;
                }
                int openDataLength = IOUtil.unsignedByte2int(this.body[offset += 4]);
                ++offset;
                if (openDataLength > 1) {
                    byte flag1 = this.body[offset];
                    byte flag2 = this.body[offset + 1];
                    if ((flag2 & 1) != 0) {
                        this.pushNeededFlag = (flag1 & 1) != 0 ? (short)1 : 0;
                    }
                    if ((flag1 & 4) != 0) {
                        this.serverBusyFlag = (flag2 & 4) != 0 ? (short)1 : 0;
                    }
                    if ((flag1 & 8) != 0) {
                        this.hasUploadedFlag = (flag2 & 8) != 0 ? (short)1 : 0;
                    }
                    if ((flag1 & 0x10) != 0) {
                        this.uploadSpeedFlag = (flag2 & 0x10) != 0 ? (short)1 : 0;
                    }
                    if ((flag1 & 0x20) != 0 && (flag2 & 0x20) != 0) {
                        int ggepMagicIndex;
                        for (ggepMagicIndex = offset + 2; ggepMagicIndex < this.body.length && this.body[ggepMagicIndex] != -61; ++ggepMagicIndex) {
                        }
                        GGEPBlock[] ggepBlocks = null;
                        try {
                            ggepBlocks = GGEPBlock.parseGGEPBlocks(this.body, ggepMagicIndex);
                            this.isBrowseHostSupported = GGEPBlock.isExtensionHeaderInBlocks(ggepBlocks, "BH");
                            this.pushProxyAddresses = GGEPExtension.parsePushProxyExtensionData(ggepBlocks);
                        }
                        catch (InvalidGGEPBlockException exp) {
                            NLogger.debug(QueryResponseMsg.class, (Object)exp, (Throwable)exp);
                        }
                    }
                }
                if ((privateDataLength = this.body.length - (offset += openDataLength) - 16) > 0 && (this.vendorCode.equals("LIME") || this.vendorCode.equals("RAZA") || this.vendorCode.equals("PHEX"))) {
                    byte flag = this.body[offset];
                    this.isChatSupported = (flag & 1) != 0;
                }
            }
            this.parseRemoteClientID();
            this.isParsed = true;
        }
        catch (UnsupportedEncodingException exp) {
            return;
        }
    }

    private void parseRemoteClientID() {
        if (this.remoteClientID == null) {
            this.remoteClientID = new GUID();
        }
        this.remoteClientID.deserialize(this.body, this.getHeader().getDataLength() - 16);
    }

    private boolean isVendorCodeValid(String vendorCode) {
        if (vendorCode.length() != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (XMLUtils.isXmlChar(vendorCode.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

