/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.udp.hostcache.UdpHostCacheManager;
import phex.utils.NLogger;

public class OnlineObserver {
    private int failedConnections = 0;

    public void markFailedConnection() {
        NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
        if (networkHostsContainer.getTotalConnectionCount() > 0) {
            this.failedConnections = 0;
            return;
        }
        ++this.failedConnections;
        if (NLogger.isDebugEnabled("ONLINE_OBSERVER") && this.failedConnections % 5 == 0) {
            NLogger.debug("ONLINE_OBSERVER", (Object)("Observed " + this.failedConnections + " failed connections."));
        }
        if (this.failedConnections % 20 == 0) {
            NLogger.info("ONLINE_OBSERVER", (Object)"Started a UDP HOST CACHE Query due to increasing failed connections");
            UdpHostCacheManager.getInstance().invokeQueryCachesRequest();
        }
        if (this.failedConnections > ServiceManager.sCfg.offlineConnectionFailureCount) {
            NLogger.debug("ONLINE_OBSERVER", (Object)"Too many connections failed.. disconnecting network.");
            NetworkManager.getInstance().disconnectNetwork();
        }
    }

    public void markSuccessfulConnection() {
        this.failedConnections = 0;
    }
}

