/*
 * Decompiled with CFR 0.152.
 */
package phex.net.connection;

import java.io.IOException;
import phex.common.bandwidth.BandwidthController;
import phex.connection.ConnectionClosedException;
import phex.net.presentation.SocketFacade;
import phex.utils.BandwidthInputStream;
import phex.utils.BandwidthOutputStream;
import phex.utils.GnutellaInputStream;
import phex.utils.GnutellaOutputStream;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class Connection {
    private SocketFacade socket;
    private BandwidthController bandwidthController;
    private BandwidthInputStream bandwidthInputStream;
    private BandwidthOutputStream bandwidthOutputStream;
    private GnutellaInputStream inputStream;
    private GnutellaOutputStream outputStream;

    public Connection(SocketFacade socket, BandwidthController bandwidthController) {
        this.socket = socket;
        this.bandwidthController = bandwidthController;
    }

    public void setBandwidthController(BandwidthController bandwidthController) {
        this.bandwidthController = bandwidthController;
        if (this.bandwidthInputStream != null) {
            this.bandwidthInputStream.setBandwidthController(bandwidthController);
        }
        if (this.bandwidthOutputStream != null) {
            this.bandwidthOutputStream.setBandwidthController(bandwidthController);
        }
    }

    public SocketFacade getSocket() {
        return this.socket;
    }

    public GnutellaInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            if (this.socket == null) {
                throw new ConnectionClosedException("Connection already closed");
            }
            this.bandwidthInputStream = new BandwidthInputStream(this.socket.getInputStream(), this.bandwidthController);
            this.inputStream = new GnutellaInputStream(this.bandwidthInputStream);
        }
        return this.inputStream;
    }

    public int readPeek() throws IOException {
        return this.getInputStream().peek();
    }

    public String readLine() throws IOException {
        String line = this.getInputStream().readLine();
        return line;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        int val = this.getInputStream().read(b, offset, length);
        return val;
    }

    public GnutellaOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            if (this.socket == null) {
                throw new ConnectionClosedException("Connection already closed");
            }
            this.bandwidthOutputStream = new BandwidthOutputStream(this.socket.getOutputStream(), this.bandwidthController);
            this.outputStream = new GnutellaOutputStream(this.bandwidthOutputStream);
        }
        return this.outputStream;
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        this.getOutputStream().write(b, offset, length);
    }

    public void write(byte[] b) throws IOException {
        this.getOutputStream().write(b);
    }

    public void flush() throws IOException {
        this.getOutputStream().flush();
    }

    public void disconnect() {
        NLogger.debug("Network", (Object)("Disconnecting socket " + this.socket));
        IOUtil.closeQuietly(this.inputStream);
        IOUtil.closeQuietly(this.outputStream);
        IOUtil.closeQuietly(this.socket);
        this.inputStream = null;
        this.outputStream = null;
        this.socket = null;
    }
}

